/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.network;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public class REQID {
    public static final int REQID_SIZE = 32;
    public static REQID zeroREQID = REQID.generateZero();
    private static Random randomGenerator = new Random(System.nanoTime());
    private byte[] bytes;

    public REQID(byte[] byArray) {
        assert (byArray.length == 32);
        this.bytes = new byte[32];
        System.arraycopy(byArray, 0, this.bytes, 0, byArray.length);
    }

    public REQID(ByteBuffer byteBuffer) {
        this.bytes = new byte[32];
        byteBuffer.get(this.bytes);
    }

    public static REQID generate() {
        byte[] byArray = new byte[32];
        randomGenerator.nextBytes(byArray);
        return new REQID(byArray);
    }

    private static REQID generateZero() {
        byte[] byArray = new byte[32];
        Arrays.fill(byArray, (byte)0);
        return new REQID(byArray);
    }

    public void pack(ByteBuffer byteBuffer) {
        byteBuffer.put(this.bytes);
    }

    public byte[] value() {
        return this.bytes;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof REQID)) {
            return false;
        }
        REQID rEQID = (REQID)object;
        return Arrays.equals(this.bytes, rEQID.value());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.bytes.length; ++i) {
            stringBuilder.append(String.format("%02X ", this.bytes[i]));
        }
        return stringBuilder.toString();
    }
}

