/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.network;

import com.twitter.heron.common.basics.ISelectHandler;
import com.twitter.heron.common.basics.NIOLooper;
import com.twitter.heron.common.network.HeronSocketOptions;
import com.twitter.heron.common.network.IncomingPacket;
import com.twitter.heron.common.network.OutgoingPacket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;

public class SocketChannelHelper {
    private static final Logger LOG = Logger.getLogger(SocketChannelHelper.class.getName());
    private NIOLooper looper;
    private ISelectHandler selectHandler;
    private SocketChannel socketChannel;
    private Queue<OutgoingPacket> outgoingPacketsToWrite;
    private IncomingPacket incomingPacket;
    private long totalPacketsRead;
    private long totalPacketsWritten;
    private long totalBytesRead;
    private long totalBytesWritten;
    private long writeBatchSizeInBytes;
    private long writeBatchTimeInNs;
    private long readBatchSizeInBytes;
    private long readReadBatchTimeInNs;

    public SocketChannelHelper(NIOLooper nIOLooper, ISelectHandler iSelectHandler, SocketChannel socketChannel, HeronSocketOptions heronSocketOptions) {
        this.looper = nIOLooper;
        this.selectHandler = iSelectHandler;
        this.socketChannel = socketChannel;
        this.outgoingPacketsToWrite = new LinkedList<OutgoingPacket>();
        this.incomingPacket = new IncomingPacket();
        this.writeBatchSizeInBytes = heronSocketOptions.getNetworkWriteBatchSizeInBytes();
        this.writeBatchTimeInNs = heronSocketOptions.getNetworkWriteBatchTimeInMs() * 1000000L;
        this.readBatchSizeInBytes = heronSocketOptions.getNetworkReadBatchSizeInBytes();
        this.readReadBatchTimeInNs = heronSocketOptions.getNetworkReadBatchTimeInMs() * 1000000L;
        this.enableReading();
    }

    public void clear() {
        this.outgoingPacketsToWrite.clear();
    }

    public boolean sendPacket(OutgoingPacket outgoingPacket) {
        this.outgoingPacketsToWrite.add(outgoingPacket);
        this.enableWriting();
        return true;
    }

    public List<IncomingPacket> read() {
        int n;
        long l;
        long l2 = System.nanoTime();
        long l3 = 0L;
        ArrayList<IncomingPacket> arrayList = new ArrayList<IncomingPacket>();
        for (l = 0L; System.nanoTime() - l2 - this.readReadBatchTimeInNs < 0L && l < this.readBatchSizeInBytes && (n = this.incomingPacket.readFromChannel(this.socketChannel)) <= 0; l += (long)this.incomingPacket.size()) {
            if (n < 0) {
                LOG.severe("Something bad happened while reading from channel: " + this.socketChannel.socket().getRemoteSocketAddress());
                this.selectHandler.handleError(this.socketChannel);
                arrayList.clear();
                break;
            }
            ++l3;
            arrayList.add(this.incomingPacket);
            this.incomingPacket = new IncomingPacket();
        }
        this.totalPacketsRead += l3;
        this.totalBytesRead += l;
        return arrayList;
    }

    public void write() {
        int n;
        OutgoingPacket outgoingPacket;
        long l = System.nanoTime();
        long l2 = 0L;
        long l3 = 0L;
        while (System.nanoTime() - l - this.writeBatchTimeInNs < 0L && l2 < this.writeBatchSizeInBytes && (outgoingPacket = this.outgoingPacketsToWrite.peek()) != null && (n = outgoingPacket.writeToChannel(this.socketChannel)) <= 0) {
            if (n < 0) {
                LOG.severe("Something bad happened while writing to channel");
                this.selectHandler.handleError(this.socketChannel);
                return;
            }
            l2 += (long)outgoingPacket.size();
            ++l3;
            this.outgoingPacketsToWrite.remove();
        }
        this.totalPacketsWritten += l3;
        this.totalBytesWritten += l2;
        if (this.getOutstandingPackets() == 0) {
            this.disableWriting();
        }
    }

    public void forceFlushWithBestEffort() {
        LOG.info("Forcing to flush data to socket with best effort.");
        while (!this.outgoingPacketsToWrite.isEmpty()) {
            int n = this.outgoingPacketsToWrite.poll().writeToChannel(this.socketChannel);
            if (n == 0) continue;
            LOG.info("Failed to write more to Socket. Clear and finish the flush.");
            this.clear();
            return;
        }
    }

    public void enableReading() {
        if (!this.looper.isReadRegistered(this.socketChannel)) {
            try {
                this.looper.registerRead(this.socketChannel, this.selectHandler);
            }
            catch (ClosedChannelException closedChannelException) {
                this.selectHandler.handleError(this.socketChannel);
            }
        }
    }

    public void disableReading() {
        if (this.looper.isReadRegistered(this.socketChannel)) {
            this.looper.unregisterRead(this.socketChannel);
        }
    }

    public void enableWriting() {
        if (!this.looper.isWriteRegistered(this.socketChannel)) {
            try {
                this.looper.registerWrite(this.socketChannel, this.selectHandler);
            }
            catch (ClosedChannelException closedChannelException) {
                this.selectHandler.handleError(this.socketChannel);
            }
        }
    }

    public void disableWriting() {
        if (this.looper.isWriteRegistered(this.socketChannel)) {
            this.looper.unregisterWrite(this.socketChannel);
        }
    }

    public int getOutstandingPackets() {
        return this.outgoingPacketsToWrite.size();
    }

    public boolean hasPacketsToSend() {
        return this.outgoingPacketsToWrite.size() > 0;
    }

    public long getTotalPacketsWritten() {
        return this.totalPacketsWritten;
    }

    public long getTotalPacketsRead() {
        return this.totalPacketsRead;
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }
}

