/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.logging;

import com.twitter.heron.api.metric.IMetric;
import com.twitter.heron.common.utils.metrics.MetricsCollector;
import com.twitter.heron.proto.system.Metrics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class ErrorReportLoggingHandler
extends Handler {
    public static final String NO_TRACE = "No Trace";
    public static volatile boolean initialized = false;

    public static String getExceptionLocation(String string) {
        if (string == null) {
            return NO_TRACE;
        }
        String[] stringArray = string.split("\n");
        if (stringArray.length == 0) {
            return NO_TRACE;
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        return stringArray[0] + "\n" + stringArray[1];
    }

    public static synchronized void init(String string, MetricsCollector metricsCollector, int n) {
        if (!initialized) {
            metricsCollector.registerMetric("exception_info", ExceptionRepositoryAsMetrics.INSTANCE, n);
        }
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
            String string = stringWriter.toString();
            ExceptionRepositoryAsMetrics exceptionRepositoryAsMetrics = ExceptionRepositoryAsMetrics.INSTANCE;
            synchronized (exceptionRepositoryAsMetrics) {
                Metrics.ExceptionData.Builder builder = ExceptionRepositoryAsMetrics.INSTANCE.getExceptionInfo(string);
                builder.setCount(builder.getCount() + 1);
                builder.setLasttime(new Date().toString());
                builder.setStacktrace(string);
                builder.setLogging("" + logRecord.getMessage());
            }
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        System.out.print(ExceptionRepositoryAsMetrics.INSTANCE.getValue().toString());
    }

    public static enum ExceptionRepositoryAsMetrics implements IMetric<Collection<Metrics.ExceptionData.Builder>>
    {
        INSTANCE;

        private HashMap<String, Metrics.ExceptionData.Builder> exceptionStore = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Metrics.ExceptionData.Builder> getValueAndReset() {
            ExceptionRepositoryAsMetrics exceptionRepositoryAsMetrics = INSTANCE;
            synchronized (exceptionRepositoryAsMetrics) {
                Collection<Metrics.ExceptionData.Builder> collection = this.exceptionStore.values();
                this.exceptionStore = new HashMap();
                return collection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() {
            ExceptionRepositoryAsMetrics exceptionRepositoryAsMetrics = INSTANCE;
            synchronized (exceptionRepositoryAsMetrics) {
                return this.exceptionStore.values();
            }
        }

        public Metrics.ExceptionData.Builder getExceptionInfo(String string) {
            Metrics.ExceptionData.Builder builder = this.exceptionStore.get(ErrorReportLoggingHandler.getExceptionLocation(string));
            if (builder == null) {
                builder = Metrics.ExceptionData.newBuilder();
                builder.setFirsttime(new Date().toString());
                builder.setCount(0);
                builder.setStacktrace(ErrorReportLoggingHandler.NO_TRACE);
                this.exceptionStore.put(ErrorReportLoggingHandler.getExceptionLocation(string), builder);
            }
            return builder;
        }
    }
}

