/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public final class LoggingHelper {
    public static final String FORMAT_PROP_KEY = "java.util.logging.SimpleFormatter.format";
    public static final String DEFAULT_FORMAT = "[%1$tF %1$tT %1$tz] %3$s %4$s:  %5$s %6$s %n";

    private LoggingHelper() {
    }

    public static void loggerInit(Level level, boolean bl) throws IOException {
        LoggingHelper.loggerInit(level, bl, DEFAULT_FORMAT);
    }

    public static void loggerInit(Level level, boolean bl, String string) throws IOException {
        LoggingHelper.setLoggingFormat(string);
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            handler.setLevel(level);
        }
        logger.setLevel(level);
        if (bl) {
            for (Handler handler : logger.getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                logger.removeHandler(handler);
            }
            Logger logger2 = Logger.getLogger("stdout");
            LoggingOutputStream loggingOutputStream = new LoggingOutputStream(logger2, StdOutErrLevel.STDOUT);
            System.setOut(new PrintStream(loggingOutputStream, true));
            Logger logger3 = Logger.getLogger("stderr");
            loggingOutputStream = new LoggingOutputStream(logger3, StdOutErrLevel.STDERR);
            System.setErr(new PrintStream(loggingOutputStream, true));
        }
    }

    protected static void setLoggingFormat(String string) {
        System.setProperty(FORMAT_PROP_KEY, string);
    }

    public static void addLoggingHandler(Handler handler) {
        Logger.getLogger("").addHandler(handler);
    }

    public static FileHandler getFileHandler(String string, String string2, boolean bl, int n, int n2) throws IOException, SecurityException {
        String string3 = string2 + "/" + string + ".log.%g";
        FileHandler fileHandler = new FileHandler(string3, n, n2, bl);
        fileHandler.setFormatter(new SimpleFormatter());
        fileHandler.setEncoding("UTF-8");
        return fileHandler;
    }

    public static class LoggingOutputStream
    extends ByteArrayOutputStream {
        private String lineSeparator;
        private Logger logger;
        private Level level;

        public LoggingOutputStream(Logger logger, Level level) {
            this.logger = logger;
            this.level = level;
            this.lineSeparator = System.getProperty("line.separator");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            LoggingOutputStream loggingOutputStream = this;
            synchronized (loggingOutputStream) {
                super.flush();
                String string = this.toString();
                super.reset();
                if (string.length() == 0 || string.equals(this.lineSeparator)) {
                    return;
                }
                this.logger.logp(this.level, "", "", string);
            }
        }
    }

    public static final class StdOutErrLevel
    extends Level {
        private static final long serialVersionUID = -3442332825945855738L;
        public static final Level STDOUT = new StdOutErrLevel("STDOUT", Level.INFO.intValue() + 53);
        public static final Level STDERR = new StdOutErrLevel("STDERR", Level.INFO.intValue() + 54);

        private StdOutErrLevel(String string, int n) {
            super(string, n);
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.intValue() == STDOUT.intValue()) {
                return STDOUT;
            }
            if (this.intValue() == STDERR.intValue()) {
                return STDERR;
            }
            throw new InvalidObjectException("Unknown instance :" + this);
        }
    }
}

