/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.metrics;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.metric.CountMetric;
import com.twitter.heron.api.metric.MeanReducer;
import com.twitter.heron.api.metric.MeanReducerState;
import com.twitter.heron.api.metric.MultiCountMetric;
import com.twitter.heron.api.metric.MultiReducedMetric;
import com.twitter.heron.common.basics.SingletonRegistry;
import com.twitter.heron.common.config.SystemConfig;
import com.twitter.heron.common.utils.misc.PhysicalPlanHelper;
import com.twitter.heron.common.utils.topology.TopologyContextImpl;
import java.util.Iterator;
import java.util.List;

public class BoltMetrics {
    private final MultiCountMetric ackCount = new MultiCountMetric();
    private final MultiReducedMetric<MeanReducerState, Number, Double> processLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiReducedMetric<MeanReducerState, Number, Double> failLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiCountMetric failCount = new MultiCountMetric();
    private final MultiCountMetric executeCount = new MultiCountMetric();
    private final MultiReducedMetric<MeanReducerState, Number, Double> executeLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiCountMetric executeTimeNs = new MultiCountMetric();
    private final MultiCountMetric emitCount = new MultiCountMetric();
    private final MultiCountMetric deserializationTimeNs;
    private final MultiCountMetric serializationTimeNs;
    private final CountMetric outQueueFullCount = new CountMetric();

    public BoltMetrics() {
        this.deserializationTimeNs = new MultiCountMetric();
        this.serializationTimeNs = new MultiCountMetric();
    }

    public void registerMetrics(TopologyContextImpl topologyContextImpl) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int n = systemConfig.getHeronMetricsExportIntervalSec();
        topologyContextImpl.registerMetric("__ack-count", this.ackCount, n);
        topologyContextImpl.registerMetric("__process-latency", this.processLatency, n);
        topologyContextImpl.registerMetric("__fail-latency", this.failLatency, n);
        topologyContextImpl.registerMetric("__fail-count", this.failCount, n);
        topologyContextImpl.registerMetric("__execute-count", this.executeCount, n);
        topologyContextImpl.registerMetric("__execute-latency", this.executeLatency, n);
        topologyContextImpl.registerMetric("__execute-time-ns", this.executeTimeNs, n);
        topologyContextImpl.registerMetric("__emit-count", this.emitCount, n);
        topologyContextImpl.registerMetric("__out-queue-full-count", this.outQueueFullCount, n);
        topologyContextImpl.registerMetric("__tuple-deserialization-time-ns", this.deserializationTimeNs, n);
        topologyContextImpl.registerMetric("__tuple-serialization-time-ns", this.serializationTimeNs, n);
    }

    public void initMultiCountMetrics(PhysicalPlanHelper physicalPlanHelper) {
        String string;
        Object object;
        List<TopologyAPI.InputStream> list = physicalPlanHelper.getMyBolt().getInputsList();
        for (TopologyAPI.InputStream object22 : list) {
            object = object22.getStream().getId();
            string = object22.getStream().getComponentName() + "/" + (String)object;
            this.ackCount.scope((String)object);
            this.failCount.scope((String)object);
            this.executeCount.scope((String)object);
            this.executeTimeNs.scope((String)object);
            this.ackCount.scope(string);
            this.failCount.scope(string);
            this.executeCount.scope(string);
            this.executeTimeNs.scope(string);
        }
        List<TopologyAPI.OutputStream> list2 = physicalPlanHelper.getMyBolt().getOutputsList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (TopologyAPI.OutputStream)iterator.next();
            string = ((TopologyAPI.OutputStream)object).getStream().getId();
            this.emitCount.scope(string);
        }
    }

    public void ackedTuple(String string, String string2, long l) {
        this.ackCount.scope(string).incr();
        this.processLatency.scope(string).update(l);
        String string3 = string2 + "/" + string;
        this.ackCount.scope(string3).incr();
        this.processLatency.scope(string3).update(l);
    }

    public void failedTuple(String string, String string2, long l) {
        this.failCount.scope(string).incr();
        this.failLatency.scope(string).update(l);
        String string3 = string2 + "/" + string;
        this.failCount.scope(string3).incr();
        this.failLatency.scope(string3).update(l);
    }

    public void executeTuple(String string, String string2, long l) {
        this.executeCount.scope(string).incr();
        this.executeLatency.scope(string).update(l);
        this.executeTimeNs.scope(string).incrBy(l);
        String string3 = string2 + "/" + string;
        this.executeCount.scope(string3).incr();
        this.executeLatency.scope(string3).update(l);
        this.executeTimeNs.scope(string3).incrBy(l);
    }

    public void emittedTuple(String string) {
        this.emitCount.scope(string).incr();
    }

    public void updateOutQueueFullCount() {
        this.outQueueFullCount.incr();
    }

    public void deserializeDataTuple(String string, String string2, long l) {
        this.deserializationTimeNs.scope(string).incrBy(l);
        String string3 = string2 + "/" + string;
        this.deserializationTimeNs.scope(string3).incrBy(l);
    }

    public void serializeDataTuple(String string, long l) {
        this.serializationTimeNs.scope(string).incrBy(l);
    }
}

