/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.metrics;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import com.twitter.heron.api.metric.AssignableMetric;
import com.twitter.heron.api.metric.MeanReducer;
import com.twitter.heron.api.metric.MeanReducerState;
import com.twitter.heron.api.metric.MultiAssignableMetric;
import com.twitter.heron.api.metric.ReducedMetric;
import com.twitter.heron.common.basics.SingletonRegistry;
import com.twitter.heron.common.config.SystemConfig;
import com.twitter.heron.common.utils.metrics.MetricsCollector;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;

public class JVMMetrics {
    private final Runtime runtime = Runtime.getRuntime();
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final java.lang.management.OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final List<MemoryPoolMXBean> memoryPoolMXBeanList = ManagementFactory.getMemoryPoolMXBeans();
    private final List<BufferPoolMXBean> bufferPoolMXBeanList = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    private final MultiAssignableMetric<Long> jvmGCTimeMsPerGCType;
    private final MultiAssignableMetric<Long> jvmGCCountPerGCType;
    private final AssignableMetric<Integer> jvmThreadCount;
    private final AssignableMetric<Integer> jvmDaemonThreadCount;
    private final AssignableMetric<Long> fdCount;
    private final AssignableMetric<Long> fdLimit;
    private AssignableMetric<Long> jvmGCTimeMs = new AssignableMetric<Long>(0L);
    private AssignableMetric<Long> jvmGCCount = new AssignableMetric<Long>(0L);
    private AssignableMetric<Long> jvmUpTimeSecs;
    private AssignableMetric<Long> processCPUTimeNs;
    private MultiAssignableMetric<Long> threadsCPUTimeNs;
    private AssignableMetric<Long> otherThreadsCPUTimeNs;
    private MultiAssignableMetric<Long> threadsUserCPUTimeNs;
    private AssignableMetric<Long> otherThreadsUserCPUTimeNs;
    private ReducedMetric<MeanReducerState, Number, Double> processCPULoad;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryFreeMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryUsedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryTotalMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryHeapUsedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryHeapCommittedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryHeapMaxMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryNonHeapUsedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryNonHeapCommittedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryNonHeapMaxMB;
    private MultiAssignableMetric<Long> jvmPeakUsagePerMemoryPool;
    private MultiAssignableMetric<Long> jvmCollectionUsagePerMemoryPool;
    private MultiAssignableMetric<Long> jvmEstimatedUsagePerMemoryPool;
    private MultiAssignableMetric<Long> jvmBufferPoolMemoryUsage;

    public JVMMetrics() {
        this.jvmGCCountPerGCType = new MultiAssignableMetric<Long>(0L);
        this.jvmGCTimeMsPerGCType = new MultiAssignableMetric<Long>(0L);
        this.jvmUpTimeSecs = new AssignableMetric<Long>(0L);
        this.jvmThreadCount = new AssignableMetric<Integer>(0);
        this.jvmDaemonThreadCount = new AssignableMetric<Integer>(0);
        this.processCPUTimeNs = new AssignableMetric<Long>(0L);
        this.threadsCPUTimeNs = new MultiAssignableMetric<Long>(0L);
        this.otherThreadsCPUTimeNs = new AssignableMetric<Long>(0L);
        this.threadsUserCPUTimeNs = new MultiAssignableMetric<Long>(0L);
        this.otherThreadsUserCPUTimeNs = new AssignableMetric<Long>(0L);
        this.processCPULoad = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.fdCount = new AssignableMetric<Long>(0L);
        this.fdLimit = new AssignableMetric<Long>(0L);
        this.jvmMemoryFreeMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryUsedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryTotalMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryHeapUsedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryHeapCommittedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryHeapMaxMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryNonHeapUsedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryNonHeapCommittedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryNonHeapMaxMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmPeakUsagePerMemoryPool = new MultiAssignableMetric<Long>(0L);
        this.jvmCollectionUsagePerMemoryPool = new MultiAssignableMetric<Long>(0L);
        this.jvmEstimatedUsagePerMemoryPool = new MultiAssignableMetric<Long>(0L);
        this.jvmBufferPoolMemoryUsage = new MultiAssignableMetric<Long>(0L);
    }

    public void registerMetrics(MetricsCollector metricsCollector) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int n = systemConfig.getHeronMetricsExportIntervalSec();
        metricsCollector.registerMetric("__jvm-gc-collection-time-ms", this.jvmGCTimeMs, n);
        metricsCollector.registerMetric("__jvm-gc-collection-count", this.jvmGCCount, n);
        metricsCollector.registerMetric("__jvm-gc-time-ms", this.jvmGCTimeMsPerGCType, n);
        metricsCollector.registerMetric("__jvm-gc-count", this.jvmGCCountPerGCType, n);
        metricsCollector.registerMetric("__jvm-uptime-secs", this.jvmUpTimeSecs, n);
        metricsCollector.registerMetric("__jvm-thread-count", this.jvmThreadCount, n);
        metricsCollector.registerMetric("__jvm-daemon-thread-count", this.jvmDaemonThreadCount, n);
        metricsCollector.registerMetric("__jvm-process-cpu-time-nanos", this.processCPUTimeNs, n);
        metricsCollector.registerMetric("__jvm-threads-cpu-time-nanos", this.threadsCPUTimeNs, n);
        metricsCollector.registerMetric("__jvm-other-threads-cpu-time-nanos", this.otherThreadsCPUTimeNs, n);
        metricsCollector.registerMetric("__jvm-threads-user-cpu-time-nanos", this.threadsUserCPUTimeNs, n);
        metricsCollector.registerMetric("__jvm-other-threads-user-cpu-time-nanos", this.otherThreadsUserCPUTimeNs, n);
        metricsCollector.registerMetric("__jvm-process-cpu-load", this.processCPULoad, n);
        metricsCollector.registerMetric("__jvm-fd-count", this.fdCount, n);
        metricsCollector.registerMetric("__jvm-fd-limit", this.fdLimit, n);
        metricsCollector.registerMetric("__jvm-memory-free-mb", this.jvmMemoryFreeMB, n);
        metricsCollector.registerMetric("__jvm-memory-used-mb", this.jvmMemoryUsedMB, n);
        metricsCollector.registerMetric("__jvm-memory-mb-total", this.jvmMemoryTotalMB, n);
        metricsCollector.registerMetric("__jvm-memory-heap-mb-used", this.jvmMemoryHeapUsedMB, n);
        metricsCollector.registerMetric("__jvm-memory-heap-mb-committed", this.jvmMemoryHeapCommittedMB, n);
        metricsCollector.registerMetric("__jvm-memory-heap-mb-max", this.jvmMemoryHeapMaxMB, n);
        metricsCollector.registerMetric("__jvm-memory-non-heap-mb-used", this.jvmMemoryNonHeapUsedMB, n);
        metricsCollector.registerMetric("__jvm-memory-non-heap-mb-committed", this.jvmMemoryNonHeapCommittedMB, n);
        metricsCollector.registerMetric("__jvm-memory-non-heap-mb-max", this.jvmMemoryNonHeapMaxMB, n);
        metricsCollector.registerMetric("__jvm-peak-usage", this.jvmPeakUsagePerMemoryPool, n);
        metricsCollector.registerMetric("__jvm-collection-usage", this.jvmCollectionUsagePerMemoryPool, n);
        metricsCollector.registerMetric("__jvm-estimated-usage", this.jvmEstimatedUsagePerMemoryPool, n);
        metricsCollector.registerMetric("__jvm-buffer-pool", this.jvmBufferPoolMemoryUsage, n);
    }

    public Runnable getJVMSampleRunnable() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JVMMetrics.this.updateGcMetrics();
                JVMMetrics.this.jvmUpTimeSecs.setValue(JVMMetrics.this.runtimeMXBean.getUptime() / 1000L);
                JVMMetrics.this.processCPUTimeNs.setValue(JVMMetrics.this.getProcessCPUTimeNs());
                JVMMetrics.this.getThreadsMetrics();
                JVMMetrics.this.processCPULoad.update(JVMMetrics.this.getProcessCPULoad() * (double)JVMMetrics.this.runtime.availableProcessors());
                JVMMetrics.this.updateFdMetrics();
                JVMMetrics.this.updateMemoryPoolMetrics();
                JVMMetrics.this.updateBufferPoolMetrics();
                long l = JVMMetrics.this.runtime.freeMemory();
                long l2 = JVMMetrics.this.runtime.totalMemory();
                JVMMetrics.this.jvmMemoryFreeMB.update(l / 0x100000L);
                JVMMetrics.this.jvmMemoryTotalMB.update(l2 / 0x100000L);
                JVMMetrics.this.jvmMemoryUsedMB.update((l2 - l) / 0x100000L);
                JVMMetrics.this.jvmMemoryHeapUsedMB.update(JVMMetrics.this.memoryBean.getHeapMemoryUsage().getUsed() / 0x100000L);
                JVMMetrics.this.jvmMemoryHeapCommittedMB.update(JVMMetrics.this.memoryBean.getHeapMemoryUsage().getCommitted() / 0x100000L);
                JVMMetrics.this.jvmMemoryHeapMaxMB.update(JVMMetrics.this.memoryBean.getHeapMemoryUsage().getMax() / 0x100000L);
                JVMMetrics.this.jvmMemoryNonHeapUsedMB.update(JVMMetrics.this.memoryBean.getNonHeapMemoryUsage().getUsed() / 0x100000L);
                JVMMetrics.this.jvmMemoryNonHeapCommittedMB.update(JVMMetrics.this.memoryBean.getNonHeapMemoryUsage().getCommitted() / 0x100000L);
                JVMMetrics.this.jvmMemoryNonHeapMaxMB.update(JVMMetrics.this.memoryBean.getNonHeapMemoryUsage().getMax() / 0x100000L);
            }
        };
        return runnable;
    }

    private void updateBufferPoolMetrics() {
        for (BufferPoolMXBean bufferPoolMXBean : this.bufferPoolMXBeanList) {
            String string = bufferPoolMXBean.getName().replaceAll("[^\\w]", "-");
            long l = bufferPoolMXBean.getMemoryUsed() / 0x100000L;
            long l2 = bufferPoolMXBean.getTotalCapacity() / 0x100000L;
            long l3 = bufferPoolMXBean.getCount() / 0x100000L;
            this.jvmBufferPoolMemoryUsage.safeScope(string + "-memory-used").setValue(l);
            this.jvmBufferPoolMemoryUsage.safeScope(string + "-total-capacity").setValue(l2);
            this.jvmBufferPoolMemoryUsage.safeScope(string + "-count").setValue(l3);
        }
    }

    private void updateMemoryPoolMetrics() {
        for (MemoryPoolMXBean memoryPoolMXBean : this.memoryPoolMXBeanList) {
            MemoryUsage memoryUsage;
            MemoryUsage memoryUsage2;
            String string = memoryPoolMXBean.getName().replaceAll("[^\\w]", "-");
            MemoryUsage memoryUsage3 = memoryPoolMXBean.getPeakUsage();
            if (memoryUsage3 != null) {
                this.jvmPeakUsagePerMemoryPool.safeScope(string + "-used").setValue(memoryUsage3.getUsed() / 0x100000L);
                this.jvmPeakUsagePerMemoryPool.safeScope(string + "-committed").setValue(memoryUsage3.getCommitted() / 0x100000L);
                this.jvmPeakUsagePerMemoryPool.safeScope(string + "-max").setValue(memoryUsage3.getMax() / 0x100000L);
            }
            if ((memoryUsage2 = memoryPoolMXBean.getCollectionUsage()) != null) {
                this.jvmCollectionUsagePerMemoryPool.safeScope(string + "-used").setValue(memoryUsage2.getUsed() / 0x100000L);
                this.jvmCollectionUsagePerMemoryPool.safeScope(string + "-committed").setValue(memoryUsage2.getCommitted() / 0x100000L);
                this.jvmCollectionUsagePerMemoryPool.safeScope(string + "-max").setValue(memoryUsage2.getMax() / 0x100000L);
            }
            if ((memoryUsage = memoryPoolMXBean.getUsage()) == null) continue;
            this.jvmEstimatedUsagePerMemoryPool.safeScope(string + "-used").setValue(memoryUsage.getUsed() / 0x100000L);
            this.jvmEstimatedUsagePerMemoryPool.safeScope(string + "-committed").setValue(memoryUsage.getCommitted() / 0x100000L);
            this.jvmEstimatedUsagePerMemoryPool.safeScope(string + "-max").setValue(memoryUsage.getMax() / 0x100000L);
        }
    }

    private void getThreadsMetrics() {
        if (this.threadMXBean.isThreadCpuTimeSupported()) {
            this.threadMXBean.setThreadCpuTimeEnabled(true);
            long l = 0L;
            long l2 = 0L;
            for (long l3 : this.threadMXBean.getAllThreadIds()) {
                long l4 = this.threadMXBean.getThreadCpuTime(l3);
                long l5 = this.threadMXBean.getThreadUserTime(l3);
                ThreadInfo threadInfo = this.threadMXBean.getThreadInfo(l3);
                if (threadInfo == null) continue;
                String string = threadInfo.getThreadName();
                if (string.equals("GatewayThread") || string.equals("SlaveThread")) {
                    this.threadsCPUTimeNs.scope(string).setValue(l4);
                    this.threadsUserCPUTimeNs.scope(string).setValue(l5);
                    continue;
                }
                l += l4;
                l2 += l5;
            }
            this.otherThreadsCPUTimeNs.setValue(l);
            this.otherThreadsUserCPUTimeNs.setValue(l2);
            this.jvmThreadCount.setValue(this.threadMXBean.getThreadCount());
            this.jvmDaemonThreadCount.setValue(this.threadMXBean.getDaemonThreadCount());
        }
    }

    private void updateGcMetrics() {
        this.updateGcTimes();
        this.updateGcCounts();
    }

    private void updateGcTimes() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long l2 = garbageCollectorMXBean.getCollectionTime();
            l += l2;
            String string = garbageCollectorMXBean.getName().replaceAll("[^\\w]", "-");
            this.jvmGCTimeMsPerGCType.safeScope(string).setValue(l2);
        }
        this.jvmGCTimeMs.setValue(l);
    }

    private void updateGcCounts() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long l2 = garbageCollectorMXBean.getCollectionCount();
            l += l2;
            String string = garbageCollectorMXBean.getName().replaceAll("[^\\w]", "-");
            this.jvmGCCountPerGCType.safeScope(string).setValue(l2);
        }
        this.jvmGCCount.setValue(l);
    }

    private long getProcessCPUTimeNs() {
        if (this.osMbean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)this.osMbean;
            return operatingSystemMXBean.getProcessCpuTime();
        }
        return -1L;
    }

    private double getProcessCPULoad() {
        if (this.osMbean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)this.osMbean;
            return operatingSystemMXBean.getProcessCpuLoad();
        }
        return -1.0;
    }

    private void updateFdMetrics() {
        if (this.osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixOperatingSystemMXBean = (UnixOperatingSystemMXBean)this.osMbean;
            this.fdCount.setValue(unixOperatingSystemMXBean.getOpenFileDescriptorCount());
            this.fdLimit.setValue(unixOperatingSystemMXBean.getMaxFileDescriptorCount());
        }
    }
}

