/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.metrics;

import com.twitter.heron.api.metric.IMetric;
import com.twitter.heron.api.metric.IMetricsRegister;
import com.twitter.heron.common.basics.Communicator;
import com.twitter.heron.common.basics.WakeableLooper;
import com.twitter.heron.proto.system.Metrics;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MetricsCollector
implements IMetricsRegister {
    private static final Logger LOG = Logger.getLogger(MetricsCollector.class.getName());
    private Map<String, IMetric<?>> metrics = new HashMap();
    private Map<Integer, List<String>> timeBucketToMetricNames = new HashMap<Integer, List<String>>();
    private WakeableLooper runnableToGatherMetrics;
    private Communicator<Metrics.MetricPublisherPublishMessage> queue;

    public MetricsCollector(WakeableLooper wakeableLooper, Communicator<Metrics.MetricPublisherPublishMessage> communicator) {
        this.queue = communicator;
        this.runnableToGatherMetrics = wakeableLooper;
    }

    @Override
    public <T extends IMetric<U>, U> T registerMetric(String string, T t, final int n) {
        if (this.metrics.containsKey(string)) {
            throw new RuntimeException("Another metric has already been registered with name: " + string);
        }
        this.metrics.put(string, t);
        if (this.timeBucketToMetricNames.containsKey(n)) {
            this.timeBucketToMetricNames.get(n).add(string);
        } else {
            this.timeBucketToMetricNames.put(n, new LinkedList());
            this.timeBucketToMetricNames.get(n).add(string);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MetricsCollector.this.gatherMetrics(n);
                }
            };
            this.runnableToGatherMetrics.registerTimerEventInSeconds(n, runnable);
        }
        return t;
    }

    public void registerMetricSampleRunnable(final Runnable runnable, final long l) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                runnable.run();
                MetricsCollector.this.runnableToGatherMetrics.registerTimerEventInSeconds(l, this);
            }
        };
        this.runnableToGatherMetrics.registerTimerEventInSeconds(l, runnable2);
    }

    public void forceGatherAllMetrics() {
        LOG.info("Forcing to gather all metrics and flush out.");
        Metrics.MetricPublisherPublishMessage.Builder builder = Metrics.MetricPublisherPublishMessage.newBuilder();
        for (List<String> list : this.timeBucketToMetricNames.values()) {
            for (String string : list) {
                this.gatherOneMetric(string, builder);
            }
            Metrics.MetricPublisherPublishMessage metricPublisherPublishMessage = builder.build();
            this.queue.offer(metricPublisherPublishMessage);
        }
    }

    private void addDataToMetricPublisher(Metrics.MetricPublisherPublishMessage.Builder builder, String string, Object object) {
        if (object instanceof Metrics.MetricDatum.Builder) {
            builder.addMetrics((Metrics.MetricDatum.Builder)object);
        } else if (object instanceof Metrics.ExceptionData.Builder) {
            builder.addExceptions((Metrics.ExceptionData.Builder)object);
        } else {
            assert (string != null);
            Metrics.MetricDatum.Builder builder2 = Metrics.MetricDatum.newBuilder();
            builder2.setName(string).setValue(object.toString());
            builder.addMetrics(builder2);
        }
    }

    private void gatherMetrics(final int n) {
        if (this.timeBucketToMetricNames.containsKey(n)) {
            Metrics.MetricPublisherPublishMessage.Builder builder = Metrics.MetricPublisherPublishMessage.newBuilder();
            for (String object2 : this.timeBucketToMetricNames.get(n)) {
                this.gatherOneMetric(object2, builder);
            }
            Metrics.MetricPublisherPublishMessage metricPublisherPublishMessage = builder.build();
            this.queue.offer(metricPublisherPublishMessage);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MetricsCollector.this.gatherMetrics(n);
                }
            };
            this.runnableToGatherMetrics.registerTimerEventInSeconds(n, runnable);
        }
    }

    private void gatherOneMetric(String string, Metrics.MetricPublisherPublishMessage.Builder builder) {
        Object obj = this.metrics.get(string).getValueAndReset();
        if (obj == null) {
            return;
        }
        if (obj instanceof Map) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                this.addDataToMetricPublisher(builder, string + "/" + entry.getKey().toString(), entry.getValue());
            }
        } else if (obj instanceof Collection) {
            int n = 0;
            for (Object e : (Collection)obj) {
                this.addDataToMetricPublisher(builder, string + "/" + n++, e);
            }
        } else {
            this.addDataToMetricPublisher(builder, string, obj);
        }
    }
}

