/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.metrics;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.metric.CountMetric;
import com.twitter.heron.api.metric.MeanReducer;
import com.twitter.heron.api.metric.MeanReducerState;
import com.twitter.heron.api.metric.MultiCountMetric;
import com.twitter.heron.api.metric.MultiReducedMetric;
import com.twitter.heron.api.metric.ReducedMetric;
import com.twitter.heron.common.basics.SingletonRegistry;
import com.twitter.heron.common.config.SystemConfig;
import com.twitter.heron.common.utils.misc.PhysicalPlanHelper;
import com.twitter.heron.common.utils.topology.TopologyContextImpl;
import java.util.List;

public class SpoutMetrics {
    private final MultiCountMetric ackCount = new MultiCountMetric();
    private final MultiReducedMetric<MeanReducerState, Number, Double> completeLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiReducedMetric<MeanReducerState, Number, Double> failLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiCountMetric failCount = new MultiCountMetric();
    private final MultiCountMetric timeoutCount = new MultiCountMetric();
    private final MultiCountMetric emitCount = new MultiCountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> nextTupleLatency = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final CountMetric nextTupleCount = new CountMetric();
    private final MultiCountMetric serializationTimeNs;
    private final CountMetric outQueueFullCount = new CountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> pendingTuplesCount = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());

    public SpoutMetrics() {
        this.serializationTimeNs = new MultiCountMetric();
    }

    public void registerMetrics(TopologyContextImpl topologyContextImpl) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int n = systemConfig.getHeronMetricsExportIntervalSec();
        topologyContextImpl.registerMetric("__ack-count", this.ackCount, n);
        topologyContextImpl.registerMetric("__complete-latency", this.completeLatency, n);
        topologyContextImpl.registerMetric("__fail-latency", this.failLatency, n);
        topologyContextImpl.registerMetric("__fail-count", this.failCount, n);
        topologyContextImpl.registerMetric("__timeout-count", this.timeoutCount, n);
        topologyContextImpl.registerMetric("__emit-count", this.emitCount, n);
        topologyContextImpl.registerMetric("__next-tuple-latency", this.nextTupleLatency, n);
        topologyContextImpl.registerMetric("__next-tuple-count", this.nextTupleCount, n);
        topologyContextImpl.registerMetric("__out-queue-full-count", this.outQueueFullCount, n);
        topologyContextImpl.registerMetric("__pending-acked-count", this.pendingTuplesCount, n);
        topologyContextImpl.registerMetric("__tuple-serialization-time-ns", this.serializationTimeNs, n);
    }

    public void initMultiCountMetrics(PhysicalPlanHelper physicalPlanHelper) {
        List<TopologyAPI.OutputStream> list = physicalPlanHelper.getMySpout().getOutputsList();
        for (TopologyAPI.OutputStream outputStream : list) {
            String string = outputStream.getStream().getId();
            this.ackCount.scope(string);
            this.failCount.scope(string);
            this.timeoutCount.scope(string);
            this.emitCount.scope(string);
        }
    }

    public void ackedTuple(String string, long l) {
        this.ackCount.scope(string).incr();
        this.completeLatency.scope(string).update(l);
    }

    public void failedTuple(String string, long l) {
        this.failCount.scope(string).incr();
        this.failLatency.scope(string).update(l);
    }

    public void timeoutTuple(String string) {
        this.timeoutCount.scope(string).incr();
    }

    public void emittedTuple(String string) {
        this.emitCount.scope(string).incr();
    }

    public void nextTuple(long l) {
        this.nextTupleLatency.update(l);
        this.nextTupleCount.incr();
    }

    public void updateOutQueueFullCount() {
        this.outQueueFullCount.incr();
    }

    public void updatePendingTuplesCount(long l) {
        this.pendingTuplesCount.update(l);
    }

    public void serializeDataTuple(String string, long l) {
        this.serializationTimeNs.scope(string).incrBy(l);
    }
}

