/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.misc;

import com.twitter.heron.api.grouping.CustomStreamGrouping;
import com.twitter.heron.api.topology.TopologyContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomStreamGroupingHelper {
    private final Map<String, List<Target>> targets = new HashMap<String, List<Target>>();

    public void add(String string, List<Integer> list, CustomStreamGrouping customStreamGrouping, String string2) {
        if (!this.targets.containsKey(string)) {
            this.targets.put(string, new ArrayList());
        }
        this.targets.get(string).add(new Target(list, customStreamGrouping, string2));
    }

    public void prepare(TopologyContext topologyContext) {
        for (Map.Entry<String, List<Target>> entry : this.targets.entrySet()) {
            for (Target target : entry.getValue()) {
                target.prepare(topologyContext, entry.getKey());
            }
        }
    }

    public List<Integer> chooseTasks(String string, List<Object> list) {
        List<Target> list2 = this.targets.get(string);
        if (list2 != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Target target : list2) {
                arrayList.addAll(target.chooseTasks(list));
            }
            return arrayList;
        }
        return null;
    }

    private static class Target {
        private final String componentName;
        private final List<Integer> taskIds;
        private final CustomStreamGrouping grouping;

        Target(List<Integer> list, CustomStreamGrouping customStreamGrouping, String string) {
            this.taskIds = list;
            this.grouping = customStreamGrouping;
            this.componentName = string;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public List<Integer> getTaskIds() {
            return this.taskIds;
        }

        public CustomStreamGrouping getGrouping() {
            return this.grouping;
        }

        public void prepare(TopologyContext topologyContext, String string) {
            this.grouping.prepare(topologyContext, this.componentName, string, this.taskIds);
        }

        public List<Integer> chooseTasks(List<Object> list) {
            return this.grouping.chooseTasks(list);
        }
    }
}

