/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.misc;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.grouping.CustomStreamGrouping;
import com.twitter.heron.api.topology.TopologyContext;
import com.twitter.heron.api.utils.Utils;
import com.twitter.heron.common.utils.metrics.MetricsCollector;
import com.twitter.heron.common.utils.misc.CustomStreamGroupingHelper;
import com.twitter.heron.common.utils.topology.TopologyContextImpl;
import com.twitter.heron.proto.system.PhysicalPlans;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PhysicalPlanHelper {
    private final PhysicalPlans.PhysicalPlan pplan;
    private final int myTaskId;
    private final String myComponent;
    private final String hostname;
    private final String myInstanceId;
    private final TopologyAPI.Component component;
    private final Map<String, Integer> outputSchema;
    private final CustomStreamGroupingHelper customGrouper;
    private PhysicalPlans.Instance myInstance;
    private TopologyAPI.Spout mySpout;
    private TopologyAPI.Bolt myBolt;
    private TopologyContextImpl topologyContext;

    public PhysicalPlanHelper(PhysicalPlans.PhysicalPlan physicalPlan, String string) {
        TopologyAPI.Component component;
        List<TopologyAPI.OutputStream> list;
        int n;
        this.pplan = physicalPlan;
        for (int i = 0; i < physicalPlan.getInstancesCount(); ++i) {
            if (!physicalPlan.getInstances(i).getInstanceId().equals(string)) continue;
            this.myInstance = physicalPlan.getInstances(i);
        }
        if (this.myInstance == null) {
            throw new RuntimeException("There was no instance that matched my id " + string);
        }
        this.myComponent = this.myInstance.getInfo().getComponentName();
        this.myTaskId = this.myInstance.getInfo().getTaskId();
        this.myInstanceId = this.myInstance.getInstanceId();
        TopologyAPI.Topology topology = physicalPlan.getTopology();
        for (n = 0; n < topology.getSpoutsCount(); ++n) {
            if (!topology.getSpouts(n).getComp().getName().equals(this.myComponent)) continue;
            this.mySpout = topology.getSpouts(n);
            break;
        }
        for (n = 0; n < topology.getBoltsCount(); ++n) {
            if (!topology.getBolts(n).getComp().getName().equals(this.myComponent)) continue;
            this.myBolt = topology.getBolts(n);
            break;
        }
        if (this.mySpout != null && this.myBolt != null) {
            throw new RuntimeException("MyTaskId is both a bolt or a spout " + this.myTaskId);
        }
        if (this.mySpout == null && this.myBolt == null) {
            throw new RuntimeException("MyTaskId is neither a bolt or a spout " + this.myTaskId);
        }
        this.outputSchema = new HashMap<String, Integer>();
        if (this.mySpout != null) {
            list = this.mySpout.getOutputsList();
            component = this.mySpout.getComp();
        } else {
            list = this.myBolt.getOutputsList();
            component = this.myBolt.getComp();
        }
        for (TopologyAPI.OutputStream object : list) {
            this.outputSchema.put(object.getStream().getId(), object.getSchema().getKeysCount());
        }
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("GetHostName failed");
        }
        this.component = component;
        this.customGrouper = new CustomStreamGroupingHelper();
        for (int i = 0; i < topology.getBoltsCount(); ++i) {
            for (TopologyAPI.InputStream inputStream : topology.getBolts(i).getInputsList()) {
                if (!inputStream.getStream().getComponentName().equals(this.myComponent) || inputStream.getGtype() != TopologyAPI.Grouping.CUSTOM) continue;
                CustomStreamGrouping customStreamGrouping = (CustomStreamGrouping)Utils.deserialize(inputStream.getCustomGroupingJavaObject().toByteArray());
                this.customGrouper.add(inputStream.getStream().getId(), this.GetTaskIdsAsListForComponent(topology.getBolts(i).getComp().getName()), customStreamGrouping, this.myComponent);
            }
        }
    }

    public void checkOutputSchema(String string, List<Object> list) {
        Integer n = this.outputSchema.get(string);
        if (n == null) {
            throw new RuntimeException(this.myComponent + " emitting stream " + string + " but was not declared in declareOutputFields");
        }
        if (!n.equals(list.size())) {
            throw new RuntimeException("Number of fields emitted in stream " + string + " does not match whats expected. Expected " + Integer.toString(n) + " Observed " + Integer.toString(list.size()));
        }
    }

    public TopologyAPI.TopologyState getTopologyState() {
        return this.pplan.getTopology().getState();
    }

    public int getMyTaskId() {
        return this.myTaskId;
    }

    public String getMyHostname() {
        return this.hostname;
    }

    public String getMyInstanceId() {
        return this.myInstanceId;
    }

    public int getMyInstanceIndex() {
        return this.myInstance.getInfo().getComponentIndex();
    }

    public String getMyComponent() {
        return this.myComponent;
    }

    public TopologyAPI.Spout getMySpout() {
        return this.mySpout;
    }

    public TopologyAPI.Bolt getMyBolt() {
        return this.myBolt;
    }

    public TopologyContextImpl getTopologyContext() {
        return this.topologyContext;
    }

    public void setTopologyContext(MetricsCollector metricsCollector) {
        this.topologyContext = new TopologyContextImpl(this.constructConfig(this.pplan.getTopology().getTopologyConfig(), this.component), this.pplan.getTopology(), this.makeTaskToComponentMap(), this.myTaskId, metricsCollector);
    }

    private Map<String, Object> constructConfig(TopologyAPI.Config config, TopologyAPI.Component component) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (TopologyAPI.Config.KeyValue keyValue : config.getKvsList()) {
            if (keyValue.hasValue()) {
                hashMap.put(keyValue.getKey(), keyValue.getValue());
                continue;
            }
            hashMap.put(keyValue.getKey(), Utils.deserialize(keyValue.getJavaSerializedValue().toByteArray()));
        }
        for (TopologyAPI.Config.KeyValue keyValue : component.getConfig().getKvsList()) {
            if (keyValue.hasValue()) {
                hashMap.put(keyValue.getKey(), keyValue.getValue());
                continue;
            }
            hashMap.put(keyValue.getKey(), Utils.deserialize(keyValue.getJavaSerializedValue().toByteArray()));
        }
        return hashMap;
    }

    private Map<Integer, String> makeTaskToComponentMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (PhysicalPlans.Instance instance : this.pplan.getInstancesList()) {
            hashMap.put(instance.getInfo().getTaskId(), instance.getInfo().getComponentName());
        }
        return hashMap;
    }

    private List<Integer> GetTaskIdsAsListForComponent(String string) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (PhysicalPlans.Instance instance : this.pplan.getInstancesList()) {
            if (!instance.getInfo().getComponentName().equals(string)) continue;
            linkedList.add(instance.getInfo().getTaskId());
        }
        return linkedList;
    }

    public void prepareForCustomStreamGrouping(TopologyContext topologyContext) {
        this.customGrouper.prepare(topologyContext);
    }

    public List<Integer> chooseTasksForCustomStreamGrouping(String string, List<Object> list) {
        return this.customGrouper.chooseTasks(string, list);
    }
}

