/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.topology;

import com.google.protobuf.GeneratedMessage;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.topology.GeneralTopologyContext;
import com.twitter.heron.api.tuple.Fields;
import com.twitter.heron.common.basics.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneralTopologyContextImpl
implements GeneralTopologyContext {
    private final TopologyAPI.Topology topology;
    private final Map<String, Object> topologyConfig;
    private final Map<Integer, String> taskToComponentMap;
    private final Map<String, List<TopologyAPI.InputStream>> inputs;
    private final Map<String, List<TopologyAPI.OutputStream>> outputs;
    private final Map<String, Map<String, Fields>> componentsOutputFields;

    public GeneralTopologyContextImpl(Map<String, Object> map, TopologyAPI.Topology topology, Map<Integer, String> map2) {
        GeneratedMessage generatedMessage;
        int n;
        this.topology = topology;
        this.topologyConfig = new HashMap<String, Object>(map);
        this.taskToComponentMap = map2;
        this.inputs = new HashMap<String, List<TopologyAPI.InputStream>>();
        this.outputs = new HashMap<String, List<TopologyAPI.OutputStream>>();
        this.componentsOutputFields = new HashMap<String, Map<String, Fields>>();
        for (n = 0; n < this.topology.getSpoutsCount(); ++n) {
            generatedMessage = this.topology.getSpouts(n);
            this.inputs.put(((TopologyAPI.Spout)generatedMessage).getComp().getName(), new LinkedList());
            this.outputs.put(((TopologyAPI.Spout)generatedMessage).getComp().getName(), ((TopologyAPI.Spout)generatedMessage).getOutputsList());
            this.componentsOutputFields.putAll(GeneralTopologyContextImpl.getOutputToComponentsFields(((TopologyAPI.Spout)generatedMessage).getOutputsList()));
        }
        for (n = 0; n < this.topology.getBoltsCount(); ++n) {
            generatedMessage = this.topology.getBolts(n);
            this.inputs.put(((TopologyAPI.Bolt)generatedMessage).getComp().getName(), ((TopologyAPI.Bolt)generatedMessage).getInputsList());
            this.outputs.put(((TopologyAPI.Bolt)generatedMessage).getComp().getName(), ((TopologyAPI.Bolt)generatedMessage).getOutputsList());
            this.componentsOutputFields.putAll(GeneralTopologyContextImpl.getOutputToComponentsFields(((TopologyAPI.Bolt)generatedMessage).getOutputsList()));
        }
    }

    public static Map<String, Map<String, Fields>> getOutputToComponentsFields(List<TopologyAPI.OutputStream> list) {
        HashMap<String, Map<String, Fields>> hashMap = new HashMap<String, Map<String, Fields>>();
        for (TopologyAPI.OutputStream outputStream : list) {
            String string = outputStream.getStream().getComponentName();
            String string2 = outputStream.getStream().getId();
            HashMap<String, Fields> hashMap2 = (HashMap<String, Fields>)hashMap.get(string);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, Fields>();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TopologyAPI.StreamSchema.KeyType keyType : outputStream.getSchema().getKeysList()) {
                arrayList.add(keyType.getKey());
            }
            hashMap2.put(string2, new Fields(arrayList));
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    public Map<String, Object> getTopologyConfig() {
        return this.topologyConfig;
    }

    @Override
    public String getTopologyId() {
        return this.topology.getId();
    }

    @Override
    public String getComponentId(int n) {
        if (this.taskToComponentMap.containsKey(n)) {
            return this.taskToComponentMap.get(n);
        }
        return null;
    }

    @Override
    public Set<String> getComponentStreams(String string) {
        if (this.outputs.containsKey(string)) {
            HashSet<String> hashSet = new HashSet<String>();
            List<TopologyAPI.OutputStream> list = this.outputs.get(string);
            for (TopologyAPI.OutputStream outputStream : list) {
                hashSet.add(outputStream.getStream().getId());
            }
            return hashSet;
        }
        return null;
    }

    @Override
    public List<Integer> getComponentTasks(String string) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (Map.Entry<Integer, String> entry : this.taskToComponentMap.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            linkedList.add(entry.getKey());
        }
        return linkedList;
    }

    @Override
    public Fields getComponentOutputFields(String string, String string2) {
        Map<String, Fields> map = this.componentsOutputFields.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    @Override
    public Map<TopologyAPI.StreamId, TopologyAPI.Grouping> getSources(String string) {
        if (this.inputs.containsKey(string)) {
            HashMap<TopologyAPI.StreamId, TopologyAPI.Grouping> hashMap = new HashMap<TopologyAPI.StreamId, TopologyAPI.Grouping>();
            for (TopologyAPI.InputStream inputStream : this.inputs.get(string)) {
                hashMap.put(inputStream.getStream(), inputStream.getGtype());
            }
            return hashMap;
        }
        return null;
    }

    @Override
    public Map<String, Map<String, TopologyAPI.Grouping>> getTargets(String string) {
        HashMap<String, Map<String, TopologyAPI.Grouping>> hashMap = new HashMap<String, Map<String, TopologyAPI.Grouping>>();
        if (!this.outputs.containsKey(string)) {
            return hashMap;
        }
        for (TopologyAPI.OutputStream outputStream : this.outputs.get(string)) {
            HashMap<String, TopologyAPI.Grouping> hashMap2 = new HashMap<String, TopologyAPI.Grouping>();
            for (Map.Entry<String, List<TopologyAPI.InputStream>> entry : this.inputs.entrySet()) {
                String string2 = entry.getKey();
                for (TopologyAPI.InputStream inputStream : entry.getValue()) {
                    if (!this.areStreamsEqual(outputStream.getStream(), inputStream.getStream())) continue;
                    hashMap2.put(string2, inputStream.getGtype());
                }
            }
            hashMap.put(outputStream.getStream().getId(), hashMap2);
        }
        return hashMap;
    }

    @Override
    public Map<Integer, String> getTaskToComponent() {
        return this.taskToComponentMap;
    }

    @Override
    public Set<String> getComponentIds() {
        return this.inputs.keySet();
    }

    @Override
    public int maxTopologyMessageTimeout() {
        return TypeUtils.getInteger(this.topologyConfig.get("topology.message.timeout.secs"));
    }

    private boolean areStreamsEqual(TopologyAPI.StreamId streamId, TopologyAPI.StreamId streamId2) {
        return streamId.getId().equals(streamId2.getId()) && streamId.getComponentName().equals(streamId2.getComponentName());
    }
}

