/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.topology;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.hooks.ITaskHook;
import com.twitter.heron.api.hooks.info.BoltAckInfo;
import com.twitter.heron.api.hooks.info.BoltExecuteInfo;
import com.twitter.heron.api.hooks.info.BoltFailInfo;
import com.twitter.heron.api.hooks.info.EmitInfo;
import com.twitter.heron.api.hooks.info.SpoutAckInfo;
import com.twitter.heron.api.hooks.info.SpoutFailInfo;
import com.twitter.heron.api.metric.CombinedMetric;
import com.twitter.heron.api.metric.ICombiner;
import com.twitter.heron.api.metric.IMetric;
import com.twitter.heron.api.metric.IReducer;
import com.twitter.heron.api.metric.ReducedMetric;
import com.twitter.heron.api.topology.TopologyContext;
import com.twitter.heron.api.tuple.Fields;
import com.twitter.heron.api.tuple.Tuple;
import com.twitter.heron.common.basics.TypeUtils;
import com.twitter.heron.common.utils.metrics.MetricsCollector;
import com.twitter.heron.common.utils.topology.GeneralTopologyContextImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopologyContextImpl
extends GeneralTopologyContextImpl
implements TopologyContext {
    private final int myTaskId;
    private final Map<String, Object> taskData;
    private final MetricsCollector metricsCollector;
    private final List<ITaskHook> taskHooks;

    public TopologyContextImpl(Map<String, Object> map, TopologyAPI.Topology topology, Map<Integer, String> map2, int n, MetricsCollector metricsCollector) {
        super(map, topology, map2);
        this.metricsCollector = metricsCollector;
        this.myTaskId = n;
        this.taskData = new HashMap<String, Object>();
        this.taskHooks = new LinkedList<ITaskHook>();
        List<String> list = TypeUtils.getListOfStrings(map.get("topology.auto.task.hooks"));
        if (list != null) {
            for (String string : list) {
                ITaskHook iTaskHook;
                try {
                    iTaskHook = (ITaskHook)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException + " ITaskHook class must be in class path.");
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException + " ITaskHook class must be concrete.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException + " ITaskHook class must have a no-arg constructor.");
                }
                this.taskHooks.add(iTaskHook);
            }
        }
    }

    public void invokeHookPrepare() {
        for (ITaskHook iTaskHook : this.taskHooks) {
            iTaskHook.prepare(this.getTopologyConfig(), this);
        }
    }

    public void invokeHookCleanup() {
        for (ITaskHook iTaskHook : this.taskHooks) {
            iTaskHook.cleanup();
        }
    }

    public void invokeHookEmit(List<Object> list, String string, Collection<Integer> collection) {
        if (this.taskHooks.size() != 0) {
            EmitInfo emitInfo = new EmitInfo(list, string, this.getThisTaskId(), collection);
            for (ITaskHook iTaskHook : this.taskHooks) {
                iTaskHook.emit(emitInfo);
            }
        }
    }

    public void invokeHookSpoutAck(Object object, long l) {
        if (this.taskHooks.size() != 0) {
            SpoutAckInfo spoutAckInfo = new SpoutAckInfo(object, this.getThisTaskId(), l / 1000000L);
            for (ITaskHook iTaskHook : this.taskHooks) {
                iTaskHook.spoutAck(spoutAckInfo);
            }
        }
    }

    public void invokeHookSpoutFail(Object object, long l) {
        if (this.taskHooks.size() != 0) {
            SpoutFailInfo spoutFailInfo = new SpoutFailInfo(object, this.getThisTaskId(), l / 1000000L);
            for (ITaskHook iTaskHook : this.taskHooks) {
                iTaskHook.spoutFail(spoutFailInfo);
            }
        }
    }

    public void invokeHookBoltExecute(Tuple tuple, long l) {
        if (this.taskHooks.size() != 0) {
            BoltExecuteInfo boltExecuteInfo = new BoltExecuteInfo(tuple, this.getThisTaskId(), l / 1000000L);
            for (ITaskHook iTaskHook : this.taskHooks) {
                iTaskHook.boltExecute(boltExecuteInfo);
            }
        }
    }

    public void invokeHookBoltAck(Tuple tuple, long l) {
        if (this.taskHooks.size() != 0) {
            BoltAckInfo boltAckInfo = new BoltAckInfo(tuple, this.getThisTaskId(), l / 1000000L);
            for (ITaskHook iTaskHook : this.taskHooks) {
                iTaskHook.boltAck(boltAckInfo);
            }
        }
    }

    public void invokeHookBoltFail(Tuple tuple, long l) {
        if (this.taskHooks.size() != 0) {
            BoltFailInfo boltFailInfo = new BoltFailInfo(tuple, this.getThisTaskId(), l / 1000000L);
            for (ITaskHook iTaskHook : this.taskHooks) {
                iTaskHook.boltFail(boltFailInfo);
            }
        }
    }

    @Override
    public int getThisTaskId() {
        return this.myTaskId;
    }

    @Override
    public String getThisComponentId() {
        return this.getComponentId(this.myTaskId);
    }

    @Override
    public Fields getThisOutputFields(String string) {
        return this.getComponentOutputFields(this.getThisComponentId(), string);
    }

    @Override
    public Set<String> getThisStreams() {
        return this.getComponentStreams(this.getThisComponentId());
    }

    @Override
    public int getThisTaskIndex() {
        List<Integer> list = this.getComponentTasks(this.getThisComponentId());
        int n = 0;
        for (Integer n2 : list) {
            if (n2 >= this.myTaskId) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Map<TopologyAPI.StreamId, TopologyAPI.Grouping> getThisSources() {
        return this.getSources(this.getThisComponentId());
    }

    @Override
    public Map<String, Map<String, TopologyAPI.Grouping>> getThisTargets() {
        return this.getTargets(this.getThisComponentId());
    }

    @Override
    public void setTaskData(String string, Object object) {
        this.taskData.put(string, object);
    }

    @Override
    public Object getTaskData(String string) {
        return this.taskData.get(string);
    }

    @Override
    public <T extends IMetric<U>, U> T registerMetric(String string, T t, int n) {
        this.metricsCollector.registerMetric(string, t, n);
        return t;
    }

    @Override
    public <T, U, V> ReducedMetric<T, U, V> registerMetric(String string, IReducer<T, U, V> iReducer, int n) {
        return this.registerMetric(string, new ReducedMetric<T, U, V>(iReducer), n);
    }

    @Override
    public <T> CombinedMetric<T> registerMetric(String string, ICombiner<T> iCombiner, int n) {
        return this.registerMetric(string, new CombinedMetric<T>(iCombiner), n);
    }

    @Override
    public void addTaskHook(ITaskHook iTaskHook) {
        this.taskHooks.add(iTaskHook);
    }

    @Override
    public Collection<ITaskHook> getHooks() {
        return this.taskHooks;
    }
}

