/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.utils.tuple;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.topology.TopologyContext;
import com.twitter.heron.api.tuple.Fields;
import com.twitter.heron.api.tuple.Tuple;
import com.twitter.heron.proto.system.HeronTuples;
import java.util.List;

public class TupleImpl
implements Tuple {
    private final TopologyContext context;
    private final TopologyAPI.StreamId stream;
    private final long tupleKey;
    private final List<HeronTuples.RootId> roots;
    private final long creationTime;
    private List<Object> values;

    public TupleImpl(TopologyContext topologyContext, TopologyAPI.StreamId streamId, long l, List<HeronTuples.RootId> list, List<Object> list2) {
        this.context = topologyContext;
        this.stream = streamId;
        this.tupleKey = l;
        this.roots = list;
        this.values = list2;
        this.creationTime = System.nanoTime();
        Fields fields = topologyContext.getComponentOutputFields(streamId.getComponentName(), streamId.getId());
        if (list2.size() != fields.size()) {
            throw new IllegalArgumentException("Tuple created with wrong number of fields. Expected " + fields.size() + " fields but got " + list2.size() + " fields");
        }
    }

    public List<HeronTuples.RootId> getRoots() {
        return this.roots;
    }

    public long getTupleKey() {
        return this.tupleKey;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public int fieldIndex(String string) {
        return this.getFields().fieldIndex(string);
    }

    @Override
    public boolean contains(String string) {
        return this.getFields().contains(string);
    }

    @Override
    public Object getValue(int n) {
        return this.values.get(n);
    }

    @Override
    public String getString(int n) {
        return (String)this.values.get(n);
    }

    @Override
    public Integer getInteger(int n) {
        return (Integer)this.values.get(n);
    }

    @Override
    public Long getLong(int n) {
        return (Long)this.values.get(n);
    }

    @Override
    public Boolean getBoolean(int n) {
        return (Boolean)this.values.get(n);
    }

    @Override
    public Short getShort(int n) {
        return (Short)this.values.get(n);
    }

    @Override
    public Byte getByte(int n) {
        return (Byte)this.values.get(n);
    }

    @Override
    public Double getDouble(int n) {
        return (Double)this.values.get(n);
    }

    @Override
    public Float getFloat(int n) {
        return (Float)this.values.get(n);
    }

    @Override
    public byte[] getBinary(int n) {
        return (byte[])this.values.get(n);
    }

    @Override
    public Object getValueByField(String string) {
        return this.values.get(this.fieldIndex(string));
    }

    @Override
    public String getStringByField(String string) {
        return (String)this.values.get(this.fieldIndex(string));
    }

    @Override
    public Integer getIntegerByField(String string) {
        return (Integer)this.values.get(this.fieldIndex(string));
    }

    @Override
    public Long getLongByField(String string) {
        return (Long)this.values.get(this.fieldIndex(string));
    }

    @Override
    public Boolean getBooleanByField(String string) {
        return (Boolean)this.values.get(this.fieldIndex(string));
    }

    @Override
    public Short getShortByField(String string) {
        return (Short)this.values.get(this.fieldIndex(string));
    }

    @Override
    public Byte getByteByField(String string) {
        return (Byte)this.values.get(this.fieldIndex(string));
    }

    @Override
    public Double getDoubleByField(String string) {
        return (Double)this.values.get(this.fieldIndex(string));
    }

    @Override
    public Float getFloatByField(String string) {
        return (Float)this.values.get(this.fieldIndex(string));
    }

    @Override
    public byte[] getBinaryByField(String string) {
        return (byte[])this.values.get(this.fieldIndex(string));
    }

    @Override
    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Fields getFields() {
        return this.context.getComponentOutputFields(this.getSourceComponent(), this.getSourceStreamId());
    }

    @Override
    public List<Object> select(Fields fields) {
        return this.getFields().select(fields, this.values);
    }

    @Override
    public String getSourceComponent() {
        return this.stream.getComponentName();
    }

    @Override
    public int getSourceTask() {
        throw new RuntimeException("Tuple no longer supports getSourceTask");
    }

    @Override
    public String getSourceStreamId() {
        return this.stream.getId();
    }

    public String toString() {
        return "source: " + this.getSourceComponent() + ", stream: " + this.getSourceStreamId() + ", " + this.values.toString();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void resetValues() {
        this.values = null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

