/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.simulator.executors;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.common.basics.Communicator;
import com.twitter.heron.common.basics.SlaveLooper;
import com.twitter.heron.common.utils.metrics.MetricsCollector;
import com.twitter.heron.common.utils.misc.PhysicalPlanHelper;
import com.twitter.heron.proto.system.HeronTuples;
import com.twitter.heron.proto.system.Metrics;
import com.twitter.heron.proto.system.PhysicalPlans;
import com.twitter.heron.simulator.instance.BoltInstance;
import com.twitter.heron.simulator.instance.IInstance;
import com.twitter.heron.simulator.instance.SpoutInstance;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstanceExecutor
implements Runnable {
    public static final int CAPACITY = 5;
    public static final double CURRENT_SAMPLE_WEIGHT = 0.5;
    private static final Logger LOG = Logger.getLogger(InstanceExecutor.class.getName());
    private final PhysicalPlanHelper physicalPlanHelper;
    private final SlaveLooper looper;
    private final Communicator<HeronTuples.HeronTupleSet> streamInQueue = new Communicator();
    private final Communicator<HeronTuples.HeronTupleSet> streamOutQueue = new Communicator();
    private final Communicator<Metrics.MetricPublisherPublishMessage> metricsOutQueue = new Communicator();
    private IInstance instance;
    private volatile boolean toStop = false;
    private volatile boolean toActivate = false;
    private volatile boolean toDeactivate = false;
    private boolean isInstanceStarted = false;

    public InstanceExecutor(PhysicalPlans.PhysicalPlan physicalPlan, String string) {
        this.looper = new SlaveLooper();
        MetricsCollector metricsCollector = new MetricsCollector(this.looper, this.metricsOutQueue);
        this.physicalPlanHelper = this.createPhysicalPlanHelper(physicalPlan, string, metricsCollector);
        this.initInstanceManager();
        LOG.log(Level.INFO, "Incarnating ourselves as {0} with task id {1}", new Object[]{this.physicalPlanHelper.getMyComponent(), this.physicalPlanHelper.getMyTaskId()});
    }

    public Communicator<HeronTuples.HeronTupleSet> getStreamInQueue() {
        return this.streamInQueue;
    }

    public Communicator<HeronTuples.HeronTupleSet> getStreamOutQueue() {
        return this.streamOutQueue;
    }

    public Communicator<Metrics.MetricPublisherPublishMessage> getMetricsOutQueue() {
        return this.metricsOutQueue;
    }

    public String getInstanceId() {
        return this.physicalPlanHelper.getMyInstanceId();
    }

    public String getComponentName() {
        return this.physicalPlanHelper.getMyComponent();
    }

    public int getTaskId() {
        return this.physicalPlanHelper.getMyTaskId();
    }

    protected IInstance createInstance() {
        return this.physicalPlanHelper.getMySpout() != null ? new SpoutInstance(this.physicalPlanHelper, this.streamInQueue, this.streamOutQueue, this.looper) : new BoltInstance(this.physicalPlanHelper, this.streamInQueue, this.streamOutQueue, this.looper);
    }

    protected PhysicalPlanHelper createPhysicalPlanHelper(PhysicalPlans.PhysicalPlan physicalPlan, String string, MetricsCollector metricsCollector) {
        PhysicalPlanHelper physicalPlanHelper = new PhysicalPlanHelper(physicalPlan, string);
        physicalPlanHelper.setTopologyContext(metricsCollector);
        return physicalPlanHelper;
    }

    protected void initInstanceManager() {
        this.streamInQueue.setConsumer(this.looper);
        this.streamInQueue.init(5, 5, 0.5);
        this.streamOutQueue.setProducer(this.looper);
        this.streamOutQueue.init(5, 5, 0.5);
        this.metricsOutQueue.setProducer(this.looper);
    }

    protected void handleControlSignal() {
        if (this.toActivate) {
            if (!this.isInstanceStarted) {
                this.startInstance();
            }
            this.instance.activate();
            LOG.info("Activated instance: " + this.physicalPlanHelper.getMyInstanceId());
            this.toActivate = false;
        }
        if (this.toDeactivate) {
            this.instance.deactivate();
            LOG.info("Deactivated instance: " + this.physicalPlanHelper.getMyInstanceId());
            this.toDeactivate = false;
        }
        if (this.toStop) {
            this.instance.stop();
            LOG.info("Stopped instance: " + this.physicalPlanHelper.getMyInstanceId());
            this.toStop = false;
            return;
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName(String.format("%s_%s", this.physicalPlanHelper.getMyComponent(), this.physicalPlanHelper.getMyInstanceId()));
        this.instance = this.createInstance();
        if (this.physicalPlanHelper.getTopologyState().equals(TopologyAPI.TopologyState.RUNNING)) {
            this.startInstance();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                InstanceExecutor.this.handleControlSignal();
            }
        };
        this.looper.addTasksOnWakeup(runnable);
        this.looper.loop();
    }

    public void stop() {
        this.toStop = true;
        this.looper.wakeUp();
    }

    public void activate() {
        this.toActivate = true;
        this.looper.wakeUp();
    }

    public void deactivate() {
        this.toDeactivate = true;
        this.looper.wakeUp();
    }

    private void startInstance() {
        this.instance.start();
        this.isInstanceStarted = true;
        LOG.info("Started instance.");
    }
}

