/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.simulator.executors;

import com.twitter.heron.common.basics.Communicator;
import com.twitter.heron.common.basics.SlaveLooper;
import com.twitter.heron.common.basics.WakeableLooper;
import com.twitter.heron.common.config.SystemConfig;
import com.twitter.heron.common.utils.metrics.JVMMetrics;
import com.twitter.heron.common.utils.metrics.MetricsCollector;
import com.twitter.heron.proto.system.Metrics;
import com.twitter.heron.simulator.executors.InstanceExecutor;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class MetricsExecutor
implements Runnable {
    private static final Logger LOG = Logger.getLogger(InstanceExecutor.class.getName());
    private final List<InstanceExecutor> instanceExecutors = new LinkedList<InstanceExecutor>();
    private final WakeableLooper looper = this.createWakeableLooper();
    private final MetricsCollector metricsCollector;
    private final Communicator<Metrics.MetricPublisherPublishMessage> metricsQueue = new Communicator(null, this.looper);
    private final SystemConfig systemConfig;
    private final String executorId = "Simulator_Metrics_Executor";

    public MetricsExecutor(SystemConfig systemConfig) {
        this.metricsCollector = new MetricsCollector(this.looper, this.metricsQueue);
        this.systemConfig = systemConfig;
    }

    public void addInstanceExecutor(InstanceExecutor instanceExecutor) {
        instanceExecutor.getMetricsOutQueue().setConsumer(this.looper);
        this.instanceExecutors.add(instanceExecutor);
    }

    private void setupJVMMetrics() {
        JVMMetrics jVMMetrics = new JVMMetrics();
        jVMMetrics.registerMetrics(this.metricsCollector);
        this.metricsCollector.registerMetricSampleRunnable(jVMMetrics.getJVMSampleRunnable(), this.systemConfig.getHeronMetricsExportIntervalSec() / 2);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Simulator_Metrics_Executor");
        LOG.info("Metrics_Executor starts");
        this.setupJVMMetrics();
        this.addMetricsExecutorTasks();
        this.looper.loop();
    }

    public void stop() {
        this.looper.exitLoop();
    }

    protected void addMetricsExecutorTasks() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (InstanceExecutor instanceExecutor : MetricsExecutor.this.instanceExecutors) {
                    MetricsExecutor.this.handleExecutorsMetrics(instanceExecutor);
                }
                while (!MetricsExecutor.this.metricsQueue.isEmpty()) {
                    MetricsExecutor.this.handleMetricPublisherPublishMessage("Simulator_Metrics_Executor", (Metrics.MetricPublisherPublishMessage)MetricsExecutor.this.metricsQueue.poll());
                }
            }
        };
        this.looper.addTasksOnWakeup(runnable);
    }

    protected void handleExecutorsMetrics(InstanceExecutor instanceExecutor) {
        while (!instanceExecutor.getMetricsOutQueue().isEmpty()) {
            this.handleMetricPublisherPublishMessage(instanceExecutor.getInstanceId(), instanceExecutor.getMetricsOutQueue().poll());
        }
    }

    protected void handleMetricPublisherPublishMessage(String string, Metrics.MetricPublisherPublishMessage metricPublisherPublishMessage) {
        LOG.info(String.format("Metrics from %s at time %s:\n%s", string, System.currentTimeMillis(), metricPublisherPublishMessage.toString()));
    }

    protected WakeableLooper createWakeableLooper() {
        return new SlaveLooper();
    }
}

