/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.simulator.grouping;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.proto.system.HeronTuples;
import com.twitter.heron.simulator.grouping.AllGrouping;
import com.twitter.heron.simulator.grouping.CustomGrouping;
import com.twitter.heron.simulator.grouping.FieldsGrouping;
import com.twitter.heron.simulator.grouping.LowestGrouping;
import com.twitter.heron.simulator.grouping.ShuffleGrouping;
import java.util.List;

public abstract class Grouping {
    protected List<Integer> taskIds;

    public Grouping(List<Integer> list) {
        this.taskIds = list;
    }

    public static Grouping create(TopologyAPI.Grouping grouping, TopologyAPI.InputStream inputStream, TopologyAPI.StreamSchema streamSchema, List<Integer> list) {
        switch (grouping) {
            case SHUFFLE: {
                return new ShuffleGrouping(list);
            }
            case FIELDS: {
                return new FieldsGrouping(inputStream, streamSchema, list);
            }
            case ALL: {
                return new AllGrouping(list);
            }
            case LOWEST: {
                return new LowestGrouping(list);
            }
            case NONE: {
                return new ShuffleGrouping(list);
            }
            case CUSTOM: {
                return new CustomGrouping(list);
            }
            case DIRECT: {
                throw new IllegalArgumentException("Direct Grouping not supported");
            }
        }
        throw new IllegalArgumentException("Unknown Grouping");
    }

    public abstract List<Integer> getListToSend(HeronTuples.HeronDataTuple var1);
}

