/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.simulator.instance;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.common.basics.Communicator;
import com.twitter.heron.common.basics.SingletonRegistry;
import com.twitter.heron.common.config.SystemConfig;
import com.twitter.heron.common.utils.misc.PhysicalPlanHelper;
import com.twitter.heron.proto.system.HeronTuples;

public class OutgoingTupleCollection {
    protected final PhysicalPlanHelper helper;
    private final Communicator<HeronTuples.HeronTupleSet> outQueue;
    private final SystemConfig systemConfig;
    private HeronTuples.HeronDataTupleSet.Builder currentDataTuple;
    private HeronTuples.HeronControlTupleSet.Builder currentControlTuple;
    private long totalDataEmittedInBytes = 0L;
    private int dataTupleSetCapacity;
    private int controlTupleSetCapacity;

    public OutgoingTupleCollection(PhysicalPlanHelper physicalPlanHelper, Communicator<HeronTuples.HeronTupleSet> communicator) {
        this.outQueue = communicator;
        this.helper = physicalPlanHelper;
        this.systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        this.dataTupleSetCapacity = this.systemConfig.getInstanceSetDataTupleCapacity();
        this.controlTupleSetCapacity = this.systemConfig.getInstanceSetControlTupleCapacity();
    }

    public void sendOutTuples() {
        this.flushRemaining();
    }

    public void addDataTuple(String string, HeronTuples.HeronDataTuple.Builder builder, long l) {
        if (this.currentDataTuple == null || !this.currentDataTuple.getStream().getId().equals(string) || this.currentDataTuple.getTuplesCount() > this.dataTupleSetCapacity) {
            this.initNewDataTuple(string);
        }
        this.currentDataTuple.addTuples(builder);
        this.totalDataEmittedInBytes += l;
    }

    public void addAckTuple(HeronTuples.AckTuple.Builder builder, long l) {
        if (this.currentControlTuple == null || this.currentControlTuple.getFailsCount() > 0 || this.currentControlTuple.getAcksCount() > this.controlTupleSetCapacity) {
            this.initNewControlTuple();
        }
        this.currentControlTuple.addAcks(builder);
        this.totalDataEmittedInBytes += l;
    }

    public void addFailTuple(HeronTuples.AckTuple.Builder builder, long l) {
        if (this.currentControlTuple == null || this.currentControlTuple.getAcksCount() > 0 || this.currentControlTuple.getFailsCount() > this.controlTupleSetCapacity) {
            this.initNewControlTuple();
        }
        this.currentControlTuple.addFails(builder);
        this.totalDataEmittedInBytes += l;
    }

    private void initNewDataTuple(String string) {
        this.flushRemaining();
        TopologyAPI.StreamId.Builder builder = TopologyAPI.StreamId.newBuilder();
        builder.setId(string);
        builder.setComponentName(this.helper.getMyComponent());
        this.currentDataTuple = HeronTuples.HeronDataTupleSet.newBuilder();
        this.currentDataTuple.setStream(builder);
    }

    private void initNewControlTuple() {
        this.flushRemaining();
        this.currentControlTuple = HeronTuples.HeronControlTupleSet.newBuilder();
    }

    private void flushRemaining() {
        HeronTuples.HeronTupleSet.Builder builder;
        if (this.currentDataTuple != null) {
            builder = HeronTuples.HeronTupleSet.newBuilder();
            builder.setData(this.currentDataTuple);
            this.pushTupleToQueue(builder, this.outQueue);
            this.currentDataTuple = null;
        }
        if (this.currentControlTuple != null) {
            builder = HeronTuples.HeronTupleSet.newBuilder();
            builder.setControl(this.currentControlTuple);
            this.pushTupleToQueue(builder, this.outQueue);
            this.currentControlTuple = null;
        }
    }

    private void pushTupleToQueue(HeronTuples.HeronTupleSet.Builder builder, Communicator<HeronTuples.HeronTupleSet> communicator) {
        communicator.offer(builder.build());
    }

    public boolean isOutQueuesAvailable() {
        return this.outQueue.size() < this.outQueue.getExpectedAvailableCapacity();
    }

    public long getTotalDataEmittedInBytes() {
        return this.totalDataEmittedInBytes;
    }

    public void clear() {
        this.currentControlTuple = null;
        this.currentDataTuple = null;
        this.outQueue.clear();
    }
}

