/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.simulator.utils;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.proto.system.PhysicalPlans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PhysicalPlanUtil {
    private PhysicalPlanUtil() {
    }

    public static PhysicalPlans.PhysicalPlan getPhysicalPlan(TopologyAPI.Topology topology) {
        PhysicalPlans.PhysicalPlan.Builder builder = PhysicalPlans.PhysicalPlan.newBuilder();
        builder.setTopology(topology);
        PhysicalPlans.StMgr stMgr = PhysicalPlans.StMgr.newBuilder().setId("").setHostName("").setDataPort(-1).setLocalEndpoint("").setCwd("").build();
        builder.addStmgrs(stMgr);
        int n = 1;
        for (Map.Entry<String, Integer> entry : PhysicalPlanUtil.getComponentParallelism(topology).entrySet()) {
            String string = entry.getKey();
            int n2 = entry.getValue();
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                PhysicalPlans.InstanceInfo instanceInfo = PhysicalPlans.InstanceInfo.newBuilder().setComponentName(string).setTaskId(n).setComponentIndex(n3).build();
                PhysicalPlans.Instance instance = PhysicalPlans.Instance.newBuilder().setStmgrId("").setInstanceId(String.format("%s_%s", string, n3)).setInfo(instanceInfo).build();
                builder.addInstances(instance);
                ++n3;
                ++n;
            }
        }
        return builder.build();
    }

    public static Map<String, List<Integer>> getComponentToTaskIds(PhysicalPlans.PhysicalPlan physicalPlan) {
        HashMap<String, List<Integer>> hashMap = new HashMap<String, List<Integer>>();
        for (PhysicalPlans.Instance instance : physicalPlan.getInstancesList()) {
            int n = instance.getInfo().getTaskId();
            String string = instance.getInfo().getComponentName();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            ((List)hashMap.get(string)).add(n);
        }
        return hashMap;
    }

    public static int extractTopologyTimeout(TopologyAPI.Topology topology) {
        for (TopologyAPI.Config.KeyValue keyValue : topology.getTopologyConfig().getKvsList()) {
            if (!keyValue.getKey().equals("topology.message.timeout.secs")) continue;
            return Integer.parseInt(keyValue.getValue());
        }
        throw new IllegalArgumentException("topology.message.timeout.secs does not exist");
    }

    public static Map<String, Integer> getComponentParallelism(TopologyAPI.Topology topology) {
        String string;
        String string2;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (TopologyAPI.Spout generatedMessage : topology.getSpoutsList()) {
            string2 = generatedMessage.getComp().getName();
            string = PhysicalPlanUtil.getConfigWithException(generatedMessage.getComp().getConfig().getKvsList(), "topology.component.parallelism").trim();
            hashMap.put(string2, Integer.parseInt(string));
        }
        for (TopologyAPI.Bolt bolt : topology.getBoltsList()) {
            string2 = bolt.getComp().getName();
            string = PhysicalPlanUtil.getConfigWithException(bolt.getComp().getConfig().getKvsList(), "topology.component.parallelism").trim();
            hashMap.put(string2, Integer.parseInt(string));
        }
        return hashMap;
    }

    public static String getConfigWithException(List<TopologyAPI.Config.KeyValue> list, String string) {
        for (TopologyAPI.Config.KeyValue keyValue : list) {
            if (!keyValue.getKey().equals(string)) continue;
            return keyValue.getValue();
        }
        throw new RuntimeException("Missing config for required key " + string);
    }
}

