/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.simulator.utils;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.proto.system.HeronTuples;
import com.twitter.heron.simulator.grouping.Grouping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StreamConsumers {
    private final List<Grouping> consumers = new ArrayList<Grouping>();

    public static Map<TopologyAPI.StreamId, StreamConsumers> populateStreamConsumers(TopologyAPI.Topology topology, Map<String, List<Integer>> map) {
        HashMap<TopologyAPI.StreamId, TopologyAPI.StreamSchema> hashMap = new HashMap<TopologyAPI.StreamId, TopologyAPI.StreamSchema>();
        for (TopologyAPI.Spout object : topology.getSpoutsList()) {
            for (TopologyAPI.OutputStream outputStream : object.getOutputsList()) {
                hashMap.put(outputStream.getStream(), outputStream.getSchema());
            }
        }
        for (TopologyAPI.Bolt bolt : topology.getBoltsList()) {
            for (TopologyAPI.OutputStream outputStream : bolt.getOutputsList()) {
                hashMap.put(outputStream.getStream(), outputStream.getSchema());
            }
        }
        HashMap hashMap2 = new HashMap();
        for (TopologyAPI.Bolt bolt : topology.getBoltsList()) {
            for (TopologyAPI.InputStream inputStream : bolt.getInputsList()) {
                TopologyAPI.StreamSchema streamSchema = (TopologyAPI.StreamSchema)hashMap.get(inputStream.getStream());
                String string = bolt.getComp().getName();
                List<Integer> list = map.get(string);
                if (!hashMap2.containsKey(inputStream.getStream())) {
                    hashMap2.put(inputStream.getStream(), new StreamConsumers());
                }
                ((StreamConsumers)hashMap2.get(inputStream.getStream())).newConsumer(inputStream, streamSchema, list);
            }
        }
        return hashMap2;
    }

    public void newConsumer(TopologyAPI.InputStream inputStream, TopologyAPI.StreamSchema streamSchema, List<Integer> list) {
        this.consumers.add(Grouping.create(inputStream.getGtype(), inputStream, streamSchema, list));
    }

    public List<Integer> getListToSend(HeronTuples.HeronDataTuple heronDataTuple) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Grouping grouping : this.consumers) {
            arrayList.addAll(grouping.getListToSend(heronDataTuple));
        }
        return arrayList;
    }

    protected List<Grouping> getConsumers() {
        return this.consumers;
    }
}

