/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.simulator.utils;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.proto.system.HeronTuples;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class TupleCache {
    private final Map<Integer, TupleList> cache = new HashMap<Integer, TupleList>();

    protected TupleList get(int n) {
        TupleList tupleList = this.cache.get(n);
        if (tupleList == null) {
            tupleList = new TupleList();
            this.cache.put(n, tupleList);
        }
        return tupleList;
    }

    public long addDataTuple(int n, TopologyAPI.StreamId streamId, HeronTuples.HeronDataTuple heronDataTuple, boolean bl) {
        return this.get(n).addDataTuple(streamId, heronDataTuple, bl);
    }

    public void addAckTuple(int n, HeronTuples.AckTuple ackTuple) {
        this.get(n).addAckTuple(ackTuple);
    }

    public void addFailTuple(int n, HeronTuples.AckTuple ackTuple) {
        this.get(n).addFailTuple(ackTuple);
    }

    public void addEmitTuple(int n, HeronTuples.AckTuple ackTuple) {
        this.get(n).addEmitTuple(ackTuple);
    }

    public Map<Integer, List<HeronTuples.HeronTupleSet>> getCache() {
        HashMap<Integer, List<HeronTuples.HeronTupleSet>> hashMap = new HashMap<Integer, List<HeronTuples.HeronTupleSet>>();
        for (Map.Entry<Integer, TupleList> entry : this.cache.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getTuplesList());
        }
        return hashMap;
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void clear() {
        this.cache.clear();
    }

    protected static class TupleList {
        private final List<HeronTuples.HeronTupleSet> tuples = new LinkedList<HeronTuples.HeronTupleSet>();
        private final Random random = new Random();
        private HeronTuples.HeronTupleSet.Builder current;

        public long addDataTuple(TopologyAPI.StreamId streamId, HeronTuples.HeronDataTuple heronDataTuple, boolean bl) {
            if (this.current == null || this.current.hasControl() || !this.current.getDataBuilder().getStream().getComponentName().equals(streamId.getComponentName()) || !this.current.getDataBuilder().getStream().getId().equals(streamId.getId())) {
                if (this.current != null) {
                    this.tuples.add(this.current.build());
                }
                this.current = HeronTuples.HeronTupleSet.newBuilder();
                this.current.getDataBuilder().setStream(streamId);
            }
            long l = -1L;
            if (bl) {
                l = this.random.nextLong();
                this.current.getDataBuilder().addTuples(HeronTuples.HeronDataTuple.newBuilder().mergeFrom(heronDataTuple).setKey(l));
            } else {
                this.current.getDataBuilder().addTuples(heronDataTuple);
            }
            return l;
        }

        public void addAckTuple(HeronTuples.AckTuple ackTuple) {
            if (this.current == null || this.current.hasData() || this.current.getControlBuilder().getFailsCount() > 0 || this.current.getControlBuilder().getEmitsCount() > 0) {
                if (this.current != null) {
                    this.tuples.add(this.current.build());
                }
                this.current = HeronTuples.HeronTupleSet.newBuilder();
            }
            this.current.getControlBuilder().addAcks(ackTuple);
        }

        public void addFailTuple(HeronTuples.AckTuple ackTuple) {
            if (this.current == null || this.current.hasData() || this.current.getControlBuilder().getAcksCount() > 0 || this.current.getControlBuilder().getEmitsCount() > 0) {
                if (this.current != null) {
                    this.tuples.add(this.current.build());
                }
                this.current = HeronTuples.HeronTupleSet.newBuilder();
            }
            this.current.getControlBuilder().addFails(ackTuple);
        }

        public void addEmitTuple(HeronTuples.AckTuple ackTuple) {
            if (this.current == null || this.current.hasData() || this.current.getControlBuilder().getAcksCount() > 0 || this.current.getControlBuilder().getFailsCount() > 0) {
                if (this.current != null) {
                    this.tuples.add(this.current.build());
                }
                this.current = HeronTuples.HeronTupleSet.newBuilder();
            }
            this.current.getControlBuilder().addEmits(ackTuple);
        }

        public List<HeronTuples.HeronTupleSet> getTuplesList() {
            if (this.current != null) {
                this.tuples.add(this.current.build());
                this.current = null;
            }
            return this.tuples;
        }

        public void clear() {
            this.current = null;
            this.tuples.clear();
        }
    }
}

