/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.simulator.utils;

import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.common.basics.WakeableLooper;
import com.twitter.heron.simulator.utils.PhysicalPlanUtil;
import com.twitter.heron.simulator.utils.RotatingMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class XORManager {
    private final WakeableLooper looper;
    private final Map<Integer, RotatingMap> spoutTasksToRotatingMap;
    private final long rotateIntervalNs;

    public XORManager(WakeableLooper wakeableLooper, int n, List<Integer> list, int n2) {
        this.looper = wakeableLooper;
        this.spoutTasksToRotatingMap = new HashMap<Integer, RotatingMap>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                XORManager.this.rotate();
            }
        };
        wakeableLooper.registerTimerEventInNanoSeconds((long)n * 1000000000L, runnable);
        this.rotateIntervalNs = 1000000000L * (long)n / (long)n2 + 1000000000L * (long)n % (long)n2;
        for (Integer n3 : list) {
            this.spoutTasksToRotatingMap.put(n3, new RotatingMap(n2));
        }
    }

    public static XORManager populateXORManager(WakeableLooper wakeableLooper, TopologyAPI.Topology topology, int n, Map<String, List<Integer>> map) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (TopologyAPI.Spout spout : topology.getSpoutsList()) {
            for (TopologyAPI.OutputStream outputStream : spout.getOutputsList()) {
                List<Integer> list = map.get(outputStream.getStream().getComponentName());
                linkedList.addAll(list);
            }
        }
        return new XORManager(wakeableLooper, PhysicalPlanUtil.extractTopologyTimeout(topology), linkedList, n);
    }

    public void create(int n, long l, long l2) {
        this.spoutTasksToRotatingMap.get(n).create(l, l2);
    }

    public boolean anchor(int n, long l, long l2) {
        return this.spoutTasksToRotatingMap.get(n).anchor(l, l2);
    }

    public boolean remove(int n, long l) {
        return this.spoutTasksToRotatingMap.get(n).remove(l);
    }

    protected void rotate() {
        for (RotatingMap rotatingMap : this.spoutTasksToRotatingMap.values()) {
            rotatingMap.rotate();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                XORManager.this.rotate();
            }
        };
        this.looper.registerTimerEventInNanoSeconds(this.rotateIntervalNs, runnable);
    }

    protected Map<Integer, RotatingMap> getSpoutTasksToRotatingMap() {
        return this.spoutTasksToRotatingMap;
    }
}

