/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import com.twitter.heron.simulator.Simulator;
import java.util.Map;
import org.apache.storm.ILocalCluster;
import org.apache.storm.generated.AlreadyAliveException;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.NotAliveException;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.utils.ConfigUtils;

public class LocalCluster
implements ILocalCluster {
    private final Simulator simulator = new Simulator();
    private String topologyName;
    private Map<String, Object> conf;
    private StormTopology topology;

    public LocalCluster() {
        this.resetFields();
    }

    @Override
    public void submitTopology(String string, Map map, StormTopology stormTopology) throws AlreadyAliveException, InvalidTopologyException {
        this.assertNotAlive();
        this.topologyName = string;
        this.conf = map;
        this.topology = stormTopology;
        this.simulator.submitTopology(string, ConfigUtils.translateConfig(map), stormTopology.getStormTopology());
    }

    @Override
    public void killTopology(String string) throws NotAliveException {
        this.assertAlive(string);
        this.simulator.killTopology(string);
        this.resetFields();
    }

    @Override
    public void activate(String string) throws NotAliveException {
        this.assertAlive(string);
        this.simulator.activate(string);
    }

    @Override
    public void deactivate(String string) throws NotAliveException {
        this.assertAlive(string);
        this.simulator.deactivate(string);
    }

    @Override
    public void shutdown() {
        this.resetFields();
        this.simulator.shutdown();
    }

    @Override
    public String getTopologyConf(String string) {
        try {
            this.assertAlive(string);
            return this.topologyName;
        }
        catch (NotAliveException notAliveException) {
            return null;
        }
    }

    @Override
    public StormTopology getTopology(String string) {
        try {
            this.assertAlive(string);
            return this.topology;
        }
        catch (NotAliveException notAliveException) {
            return null;
        }
    }

    @Override
    public Map getState() {
        throw new RuntimeException("Heron does not support LocalCluster yet...");
    }

    private void resetFields() {
        this.topologyName = null;
        this.topology = null;
        this.conf = null;
    }

    private void assertAlive(String string) throws NotAliveException {
        if (this.topologyName == null || !this.topologyName.equals(string)) {
            throw new NotAliveException();
        }
    }

    private void assertNotAlive() throws AlreadyAliveException {
        if (this.topologyName != null) {
            throw new AlreadyAliveException();
        }
    }
}

