/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.api;

import com.twitter.heron.api.metric.MeanReducerState;
import org.apache.storm.metric.api.IReducer;

public class MeanReducer
implements IReducer<MeanReducerState> {
    @Override
    public MeanReducerState init() {
        return new MeanReducerState();
    }

    @Override
    public MeanReducerState reduce(MeanReducerState meanReducerState, Object object) {
        ++meanReducerState.count;
        if (object instanceof Double) {
            meanReducerState.sum += ((Double)object).doubleValue();
        } else if (object instanceof Long) {
            meanReducerState.sum += ((Long)object).doubleValue();
        } else if (object instanceof Integer) {
            meanReducerState.sum += ((Integer)object).doubleValue();
        } else {
            throw new RuntimeException("MeanReducer::reduce called with unsupported input type `" + object.getClass() + "`. Supported types are Double, Long, Integer.");
        }
        return meanReducerState;
    }

    @Override
    public Object extractResult(MeanReducerState meanReducerState) {
        if (meanReducerState.count > 0) {
            return new Double(meanReducerState.sum / (double)meanReducerState.count);
        }
        return null;
    }
}

