/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.Map;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.FailedException;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.ReportedFailedException;
import org.apache.storm.tuple.Tuple;

public class BasicBoltExecutor
implements IRichBolt {
    private static final long serialVersionUID = 235217339000923019L;
    private IBasicBolt delegate;
    private transient BasicOutputCollector collector;

    public BasicBoltExecutor(IBasicBolt iBasicBolt) {
        this.delegate = iBasicBolt;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        this.delegate.declareOutputFields(outputFieldsDeclarer);
    }

    @Override
    public void prepare(Map map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.delegate.prepare(map, topologyContext);
        this.collector = new BasicOutputCollector(outputCollector);
    }

    @Override
    public void execute(Tuple tuple) {
        this.collector.setContext(tuple);
        try {
            this.delegate.execute(tuple, this.collector);
            this.collector.getOutputter().ack(tuple);
        }
        catch (FailedException failedException) {
            if (failedException instanceof ReportedFailedException) {
                this.collector.reportError(failedException);
            }
            this.collector.getOutputter().fail(tuple);
        }
    }

    @Override
    public void cleanup() {
        this.delegate.cleanup();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.delegate.getComponentConfiguration();
    }
}

