/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class HuffmanDecoder {
    private final Node root = new Node();

    HuffmanDecoder(int[] codes, byte[] lengths) {
        this.buildTree(codes, lengths);
    }

    private void buildTree(int[] codes, byte[] lengths) {
        for (int i = 0; i < lengths.length; ++i) {
            this.addCode(i, codes[i], lengths[i]);
        }
    }

    private void addCode(int sym, int code, byte len) {
        Node terminal = new Node(sym, len);
        Node current = this.root;
        while (len > 8) {
            len = (byte)(len - 8);
            int i = code >>> len & 0xFF;
            if (current.children == null) {
                throw new IllegalStateException("invalid dictionary: prefix not unique");
            }
            if (current.children[i] == null) {
                ((Node)current).children[i] = new Node();
            }
            current = current.children[i];
        }
        int shift = 8 - len;
        int start = code << shift & 0xFF;
        int end = 1 << shift;
        for (int i = start; i < start + end; ++i) {
            ((Node)current).children[i] = terminal;
        }
    }

    public byte[] decode(byte[] buf) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Node node = this.root;
        int current = 0;
        int nbits = 0;
        for (int i = 0; i < buf.length; ++i) {
            int b = buf[i] & 0xFF;
            current = current << 8 | b;
            nbits += 8;
            while (nbits >= 8) {
                int c = current >>> nbits - 8 & 0xFF;
                if ((node = node.children[c]).children == null) {
                    baos.write(node.symbol);
                    nbits -= node.terminalBits;
                    node = this.root;
                    continue;
                }
                nbits -= 8;
            }
        }
        while (nbits > 0) {
            int c = current << 8 - nbits & 0xFF;
            if ((node = node.children[c]).children != null || node.terminalBits > nbits) break;
            baos.write(node.symbol);
            nbits -= node.terminalBits;
            node = this.root;
        }
        return baos.toByteArray();
    }

    private static final class Node {
        private final Node[] children;
        private final int symbol;
        private final int terminalBits;

        Node() {
            this.children = new Node[256];
            this.symbol = 0;
            this.terminalBits = 0;
        }

        Node(int symbol, int bits) {
            this.children = null;
            this.symbol = symbol;
            int b = bits & 7;
            this.terminalBits = b == 0 ? 8 : b;
        }
    }
}

