/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.inject.app;

import com.google.common.collect.ImmutableMap;
import com.twitter.app.FlagParseException;
import com.twitter.inject.app.App;
import com.twitter.inject.app.BindDSL;
import com.twitter.inject.app.EmbeddedApp;
import com.twitter.inject.app.SampleJavaApp;
import com.twitter.inject.app.SampleJavaAppService;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class EmbeddedAppIntegrationJavaTest
extends Assert {
    @Test
    public void testEmbeddedApp() {
        SampleJavaApp sampleJavaApp = new SampleJavaApp();
        EmbeddedApp embeddedApp = new EmbeddedApp((App)sampleJavaApp);
        embeddedApp.main();
        EmbeddedAppIntegrationJavaTest.assertEquals((Object)sampleJavaApp.getSampleServiceResponse(), (Object)"hi yo");
    }

    @Test(expected=Exception.class)
    public void testEmbeddedHelpArg() {
        SampleJavaApp sampleJavaApp = new SampleJavaApp();
        EmbeddedApp embeddedApp = new EmbeddedApp((App)sampleJavaApp);
        embeddedApp.main((Map<String, Object>)ImmutableMap.of(), "-help");
    }

    @Test(expected=FlagParseException.class)
    public void testEmbeddedAppFailOnUndefinedFlags() {
        SampleJavaApp sampleJavaApp = new SampleJavaApp();
        EmbeddedApp embeddedApp = new EmbeddedApp((App)sampleJavaApp);
        embeddedApp.main((Map<String, Object>)ImmutableMap.of((Object)"-flag1", (Object)"value1", (Object)"-flag2", (Object)"value2"));
    }

    @Test
    public void testEmbeddedAppWithBind() {
        SampleJavaAppService sampleJavaAppService = (SampleJavaAppService)Mockito.mock(SampleJavaAppService.class);
        Mockito.when((Object)sampleJavaAppService.sayHi(ArgumentMatchers.anyString())).thenReturn((Object)"hi mock");
        SampleJavaApp sampleJavaApp = new SampleJavaApp();
        EmbeddedApp embeddedApp = new EmbeddedApp((App)sampleJavaApp);
        embeddedApp.bindClass((Class)SampleJavaAppService.class, sampleJavaAppService);
        embeddedApp.main();
        EmbeddedAppIntegrationJavaTest.assertEquals((Object)sampleJavaApp.getSampleServiceResponse(), (Object)"hi mock");
        Mockito.reset((Object[])new SampleJavaAppService[]{sampleJavaAppService});
    }

    @Test
    public void testEmbeddedAppWithBindChaining() {
        SampleJavaAppService sampleJavaAppService = (SampleJavaAppService)Mockito.mock(SampleJavaAppService.class);
        Mockito.when((Object)sampleJavaAppService.sayHi(ArgumentMatchers.anyString())).thenReturn((Object)"hi mock");
        SampleJavaApp sampleJavaApp = new SampleJavaApp();
        BindDSL bindDSL = new EmbeddedApp((App)sampleJavaApp).bindClass((Class)SampleJavaAppService.class, sampleJavaAppService);
        ((EmbeddedApp)bindDSL).main();
        EmbeddedAppIntegrationJavaTest.assertEquals((Object)sampleJavaApp.getSampleServiceResponse(), (Object)"hi mock");
        Mockito.reset((Object[])new SampleJavaAppService[]{sampleJavaAppService});
    }
}

