/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.inject.app;

import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import com.twitter.inject.annotations.Down;
import com.twitter.inject.annotations.Flags;
import com.twitter.inject.app.BarPaymentProcessorImpl;
import com.twitter.inject.app.FooPaymentProcessorImpl;
import com.twitter.inject.app.PaymentProcessor;
import com.twitter.inject.app.TestInjector;
import com.twitter.inject.app.TestInjector$;
import com.twitter.inject.modules.InMemoryStatsReceiverModule;
import com.twitter.inject.modules.StackTransformerModule;
import com.twitter.inject.modules.StatsReceiverModule;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class TestInjectorJavaTest
extends Assert {
    @Test
    public void testJavaConstructors() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("foo", "bar");
        hashMap.put("baz", "bus");
        TestInjector.Builder builder = TestInjector$.MODULE$.apply();
        builder = TestInjector.apply();
        builder = TestInjector.apply(new Module[]{StackTransformerModule.get(), StatsReceiverModule.get()});
        builder = TestInjector.apply(Arrays.asList(StackTransformerModule.get(), StatsReceiverModule.get()));
        builder = TestInjector.apply(Arrays.asList(StackTransformerModule.get(), StatsReceiverModule.get()), hashMap);
        builder = TestInjector.apply(Arrays.asList(StackTransformerModule.get(), StatsReceiverModule.get()), hashMap, Collections.singletonList(InMemoryStatsReceiverModule.get()));
        builder = TestInjector.apply(Arrays.asList(StackTransformerModule.get(), StatsReceiverModule.get()), hashMap, Collections.singletonList(InMemoryStatsReceiverModule.get()), Stage.PRODUCTION);
    }

    @Test
    public void testTestInjector() {
        BigDecimal bigDecimal = new BigDecimal(12.34, MathContext.DECIMAL32);
        TestInjector.Builder builder = TestInjector$.MODULE$.apply();
        builder.bindClass((Class)String.class, "Hello, world");
        builder.bindClass((Class)Float.class, (Annotation)Flags.named((String)"float.flag"), (Object)Float.valueOf(42.0f));
        builder.bindClass((Class)String.class, (Class)Down.class, (Object)"Goodbye, world");
        builder.bindClass((Class)PaymentProcessor.class, BarPaymentProcessorImpl.class);
        builder.bindClass((Class)PaymentProcessor.class, (Annotation)Names.named((String)"processor.impl"), (Class)FooPaymentProcessorImpl.class);
        TestInjector testInjector = builder.newInstance();
        TestInjectorJavaTest.assertEquals((Object)testInjector.instance(String.class), (Object)"Hello, world");
        TestInjectorJavaTest.assertTrue((((Float)testInjector.instance(Float.class, (Annotation)Flags.named((String)"float.flag"))).floatValue() == 42.0f ? 1 : 0) != 0);
        TestInjectorJavaTest.assertEquals((Object)testInjector.instance(String.class, Down.class), (Object)"Goodbye, world");
        TestInjectorJavaTest.assertEquals((Object)((PaymentProcessor)testInjector.instance(PaymentProcessor.class)).processPayment(bigDecimal), (Object)"BarPaymentProcessorImpl");
        TestInjectorJavaTest.assertEquals((Object)((PaymentProcessor)testInjector.instance(PaymentProcessor.class, (Annotation)Names.named((String)"processor.impl"))).processPayment(bigDecimal), (Object)"FooPaymentProcessorImpl");
    }

    @Test
    public void testTestInjectorChaining() {
        BigDecimal bigDecimal = new BigDecimal(12.34, MathContext.DECIMAL32);
        TestInjector.Builder builder = TestInjector.apply(new Module[]{StackTransformerModule.get(), StatsReceiverModule.get()});
        TestInjector testInjector = ((TestInjector.Builder)((TestInjector.Builder)((TestInjector.Builder)((TestInjector.Builder)((TestInjector.Builder)builder.bindClass((Class)String.class, "Hello, world")).bindClass((Class)Float.class, (Annotation)Flags.named((String)"float.flag"), (Object)Float.valueOf(42.0f))).bindClass((Class)String.class, (Class)Down.class, (Object)"Goodbye, world")).bindClass((Class)PaymentProcessor.class, BarPaymentProcessorImpl.class)).bindClass((Class)PaymentProcessor.class, (Annotation)Names.named((String)"processor.impl"), (Class)FooPaymentProcessorImpl.class)).newInstance();
        TestInjectorJavaTest.assertEquals((Object)testInjector.instance(String.class), (Object)"Hello, world");
        TestInjectorJavaTest.assertTrue((((Float)testInjector.instance(Float.class, (Annotation)Flags.named((String)"float.flag"))).floatValue() == 42.0f ? 1 : 0) != 0);
        TestInjectorJavaTest.assertEquals((Object)testInjector.instance(String.class, Down.class), (Object)"Goodbye, world");
        TestInjectorJavaTest.assertEquals((Object)((PaymentProcessor)testInjector.instance(PaymentProcessor.class)).processPayment(bigDecimal), (Object)"BarPaymentProcessorImpl");
        TestInjectorJavaTest.assertEquals((Object)((PaymentProcessor)testInjector.instance(PaymentProcessor.class, (Annotation)Names.named((String)"processor.impl"))).processPayment(bigDecimal), (Object)"FooPaymentProcessorImpl");
    }

    @Test
    public void testTestInjectorCollections() {
        BigDecimal bigDecimal = new BigDecimal(12.34, MathContext.DECIMAL32);
        TestInjector.Builder builder = TestInjector.apply(Arrays.asList(StackTransformerModule.get(), StatsReceiverModule.get()));
        TestInjector testInjector = ((TestInjector.Builder)((TestInjector.Builder)((TestInjector.Builder)((TestInjector.Builder)((TestInjector.Builder)builder.bindClass((Class)String.class, "Hello, world")).bindClass((Class)Float.class, (Annotation)Flags.named((String)"float.flag"), (Object)Float.valueOf(42.0f))).bindClass((Class)String.class, (Class)Down.class, (Object)"Goodbye, world")).bindClass((Class)PaymentProcessor.class, BarPaymentProcessorImpl.class)).bindClass((Class)PaymentProcessor.class, (Annotation)Names.named((String)"processor.impl"), (Class)FooPaymentProcessorImpl.class)).create();
        TestInjectorJavaTest.assertEquals((Object)testInjector.instance(String.class), (Object)"Hello, world");
        TestInjectorJavaTest.assertTrue((((Float)testInjector.instance(Float.class, (Annotation)Flags.named((String)"float.flag"))).floatValue() == 42.0f ? 1 : 0) != 0);
        TestInjectorJavaTest.assertEquals((Object)testInjector.instance(String.class, Down.class), (Object)"Goodbye, world");
        TestInjectorJavaTest.assertEquals((Object)((PaymentProcessor)testInjector.instance(PaymentProcessor.class)).processPayment(bigDecimal), (Object)"BarPaymentProcessorImpl");
        TestInjectorJavaTest.assertEquals((Object)((PaymentProcessor)testInjector.instance(PaymentProcessor.class, (Annotation)Names.named((String)"processor.impl"))).processPayment(bigDecimal), (Object)"FooPaymentProcessorImpl");
    }
}

