/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.inject.utils;

import com.twitter.finagle.FailedFastException;
import com.twitter.finagle.SourcedException;
import com.twitter.finagle.TimeoutException;
import com.twitter.util.Throw;
import com.twitter.util.Throwables$;
import com.twitter.util.Try;
import org.apache.commons.lang.StringUtils;
import scala.collection.mutable.StringBuilder;

public final class ExceptionUtils$ {
    public static final ExceptionUtils$ MODULE$;

    static {
        new ExceptionUtils$();
    }

    public String stripNewlines(Throwable e) {
        return this.stripNewlines(e.toString());
    }

    public String stripNewlines(String str) {
        return StringUtils.replace((String)str, (String)"\n\twith NoSources", (String)"");
    }

    public String toExceptionDetails(Throwable exception) {
        return Throwables$.MODULE$.mkString(exception).mkString("/");
    }

    public String toExceptionMessage(Try<?> tryThrowable) {
        String string2;
        Try<?> try_ = tryThrowable;
        if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable e = throw_.e();
            string2 = this.toExceptionMessage(e);
        } else {
            string2 = "";
        }
        return string2;
    }

    public String toExceptionMessage(Throwable exception) {
        String string2;
        Throwable throwable = exception;
        if (throwable instanceof TimeoutException) {
            TimeoutException timeoutException = (TimeoutException)throwable;
            string2 = timeoutException.exceptionMessage();
        } else if (throwable instanceof FailedFastException) {
            FailedFastException failedFastException = (FailedFastException)throwable;
            string2 = failedFastException.getClass().getName();
        } else if (throwable instanceof SourcedException) {
            SourcedException sourcedException = (SourcedException)throwable;
            string2 = this.stripNewlines((Throwable)sourcedException);
        } else {
            String msg = throwable.getMessage();
            string2 = msg == null || msg.isEmpty() ? throwable.getClass().getName() : new StringBuilder().append((Object)throwable.getClass().getName()).append((Object)" ").append((Object)msg).toString();
        }
        return string2;
    }

    public String toDetailedExceptionMessage(Try<?> tryThrowable) {
        String string2;
        Try<?> try_ = tryThrowable;
        if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable e = throw_.e();
            string2 = new StringBuilder().append((Object)this.toExceptionDetails(e)).append((Object)" ").append((Object)this.toExceptionMessage(e)).toString();
        } else {
            string2 = "";
        }
        return string2;
    }

    private ExceptionUtils$() {
        MODULE$ = this;
    }
}

