/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.inject.utils;

import com.twitter.finagle.CancelledConnectionException;
import com.twitter.finagle.CancelledRequestException;
import com.twitter.finagle.FailedFastException;
import com.twitter.finagle.Failure;
import com.twitter.finagle.FailureFlags;
import com.twitter.finagle.FailureFlags$;
import com.twitter.finagle.SourcedException;
import com.twitter.finagle.TimeoutException;
import com.twitter.finagle.mux.ClientDiscardedRequestException;
import com.twitter.inject.exceptions.NonRetryableException;
import com.twitter.util.Throw;
import com.twitter.util.Throwables$;
import com.twitter.util.Try;

public final class ExceptionUtils$ {
    public static ExceptionUtils$ MODULE$;

    static {
        new ExceptionUtils$();
    }

    public String stripNewlines(Throwable e) {
        return this.stripNewlines(e.toString());
    }

    public String stripNewlines(String str) {
        return str.replace("\n\twith NoSources", "");
    }

    public String toExceptionDetails(Throwable exception) {
        return Throwables$.MODULE$.mkString(exception).mkString("/");
    }

    public String toExceptionMessage(Try<?> tryThrowable) {
        String string2;
        Try<?> try_ = tryThrowable;
        if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable e = throw_.e();
            string2 = this.toExceptionMessage(e);
        } else {
            string2 = "";
        }
        return string2;
    }

    public String toExceptionMessage(Throwable exception) {
        String string2;
        Throwable throwable = exception;
        if (throwable instanceof TimeoutException) {
            TimeoutException timeoutException = (TimeoutException)throwable;
            string2 = timeoutException.exceptionMessage();
        } else if (throwable instanceof FailedFastException) {
            FailedFastException failedFastException = (FailedFastException)throwable;
            string2 = failedFastException.getClass().getName();
        } else if (throwable instanceof SourcedException) {
            SourcedException sourcedException = (SourcedException)throwable;
            string2 = this.stripNewlines((Throwable)sourcedException);
        } else {
            String msg = throwable.getMessage();
            string2 = msg == null || msg.isEmpty() ? throwable.getClass().getName() : new StringBuilder(1).append(throwable.getClass().getName()).append(" ").append(msg).toString();
        }
        return string2;
    }

    public String toDetailedExceptionMessage(Try<?> tryThrowable) {
        String string2;
        Try<?> try_ = tryThrowable;
        if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable e = throw_.e();
            string2 = new StringBuilder(1).append(this.toExceptionDetails(e)).append(" ").append(this.toExceptionMessage(e)).toString();
        } else {
            string2 = "";
        }
        return string2;
    }

    public boolean isCancellation(Throwable t) {
        boolean bl;
        block7: {
            while (true) {
                Failure failure;
                boolean bl2 = false;
                FailureFlags failureFlags = null;
                Throwable throwable = t;
                if (throwable instanceof CancelledRequestException) {
                    bl = true;
                    break block7;
                }
                if (throwable instanceof CancelledConnectionException) {
                    bl = true;
                    break block7;
                }
                if (throwable instanceof ClientDiscardedRequestException) {
                    bl = true;
                    break block7;
                }
                if (throwable instanceof FailureFlags) {
                    bl2 = true;
                    failureFlags = (FailureFlags)throwable;
                    if (failureFlags.isFlagged(FailureFlags$.MODULE$.Ignorable())) {
                        bl = true;
                        break block7;
                    }
                }
                if (bl2 && failureFlags.isFlagged(FailureFlags$.MODULE$.Interrupted())) {
                    bl = true;
                    break block7;
                }
                if (!(throwable instanceof Failure) || !(failure = (Failure)throwable).cause().isDefined()) break;
                t = (Throwable)failure.cause().get();
            }
            bl = false;
        }
        return bl;
    }

    public boolean isNonRetryable(Throwable t) {
        boolean bl;
        block3: {
            while (true) {
                Failure failure;
                FailureFlags failureFlags;
                Throwable throwable;
                if ((throwable = t) instanceof NonRetryableException) {
                    bl = true;
                    break block3;
                }
                if (throwable instanceof FailureFlags && (failureFlags = (FailureFlags)throwable).isFlagged(FailureFlags$.MODULE$.Ignorable())) {
                    bl = true;
                    break block3;
                }
                if (!(throwable instanceof Failure) || !(failure = (Failure)throwable).cause().isDefined()) break;
                t = (Throwable)failure.cause().get();
            }
            bl = false;
        }
        return bl;
    }

    private ExceptionUtils$() {
        MODULE$ = this;
    }
}

