/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.Base64Util$;
import com.twitter.joauth.NonceValidator;
import com.twitter.joauth.OAuth1Request;
import com.twitter.joauth.Signer;
import com.twitter.joauth.StandardVerifier$;
import com.twitter.joauth.UrlDecoder$;
import com.twitter.joauth.Verifier;
import com.twitter.joauth.VerifierResult;
import org.slf4j.Logger;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e<Q!\u0001\u0002\t\u0006%\t\u0001c\u0015;b]\u0012\f'\u000f\u001a,fe&4\u0017.\u001a:\u000b\u0005\r!\u0011A\u00026pCV$\bN\u0003\u0002\u0006\r\u00059Ao^5ui\u0016\u0014(\"A\u0004\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005)YQ\"\u0001\u0002\u0007\u000b1\u0011\u0001RA\u0007\u0003!M#\u0018M\u001c3be\u00124VM]5gS\u0016\u00148cA\u0006\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000f\f\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u001d\u00013B1A\u0005\n\u0005\n1\u0001\\8h+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\n\u0002\u0007\u0019><w-\u001a:\t\r-Z\u0001\u0015!\u0003#\u0003\u0011awn\u001a\u0011\u0007\t1\u0011\u0001!L\n\u0005Y9qc\u0003\u0005\u0002\u000b_%\u0011\u0001G\u0001\u0002\t-\u0016\u0014\u0018NZ5fe\"A!\u0007\fB\u0001B\u0003%1'\u0001\u0004tS\u001etWM\u001d\t\u0003\u0015QJ!!\u000e\u0002\u0003\rMKwM\\3s\u0011!9DF!A!\u0002\u0013A\u0014AF7bq\u000ecwnY6GY>\fG/\u00115fC\u0012l\u0015N\\:\u0011\u0005]I\u0014B\u0001\u001e\u0019\u0005\rIe\u000e\u001e\u0005\ty1\u0012\t\u0011)A\u0005q\u00059R.\u0019=DY>\u001c7N\u00127pCR\u0014U\r[5oI6Kgn\u001d\u0005\t}1\u0012\t\u0011)A\u0005\u007f\u0005ia/\u00197jI\u0006$XMT8oG\u0016\u0004\"A\u0003!\n\u0005\u0005\u0013!A\u0004(p]\u000e,g+\u00197jI\u0006$xN\u001d\u0005\u0006;1\"\ta\u0011\u000b\u0006\t\u00163u\t\u0013\t\u0003\u00151BQA\r\"A\u0002MBQa\u000e\"A\u0002aBQ\u0001\u0010\"A\u0002aBQA\u0010\"A\u0002}BqA\u0013\u0017C\u0002\u0013\u00051*\u0001\fnCb\u001cEn\\2l\r2|\u0017\r^!iK\u0006$7+Z2t+\u0005a\u0005CA\fN\u0013\tq\u0005D\u0001\u0003M_:<\u0007B\u0002)-A\u0003%A*A\fnCb\u001cEn\\2l\r2|\u0017\r^!iK\u0006$7+Z2tA!9!\u000b\fb\u0001\n\u0003Y\u0015aF7bq\u000ecwnY6GY>\fGOQ3iS:$7+Z2t\u0011\u0019!F\u0006)A\u0005\u0019\u0006AR.\u0019=DY>\u001c7N\u00127pCR\u0014U\r[5oIN+7m\u001d\u0011\t\u000bYcC\u0011I,\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\ta[\u0006-\u001b\t\u0003\u0015eK!A\u0017\u0002\u0003\u001dY+'/\u001b4jKJ\u0014Vm];mi\")A,\u0016a\u0001;\u00069!/Z9vKN$\bC\u0001\u0006_\u0013\ty&AA\u0007P\u0003V$\b.\r*fcV,7\u000f\u001e\u0005\u0006CV\u0003\rAY\u0001\fi>\\WM\\*fGJ,G\u000f\u0005\u0002dM:\u0011q\u0003Z\u0005\u0003Kb\ta\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q\r\u0007\u0005\u0006UV\u0003\rAY\u0001\u000fG>t7/^7feN+7M]3u\u0011\u0015aG\u0006\"\u0001n\u0003U1\u0018\r\\5eCR,G+[7fgR\fW\u000e]*fGN$\"A\\9\u0011\u0005]y\u0017B\u00019\u0019\u0005\u001d\u0011un\u001c7fC:DQA]6A\u00021\u000bQ\u0002^5nKN$\u0018-\u001c9TK\u000e\u001c\b\"\u0002;-\t\u0003)\u0018!\u0005<bY&$\u0017\r^3TS\u001et\u0017\r^;sKR!aN^<y\u0011\u0015a6\u000f1\u0001^\u0011\u0015\t7\u000f1\u0001c\u0011\u0015Q7\u000f1\u0001c\u0001")
public class StandardVerifier
implements Verifier,
ScalaObject {
    private final Signer signer;
    private final int maxClockFloatAheadMins;
    private final int maxClockFloatBehindMins;
    private final NonceValidator validateNonce;
    private final long maxClockFloatAheadSecs;
    private final long maxClockFloatBehindSecs;

    public static final Logger com$twitter$joauth$StandardVerifier$$log() {
        return StandardVerifier$.MODULE$.com$twitter$joauth$StandardVerifier$$log();
    }

    public long maxClockFloatAheadSecs() {
        return this.maxClockFloatAheadSecs;
    }

    public long maxClockFloatBehindSecs() {
        return this.maxClockFloatBehindSecs;
    }

    public VerifierResult apply(OAuth1Request request, String tokenSecret, String consumerSecret) {
        VerifierResult verifierResult;
        if (BoxesRunTime.unboxToBoolean((Object)this.validateNonce.apply(request.nonce()))) {
            if (this.validateTimestampSecs(request.timestampSecs())) {
                if (this.validateSignature(request, tokenSecret, consumerSecret)) {
                    verifierResult = VerifierResult.OK;
                } else {
                    StandardVerifier$.MODULE$.com$twitter$joauth$StandardVerifier$$log().debug("bad signature -> {}", new Object[]{request.toString()});
                    verifierResult = VerifierResult.BAD_SIGNATURE;
                }
            } else {
                StandardVerifier$.MODULE$.com$twitter$joauth$StandardVerifier$$log().debug("bad timestamp -> {}", new Object[]{request.toString()});
                verifierResult = VerifierResult.BAD_TIMESTAMP;
            }
        } else {
            StandardVerifier$.MODULE$.com$twitter$joauth$StandardVerifier$$log().debug("bad nonce -> {}", new Object[]{request.toString()});
            verifierResult = VerifierResult.BAD_NONCE;
        }
        return verifierResult;
    }

    public boolean validateTimestampSecs(long timestampSecs) {
        long nowSecs = System.currentTimeMillis() / 1000L;
        return !(this.maxClockFloatBehindMins >= 0 && timestampSecs < nowSecs - this.maxClockFloatBehindSecs() || this.maxClockFloatAheadMins >= 0 && timestampSecs > nowSecs + this.maxClockFloatAheadSecs());
    }

    public boolean validateSignature(OAuth1Request request, String tokenSecret, String consumerSecret) {
        boolean exceptionResult1 = false;
        try {
            exceptionResult1 = Base64Util$.MODULE$.equals(UrlDecoder$.MODULE$.apply(request.signature()).trim(), this.signer.getBytes(request.normalizedRequest(), tokenSecret, consumerSecret));
            return exceptionResult1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public StandardVerifier(Signer signer, int maxClockFloatAheadMins, int maxClockFloatBehindMins, NonceValidator validateNonce) {
        this.signer = signer;
        this.maxClockFloatAheadMins = maxClockFloatAheadMins;
        this.maxClockFloatBehindMins = maxClockFloatBehindMins;
        this.validateNonce = validateNonce;
        this.maxClockFloatAheadSecs = (long)maxClockFloatAheadMins * 60L;
        this.maxClockFloatBehindSecs = (long)maxClockFloatBehindMins * 60L;
    }
}

