/*
 * Decompiled with CFR 0.152.
 */
package parquet.format;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import parquet.format.CompressionCodec;
import parquet.format.Encoding;
import parquet.format.KeyValue;
import parquet.format.PageEncodingStats;
import parquet.format.Statistics;
import parquet.format.Type;
import parquet.org.apache.thrift.TBase;
import parquet.org.apache.thrift.TBaseHelper;
import parquet.org.apache.thrift.TException;
import parquet.org.apache.thrift.TFieldIdEnum;
import parquet.org.apache.thrift.meta_data.EnumMetaData;
import parquet.org.apache.thrift.meta_data.FieldMetaData;
import parquet.org.apache.thrift.meta_data.FieldValueMetaData;
import parquet.org.apache.thrift.meta_data.ListMetaData;
import parquet.org.apache.thrift.meta_data.StructMetaData;
import parquet.org.apache.thrift.protocol.TField;
import parquet.org.apache.thrift.protocol.TList;
import parquet.org.apache.thrift.protocol.TProtocol;
import parquet.org.apache.thrift.protocol.TProtocolException;
import parquet.org.apache.thrift.protocol.TProtocolUtil;
import parquet.org.apache.thrift.protocol.TStruct;

public class ColumnMetaData
implements TBase<ColumnMetaData, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("ColumnMetaData");
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 1);
    private static final TField ENCODINGS_FIELD_DESC = new TField("encodings", 15, 2);
    private static final TField PATH_IN_SCHEMA_FIELD_DESC = new TField("path_in_schema", 15, 3);
    private static final TField CODEC_FIELD_DESC = new TField("codec", 8, 4);
    private static final TField NUM_VALUES_FIELD_DESC = new TField("num_values", 10, 5);
    private static final TField TOTAL_UNCOMPRESSED_SIZE_FIELD_DESC = new TField("total_uncompressed_size", 10, 6);
    private static final TField TOTAL_COMPRESSED_SIZE_FIELD_DESC = new TField("total_compressed_size", 10, 7);
    private static final TField KEY_VALUE_METADATA_FIELD_DESC = new TField("key_value_metadata", 15, 8);
    private static final TField DATA_PAGE_OFFSET_FIELD_DESC = new TField("data_page_offset", 10, 9);
    private static final TField INDEX_PAGE_OFFSET_FIELD_DESC = new TField("index_page_offset", 10, 10);
    private static final TField DICTIONARY_PAGE_OFFSET_FIELD_DESC = new TField("dictionary_page_offset", 10, 11);
    private static final TField STATISTICS_FIELD_DESC = new TField("statistics", 12, 12);
    private static final TField ENCODING_STATS_FIELD_DESC = new TField("encoding_stats", 15, 13);
    public Type type;
    public List<Encoding> encodings;
    public List<String> path_in_schema;
    public CompressionCodec codec;
    public long num_values;
    public long total_uncompressed_size;
    public long total_compressed_size;
    public List<KeyValue> key_value_metadata;
    public long data_page_offset;
    public long index_page_offset;
    public long dictionary_page_offset;
    public Statistics statistics;
    public List<PageEncodingStats> encoding_stats;
    private static final int __NUM_VALUES_ISSET_ID = 0;
    private static final int __TOTAL_UNCOMPRESSED_SIZE_ISSET_ID = 1;
    private static final int __TOTAL_COMPRESSED_SIZE_ISSET_ID = 2;
    private static final int __DATA_PAGE_OFFSET_ISSET_ID = 3;
    private static final int __INDEX_PAGE_OFFSET_ISSET_ID = 4;
    private static final int __DICTIONARY_PAGE_OFFSET_ISSET_ID = 5;
    private BitSet __isset_bit_vector = new BitSet(6);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ColumnMetaData() {
    }

    public ColumnMetaData(Type type, List<Encoding> encodings, List<String> path_in_schema, CompressionCodec codec, long num_values, long total_uncompressed_size, long total_compressed_size, long data_page_offset) {
        this();
        this.type = type;
        this.encodings = encodings;
        this.path_in_schema = path_in_schema;
        this.codec = codec;
        this.num_values = num_values;
        this.setNum_valuesIsSet(true);
        this.total_uncompressed_size = total_uncompressed_size;
        this.setTotal_uncompressed_sizeIsSet(true);
        this.total_compressed_size = total_compressed_size;
        this.setTotal_compressed_sizeIsSet(true);
        this.data_page_offset = data_page_offset;
        this.setData_page_offsetIsSet(true);
    }

    public ColumnMetaData(ColumnMetaData other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetEncodings()) {
            ArrayList<Encoding> __this__encodings = new ArrayList<Encoding>();
            for (Encoding encoding : other.encodings) {
                __this__encodings.add(encoding);
            }
            this.encodings = __this__encodings;
        }
        if (other.isSetPath_in_schema()) {
            ArrayList<String> __this__path_in_schema = new ArrayList<String>();
            for (String string : other.path_in_schema) {
                __this__path_in_schema.add(string);
            }
            this.path_in_schema = __this__path_in_schema;
        }
        if (other.isSetCodec()) {
            this.codec = other.codec;
        }
        this.num_values = other.num_values;
        this.total_uncompressed_size = other.total_uncompressed_size;
        this.total_compressed_size = other.total_compressed_size;
        if (other.isSetKey_value_metadata()) {
            ArrayList<KeyValue> __this__key_value_metadata = new ArrayList<KeyValue>();
            for (KeyValue keyValue : other.key_value_metadata) {
                __this__key_value_metadata.add(new KeyValue(keyValue));
            }
            this.key_value_metadata = __this__key_value_metadata;
        }
        this.data_page_offset = other.data_page_offset;
        this.index_page_offset = other.index_page_offset;
        this.dictionary_page_offset = other.dictionary_page_offset;
        if (other.isSetStatistics()) {
            this.statistics = new Statistics(other.statistics);
        }
        if (other.isSetEncoding_stats()) {
            ArrayList<PageEncodingStats> __this__encoding_stats = new ArrayList<PageEncodingStats>();
            for (PageEncodingStats pageEncodingStats : other.encoding_stats) {
                __this__encoding_stats.add(new PageEncodingStats(pageEncodingStats));
            }
            this.encoding_stats = __this__encoding_stats;
        }
    }

    public ColumnMetaData deepCopy() {
        return new ColumnMetaData(this);
    }

    @Override
    public void clear() {
        this.type = null;
        this.encodings = null;
        this.path_in_schema = null;
        this.codec = null;
        this.setNum_valuesIsSet(false);
        this.num_values = 0L;
        this.setTotal_uncompressed_sizeIsSet(false);
        this.total_uncompressed_size = 0L;
        this.setTotal_compressed_sizeIsSet(false);
        this.total_compressed_size = 0L;
        this.key_value_metadata = null;
        this.setData_page_offsetIsSet(false);
        this.data_page_offset = 0L;
        this.setIndex_page_offsetIsSet(false);
        this.index_page_offset = 0L;
        this.setDictionary_page_offsetIsSet(false);
        this.dictionary_page_offset = 0L;
        this.statistics = null;
        this.encoding_stats = null;
    }

    public Type getType() {
        return this.type;
    }

    public ColumnMetaData setType(Type type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public int getEncodingsSize() {
        return this.encodings == null ? 0 : this.encodings.size();
    }

    public Iterator<Encoding> getEncodingsIterator() {
        return this.encodings == null ? null : this.encodings.iterator();
    }

    public void addToEncodings(Encoding elem) {
        if (this.encodings == null) {
            this.encodings = new ArrayList<Encoding>();
        }
        this.encodings.add(elem);
    }

    public List<Encoding> getEncodings() {
        return this.encodings;
    }

    public ColumnMetaData setEncodings(List<Encoding> encodings) {
        this.encodings = encodings;
        return this;
    }

    public void unsetEncodings() {
        this.encodings = null;
    }

    public boolean isSetEncodings() {
        return this.encodings != null;
    }

    public void setEncodingsIsSet(boolean value) {
        if (!value) {
            this.encodings = null;
        }
    }

    public int getPath_in_schemaSize() {
        return this.path_in_schema == null ? 0 : this.path_in_schema.size();
    }

    public Iterator<String> getPath_in_schemaIterator() {
        return this.path_in_schema == null ? null : this.path_in_schema.iterator();
    }

    public void addToPath_in_schema(String elem) {
        if (this.path_in_schema == null) {
            this.path_in_schema = new ArrayList<String>();
        }
        this.path_in_schema.add(elem);
    }

    public List<String> getPath_in_schema() {
        return this.path_in_schema;
    }

    public ColumnMetaData setPath_in_schema(List<String> path_in_schema) {
        this.path_in_schema = path_in_schema;
        return this;
    }

    public void unsetPath_in_schema() {
        this.path_in_schema = null;
    }

    public boolean isSetPath_in_schema() {
        return this.path_in_schema != null;
    }

    public void setPath_in_schemaIsSet(boolean value) {
        if (!value) {
            this.path_in_schema = null;
        }
    }

    public CompressionCodec getCodec() {
        return this.codec;
    }

    public ColumnMetaData setCodec(CompressionCodec codec) {
        this.codec = codec;
        return this;
    }

    public void unsetCodec() {
        this.codec = null;
    }

    public boolean isSetCodec() {
        return this.codec != null;
    }

    public void setCodecIsSet(boolean value) {
        if (!value) {
            this.codec = null;
        }
    }

    public long getNum_values() {
        return this.num_values;
    }

    public ColumnMetaData setNum_values(long num_values) {
        this.num_values = num_values;
        this.setNum_valuesIsSet(true);
        return this;
    }

    public void unsetNum_values() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetNum_values() {
        return this.__isset_bit_vector.get(0);
    }

    public void setNum_valuesIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public long getTotal_uncompressed_size() {
        return this.total_uncompressed_size;
    }

    public ColumnMetaData setTotal_uncompressed_size(long total_uncompressed_size) {
        this.total_uncompressed_size = total_uncompressed_size;
        this.setTotal_uncompressed_sizeIsSet(true);
        return this;
    }

    public void unsetTotal_uncompressed_size() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetTotal_uncompressed_size() {
        return this.__isset_bit_vector.get(1);
    }

    public void setTotal_uncompressed_sizeIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public long getTotal_compressed_size() {
        return this.total_compressed_size;
    }

    public ColumnMetaData setTotal_compressed_size(long total_compressed_size) {
        this.total_compressed_size = total_compressed_size;
        this.setTotal_compressed_sizeIsSet(true);
        return this;
    }

    public void unsetTotal_compressed_size() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetTotal_compressed_size() {
        return this.__isset_bit_vector.get(2);
    }

    public void setTotal_compressed_sizeIsSet(boolean value) {
        this.__isset_bit_vector.set(2, value);
    }

    public int getKey_value_metadataSize() {
        return this.key_value_metadata == null ? 0 : this.key_value_metadata.size();
    }

    public Iterator<KeyValue> getKey_value_metadataIterator() {
        return this.key_value_metadata == null ? null : this.key_value_metadata.iterator();
    }

    public void addToKey_value_metadata(KeyValue elem) {
        if (this.key_value_metadata == null) {
            this.key_value_metadata = new ArrayList<KeyValue>();
        }
        this.key_value_metadata.add(elem);
    }

    public List<KeyValue> getKey_value_metadata() {
        return this.key_value_metadata;
    }

    public ColumnMetaData setKey_value_metadata(List<KeyValue> key_value_metadata) {
        this.key_value_metadata = key_value_metadata;
        return this;
    }

    public void unsetKey_value_metadata() {
        this.key_value_metadata = null;
    }

    public boolean isSetKey_value_metadata() {
        return this.key_value_metadata != null;
    }

    public void setKey_value_metadataIsSet(boolean value) {
        if (!value) {
            this.key_value_metadata = null;
        }
    }

    public long getData_page_offset() {
        return this.data_page_offset;
    }

    public ColumnMetaData setData_page_offset(long data_page_offset) {
        this.data_page_offset = data_page_offset;
        this.setData_page_offsetIsSet(true);
        return this;
    }

    public void unsetData_page_offset() {
        this.__isset_bit_vector.clear(3);
    }

    public boolean isSetData_page_offset() {
        return this.__isset_bit_vector.get(3);
    }

    public void setData_page_offsetIsSet(boolean value) {
        this.__isset_bit_vector.set(3, value);
    }

    public long getIndex_page_offset() {
        return this.index_page_offset;
    }

    public ColumnMetaData setIndex_page_offset(long index_page_offset) {
        this.index_page_offset = index_page_offset;
        this.setIndex_page_offsetIsSet(true);
        return this;
    }

    public void unsetIndex_page_offset() {
        this.__isset_bit_vector.clear(4);
    }

    public boolean isSetIndex_page_offset() {
        return this.__isset_bit_vector.get(4);
    }

    public void setIndex_page_offsetIsSet(boolean value) {
        this.__isset_bit_vector.set(4, value);
    }

    public long getDictionary_page_offset() {
        return this.dictionary_page_offset;
    }

    public ColumnMetaData setDictionary_page_offset(long dictionary_page_offset) {
        this.dictionary_page_offset = dictionary_page_offset;
        this.setDictionary_page_offsetIsSet(true);
        return this;
    }

    public void unsetDictionary_page_offset() {
        this.__isset_bit_vector.clear(5);
    }

    public boolean isSetDictionary_page_offset() {
        return this.__isset_bit_vector.get(5);
    }

    public void setDictionary_page_offsetIsSet(boolean value) {
        this.__isset_bit_vector.set(5, value);
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public ColumnMetaData setStatistics(Statistics statistics) {
        this.statistics = statistics;
        return this;
    }

    public void unsetStatistics() {
        this.statistics = null;
    }

    public boolean isSetStatistics() {
        return this.statistics != null;
    }

    public void setStatisticsIsSet(boolean value) {
        if (!value) {
            this.statistics = null;
        }
    }

    public int getEncoding_statsSize() {
        return this.encoding_stats == null ? 0 : this.encoding_stats.size();
    }

    public Iterator<PageEncodingStats> getEncoding_statsIterator() {
        return this.encoding_stats == null ? null : this.encoding_stats.iterator();
    }

    public void addToEncoding_stats(PageEncodingStats elem) {
        if (this.encoding_stats == null) {
            this.encoding_stats = new ArrayList<PageEncodingStats>();
        }
        this.encoding_stats.add(elem);
    }

    public List<PageEncodingStats> getEncoding_stats() {
        return this.encoding_stats;
    }

    public ColumnMetaData setEncoding_stats(List<PageEncodingStats> encoding_stats) {
        this.encoding_stats = encoding_stats;
        return this;
    }

    public void unsetEncoding_stats() {
        this.encoding_stats = null;
    }

    public boolean isSetEncoding_stats() {
        return this.encoding_stats != null;
    }

    public void setEncoding_statsIsSet(boolean value) {
        if (!value) {
            this.encoding_stats = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((Type)value);
                break;
            }
            case ENCODINGS: {
                if (value == null) {
                    this.unsetEncodings();
                    break;
                }
                this.setEncodings((List)value);
                break;
            }
            case PATH_IN_SCHEMA: {
                if (value == null) {
                    this.unsetPath_in_schema();
                    break;
                }
                this.setPath_in_schema((List)value);
                break;
            }
            case CODEC: {
                if (value == null) {
                    this.unsetCodec();
                    break;
                }
                this.setCodec((CompressionCodec)value);
                break;
            }
            case NUM_VALUES: {
                if (value == null) {
                    this.unsetNum_values();
                    break;
                }
                this.setNum_values((Long)value);
                break;
            }
            case TOTAL_UNCOMPRESSED_SIZE: {
                if (value == null) {
                    this.unsetTotal_uncompressed_size();
                    break;
                }
                this.setTotal_uncompressed_size((Long)value);
                break;
            }
            case TOTAL_COMPRESSED_SIZE: {
                if (value == null) {
                    this.unsetTotal_compressed_size();
                    break;
                }
                this.setTotal_compressed_size((Long)value);
                break;
            }
            case KEY_VALUE_METADATA: {
                if (value == null) {
                    this.unsetKey_value_metadata();
                    break;
                }
                this.setKey_value_metadata((List)value);
                break;
            }
            case DATA_PAGE_OFFSET: {
                if (value == null) {
                    this.unsetData_page_offset();
                    break;
                }
                this.setData_page_offset((Long)value);
                break;
            }
            case INDEX_PAGE_OFFSET: {
                if (value == null) {
                    this.unsetIndex_page_offset();
                    break;
                }
                this.setIndex_page_offset((Long)value);
                break;
            }
            case DICTIONARY_PAGE_OFFSET: {
                if (value == null) {
                    this.unsetDictionary_page_offset();
                    break;
                }
                this.setDictionary_page_offset((Long)value);
                break;
            }
            case STATISTICS: {
                if (value == null) {
                    this.unsetStatistics();
                    break;
                }
                this.setStatistics((Statistics)value);
                break;
            }
            case ENCODING_STATS: {
                if (value == null) {
                    this.unsetEncoding_stats();
                    break;
                }
                this.setEncoding_stats((List)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TYPE: {
                return this.getType();
            }
            case ENCODINGS: {
                return this.getEncodings();
            }
            case PATH_IN_SCHEMA: {
                return this.getPath_in_schema();
            }
            case CODEC: {
                return this.getCodec();
            }
            case NUM_VALUES: {
                return new Long(this.getNum_values());
            }
            case TOTAL_UNCOMPRESSED_SIZE: {
                return new Long(this.getTotal_uncompressed_size());
            }
            case TOTAL_COMPRESSED_SIZE: {
                return new Long(this.getTotal_compressed_size());
            }
            case KEY_VALUE_METADATA: {
                return this.getKey_value_metadata();
            }
            case DATA_PAGE_OFFSET: {
                return new Long(this.getData_page_offset());
            }
            case INDEX_PAGE_OFFSET: {
                return new Long(this.getIndex_page_offset());
            }
            case DICTIONARY_PAGE_OFFSET: {
                return new Long(this.getDictionary_page_offset());
            }
            case STATISTICS: {
                return this.getStatistics();
            }
            case ENCODING_STATS: {
                return this.getEncoding_stats();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TYPE: {
                return this.isSetType();
            }
            case ENCODINGS: {
                return this.isSetEncodings();
            }
            case PATH_IN_SCHEMA: {
                return this.isSetPath_in_schema();
            }
            case CODEC: {
                return this.isSetCodec();
            }
            case NUM_VALUES: {
                return this.isSetNum_values();
            }
            case TOTAL_UNCOMPRESSED_SIZE: {
                return this.isSetTotal_uncompressed_size();
            }
            case TOTAL_COMPRESSED_SIZE: {
                return this.isSetTotal_compressed_size();
            }
            case KEY_VALUE_METADATA: {
                return this.isSetKey_value_metadata();
            }
            case DATA_PAGE_OFFSET: {
                return this.isSetData_page_offset();
            }
            case INDEX_PAGE_OFFSET: {
                return this.isSetIndex_page_offset();
            }
            case DICTIONARY_PAGE_OFFSET: {
                return this.isSetDictionary_page_offset();
            }
            case STATISTICS: {
                return this.isSetStatistics();
            }
            case ENCODING_STATS: {
                return this.isSetEncoding_stats();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ColumnMetaData) {
            return this.equals((ColumnMetaData)that);
        }
        return false;
    }

    public boolean equals(ColumnMetaData that) {
        if (that == null) {
            return false;
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals(that.type)) {
                return false;
            }
        }
        boolean this_present_encodings = this.isSetEncodings();
        boolean that_present_encodings = that.isSetEncodings();
        if (this_present_encodings || that_present_encodings) {
            if (!this_present_encodings || !that_present_encodings) {
                return false;
            }
            if (!this.encodings.equals(that.encodings)) {
                return false;
            }
        }
        boolean this_present_path_in_schema = this.isSetPath_in_schema();
        boolean that_present_path_in_schema = that.isSetPath_in_schema();
        if (this_present_path_in_schema || that_present_path_in_schema) {
            if (!this_present_path_in_schema || !that_present_path_in_schema) {
                return false;
            }
            if (!this.path_in_schema.equals(that.path_in_schema)) {
                return false;
            }
        }
        boolean this_present_codec = this.isSetCodec();
        boolean that_present_codec = that.isSetCodec();
        if (this_present_codec || that_present_codec) {
            if (!this_present_codec || !that_present_codec) {
                return false;
            }
            if (!this.codec.equals(that.codec)) {
                return false;
            }
        }
        boolean this_present_num_values = true;
        boolean that_present_num_values = true;
        if (this_present_num_values || that_present_num_values) {
            if (!this_present_num_values || !that_present_num_values) {
                return false;
            }
            if (this.num_values != that.num_values) {
                return false;
            }
        }
        boolean this_present_total_uncompressed_size = true;
        boolean that_present_total_uncompressed_size = true;
        if (this_present_total_uncompressed_size || that_present_total_uncompressed_size) {
            if (!this_present_total_uncompressed_size || !that_present_total_uncompressed_size) {
                return false;
            }
            if (this.total_uncompressed_size != that.total_uncompressed_size) {
                return false;
            }
        }
        boolean this_present_total_compressed_size = true;
        boolean that_present_total_compressed_size = true;
        if (this_present_total_compressed_size || that_present_total_compressed_size) {
            if (!this_present_total_compressed_size || !that_present_total_compressed_size) {
                return false;
            }
            if (this.total_compressed_size != that.total_compressed_size) {
                return false;
            }
        }
        boolean this_present_key_value_metadata = this.isSetKey_value_metadata();
        boolean that_present_key_value_metadata = that.isSetKey_value_metadata();
        if (this_present_key_value_metadata || that_present_key_value_metadata) {
            if (!this_present_key_value_metadata || !that_present_key_value_metadata) {
                return false;
            }
            if (!this.key_value_metadata.equals(that.key_value_metadata)) {
                return false;
            }
        }
        boolean this_present_data_page_offset = true;
        boolean that_present_data_page_offset = true;
        if (this_present_data_page_offset || that_present_data_page_offset) {
            if (!this_present_data_page_offset || !that_present_data_page_offset) {
                return false;
            }
            if (this.data_page_offset != that.data_page_offset) {
                return false;
            }
        }
        boolean this_present_index_page_offset = this.isSetIndex_page_offset();
        boolean that_present_index_page_offset = that.isSetIndex_page_offset();
        if (this_present_index_page_offset || that_present_index_page_offset) {
            if (!this_present_index_page_offset || !that_present_index_page_offset) {
                return false;
            }
            if (this.index_page_offset != that.index_page_offset) {
                return false;
            }
        }
        boolean this_present_dictionary_page_offset = this.isSetDictionary_page_offset();
        boolean that_present_dictionary_page_offset = that.isSetDictionary_page_offset();
        if (this_present_dictionary_page_offset || that_present_dictionary_page_offset) {
            if (!this_present_dictionary_page_offset || !that_present_dictionary_page_offset) {
                return false;
            }
            if (this.dictionary_page_offset != that.dictionary_page_offset) {
                return false;
            }
        }
        boolean this_present_statistics = this.isSetStatistics();
        boolean that_present_statistics = that.isSetStatistics();
        if (this_present_statistics || that_present_statistics) {
            if (!this_present_statistics || !that_present_statistics) {
                return false;
            }
            if (!this.statistics.equals(that.statistics)) {
                return false;
            }
        }
        boolean this_present_encoding_stats = this.isSetEncoding_stats();
        boolean that_present_encoding_stats = that.isSetEncoding_stats();
        if (this_present_encoding_stats || that_present_encoding_stats) {
            if (!this_present_encoding_stats || !that_present_encoding_stats) {
                return false;
            }
            if (!this.encoding_stats.equals(that.encoding_stats)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_type = this.isSetType();
        builder.append(present_type);
        if (present_type) {
            builder.append(this.type.getValue());
        }
        boolean present_encodings = this.isSetEncodings();
        builder.append(present_encodings);
        if (present_encodings) {
            builder.append(this.encodings);
        }
        boolean present_path_in_schema = this.isSetPath_in_schema();
        builder.append(present_path_in_schema);
        if (present_path_in_schema) {
            builder.append(this.path_in_schema);
        }
        boolean present_codec = this.isSetCodec();
        builder.append(present_codec);
        if (present_codec) {
            builder.append(this.codec.getValue());
        }
        boolean present_num_values = true;
        builder.append(present_num_values);
        if (present_num_values) {
            builder.append(this.num_values);
        }
        boolean present_total_uncompressed_size = true;
        builder.append(present_total_uncompressed_size);
        if (present_total_uncompressed_size) {
            builder.append(this.total_uncompressed_size);
        }
        boolean present_total_compressed_size = true;
        builder.append(present_total_compressed_size);
        if (present_total_compressed_size) {
            builder.append(this.total_compressed_size);
        }
        boolean present_key_value_metadata = this.isSetKey_value_metadata();
        builder.append(present_key_value_metadata);
        if (present_key_value_metadata) {
            builder.append(this.key_value_metadata);
        }
        boolean present_data_page_offset = true;
        builder.append(present_data_page_offset);
        if (present_data_page_offset) {
            builder.append(this.data_page_offset);
        }
        boolean present_index_page_offset = this.isSetIndex_page_offset();
        builder.append(present_index_page_offset);
        if (present_index_page_offset) {
            builder.append(this.index_page_offset);
        }
        boolean present_dictionary_page_offset = this.isSetDictionary_page_offset();
        builder.append(present_dictionary_page_offset);
        if (present_dictionary_page_offset) {
            builder.append(this.dictionary_page_offset);
        }
        boolean present_statistics = this.isSetStatistics();
        builder.append(present_statistics);
        if (present_statistics) {
            builder.append((Object)this.statistics);
        }
        boolean present_encoding_stats = this.isSetEncoding_stats();
        builder.append(present_encoding_stats);
        if (present_encoding_stats) {
            builder.append(this.encoding_stats);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(ColumnMetaData other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        ColumnMetaData typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(typedOther.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)typedOther.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEncodings()).compareTo(typedOther.isSetEncodings());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncodings() && (lastComparison = TBaseHelper.compareTo(this.encodings, typedOther.encodings)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPath_in_schema()).compareTo(typedOther.isSetPath_in_schema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPath_in_schema() && (lastComparison = TBaseHelper.compareTo(this.path_in_schema, typedOther.path_in_schema)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCodec()).compareTo(typedOther.isSetCodec());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCodec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.codec), (Comparable)((Object)typedOther.codec))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNum_values()).compareTo(typedOther.isSetNum_values());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNum_values() && (lastComparison = TBaseHelper.compareTo(this.num_values, typedOther.num_values)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTotal_uncompressed_size()).compareTo(typedOther.isSetTotal_uncompressed_size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTotal_uncompressed_size() && (lastComparison = TBaseHelper.compareTo(this.total_uncompressed_size, typedOther.total_uncompressed_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTotal_compressed_size()).compareTo(typedOther.isSetTotal_compressed_size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTotal_compressed_size() && (lastComparison = TBaseHelper.compareTo(this.total_compressed_size, typedOther.total_compressed_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKey_value_metadata()).compareTo(typedOther.isSetKey_value_metadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey_value_metadata() && (lastComparison = TBaseHelper.compareTo(this.key_value_metadata, typedOther.key_value_metadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetData_page_offset()).compareTo(typedOther.isSetData_page_offset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetData_page_offset() && (lastComparison = TBaseHelper.compareTo(this.data_page_offset, typedOther.data_page_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndex_page_offset()).compareTo(typedOther.isSetIndex_page_offset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndex_page_offset() && (lastComparison = TBaseHelper.compareTo(this.index_page_offset, typedOther.index_page_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDictionary_page_offset()).compareTo(typedOther.isSetDictionary_page_offset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDictionary_page_offset() && (lastComparison = TBaseHelper.compareTo(this.dictionary_page_offset, typedOther.dictionary_page_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStatistics()).compareTo(typedOther.isSetStatistics());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStatistics() && (lastComparison = TBaseHelper.compareTo(this.statistics, typedOther.statistics)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEncoding_stats()).compareTo(typedOther.isSetEncoding_stats());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncoding_stats() && (lastComparison = TBaseHelper.compareTo(this.encoding_stats, typedOther.encoding_stats)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.type = Type.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list0 = iprot.readListBegin();
                        this.encodings = new ArrayList<Encoding>(_list0.size);
                        for (int _i1 = 0; _i1 < _list0.size; ++_i1) {
                            Encoding _elem2 = Encoding.findByValue(iprot.readI32());
                            this.encodings.add(_elem2);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 15) {
                        TList _list3 = iprot.readListBegin();
                        this.path_in_schema = new ArrayList<String>(_list3.size);
                        for (int _i4 = 0; _i4 < _list3.size; ++_i4) {
                            String _elem5 = iprot.readString();
                            this.path_in_schema.add(_elem5);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 8) {
                        this.codec = CompressionCodec.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 10) {
                        this.num_values = iprot.readI64();
                        this.setNum_valuesIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 6: {
                    if (field.type == 10) {
                        this.total_uncompressed_size = iprot.readI64();
                        this.setTotal_uncompressed_sizeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 7: {
                    if (field.type == 10) {
                        this.total_compressed_size = iprot.readI64();
                        this.setTotal_compressed_sizeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 8: {
                    if (field.type == 15) {
                        TList _list6 = iprot.readListBegin();
                        this.key_value_metadata = new ArrayList<KeyValue>(_list6.size);
                        for (int _i7 = 0; _i7 < _list6.size; ++_i7) {
                            KeyValue _elem8 = new KeyValue();
                            _elem8.read(iprot);
                            this.key_value_metadata.add(_elem8);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 9: {
                    if (field.type == 10) {
                        this.data_page_offset = iprot.readI64();
                        this.setData_page_offsetIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 10: {
                    if (field.type == 10) {
                        this.index_page_offset = iprot.readI64();
                        this.setIndex_page_offsetIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 11: {
                    if (field.type == 10) {
                        this.dictionary_page_offset = iprot.readI64();
                        this.setDictionary_page_offsetIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 12: {
                    if (field.type == 12) {
                        this.statistics = new Statistics();
                        this.statistics.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 13: {
                    if (field.type == 15) {
                        TList _list9 = iprot.readListBegin();
                        this.encoding_stats = new ArrayList<PageEncodingStats>(_list9.size);
                        for (int _i10 = 0; _i10 < _list9.size; ++_i10) {
                            PageEncodingStats _elem11 = new PageEncodingStats();
                            _elem11.read(iprot);
                            this.encoding_stats.add(_elem11);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        if (!this.isSetNum_values()) {
            throw new TProtocolException("Required field 'num_values' was not found in serialized data! Struct: " + this.toString());
        }
        if (!this.isSetTotal_uncompressed_size()) {
            throw new TProtocolException("Required field 'total_uncompressed_size' was not found in serialized data! Struct: " + this.toString());
        }
        if (!this.isSetTotal_compressed_size()) {
            throw new TProtocolException("Required field 'total_compressed_size' was not found in serialized data! Struct: " + this.toString());
        }
        if (!this.isSetData_page_offset()) {
            throw new TProtocolException("Required field 'data_page_offset' was not found in serialized data! Struct: " + this.toString());
        }
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.type != null) {
            oprot.writeFieldBegin(TYPE_FIELD_DESC);
            oprot.writeI32(this.type.getValue());
            oprot.writeFieldEnd();
        }
        if (this.encodings != null) {
            oprot.writeFieldBegin(ENCODINGS_FIELD_DESC);
            oprot.writeListBegin(new TList(8, this.encodings.size()));
            for (Encoding _iter12 : this.encodings) {
                oprot.writeI32(_iter12.getValue());
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.path_in_schema != null) {
            oprot.writeFieldBegin(PATH_IN_SCHEMA_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.path_in_schema.size()));
            for (String _iter13 : this.path_in_schema) {
                oprot.writeString(_iter13);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.codec != null) {
            oprot.writeFieldBegin(CODEC_FIELD_DESC);
            oprot.writeI32(this.codec.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(NUM_VALUES_FIELD_DESC);
        oprot.writeI64(this.num_values);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(TOTAL_UNCOMPRESSED_SIZE_FIELD_DESC);
        oprot.writeI64(this.total_uncompressed_size);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(TOTAL_COMPRESSED_SIZE_FIELD_DESC);
        oprot.writeI64(this.total_compressed_size);
        oprot.writeFieldEnd();
        if (this.key_value_metadata != null && this.isSetKey_value_metadata()) {
            oprot.writeFieldBegin(KEY_VALUE_METADATA_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.key_value_metadata.size()));
            for (KeyValue _iter14 : this.key_value_metadata) {
                _iter14.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(DATA_PAGE_OFFSET_FIELD_DESC);
        oprot.writeI64(this.data_page_offset);
        oprot.writeFieldEnd();
        if (this.isSetIndex_page_offset()) {
            oprot.writeFieldBegin(INDEX_PAGE_OFFSET_FIELD_DESC);
            oprot.writeI64(this.index_page_offset);
            oprot.writeFieldEnd();
        }
        if (this.isSetDictionary_page_offset()) {
            oprot.writeFieldBegin(DICTIONARY_PAGE_OFFSET_FIELD_DESC);
            oprot.writeI64(this.dictionary_page_offset);
            oprot.writeFieldEnd();
        }
        if (this.statistics != null && this.isSetStatistics()) {
            oprot.writeFieldBegin(STATISTICS_FIELD_DESC);
            this.statistics.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.encoding_stats != null && this.isSetEncoding_stats()) {
            oprot.writeFieldBegin(ENCODING_STATS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.encoding_stats.size()));
            for (PageEncodingStats _iter15 : this.encoding_stats) {
                _iter15.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnMetaData(");
        boolean first = true;
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append(this.type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("encodings:");
        if (this.encodings == null) {
            sb.append("null");
        } else {
            sb.append(this.encodings);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("path_in_schema:");
        if (this.path_in_schema == null) {
            sb.append("null");
        } else {
            sb.append(this.path_in_schema);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("codec:");
        if (this.codec == null) {
            sb.append("null");
        } else {
            sb.append(this.codec);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("num_values:");
        sb.append(this.num_values);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("total_uncompressed_size:");
        sb.append(this.total_uncompressed_size);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("total_compressed_size:");
        sb.append(this.total_compressed_size);
        first = false;
        if (this.isSetKey_value_metadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key_value_metadata:");
            if (this.key_value_metadata == null) {
                sb.append("null");
            } else {
                sb.append(this.key_value_metadata);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("data_page_offset:");
        sb.append(this.data_page_offset);
        first = false;
        if (this.isSetIndex_page_offset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("index_page_offset:");
            sb.append(this.index_page_offset);
            first = false;
        }
        if (this.isSetDictionary_page_offset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dictionary_page_offset:");
            sb.append(this.dictionary_page_offset);
            first = false;
        }
        if (this.isSetStatistics()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("statistics:");
            if (this.statistics == null) {
                sb.append("null");
            } else {
                sb.append(this.statistics);
            }
            first = false;
        }
        if (this.isSetEncoding_stats()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("encoding_stats:");
            if (this.encoding_stats == null) {
                sb.append("null");
            } else {
                sb.append(this.encoding_stats);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.type == null) {
            throw new TProtocolException("Required field 'type' was not present! Struct: " + this.toString());
        }
        if (this.encodings == null) {
            throw new TProtocolException("Required field 'encodings' was not present! Struct: " + this.toString());
        }
        if (this.path_in_schema == null) {
            throw new TProtocolException("Required field 'path_in_schema' was not present! Struct: " + this.toString());
        }
        if (this.codec == null) {
            throw new TProtocolException("Required field 'codec' was not present! Struct: " + this.toString());
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, new EnumMetaData(16, Type.class)));
        tmpMap.put(_Fields.ENCODINGS, new FieldMetaData("encodings", 1, new ListMetaData(15, new EnumMetaData(16, Encoding.class))));
        tmpMap.put(_Fields.PATH_IN_SCHEMA, new FieldMetaData("path_in_schema", 1, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.CODEC, new FieldMetaData("codec", 1, new EnumMetaData(16, CompressionCodec.class)));
        tmpMap.put(_Fields.NUM_VALUES, new FieldMetaData("num_values", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TOTAL_UNCOMPRESSED_SIZE, new FieldMetaData("total_uncompressed_size", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TOTAL_COMPRESSED_SIZE, new FieldMetaData("total_compressed_size", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.KEY_VALUE_METADATA, new FieldMetaData("key_value_metadata", 2, new ListMetaData(15, new StructMetaData(12, KeyValue.class))));
        tmpMap.put(_Fields.DATA_PAGE_OFFSET, new FieldMetaData("data_page_offset", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.INDEX_PAGE_OFFSET, new FieldMetaData("index_page_offset", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DICTIONARY_PAGE_OFFSET, new FieldMetaData("dictionary_page_offset", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.STATISTICS, new FieldMetaData("statistics", 2, new StructMetaData(12, Statistics.class)));
        tmpMap.put(_Fields.ENCODING_STATS, new FieldMetaData("encoding_stats", 2, new ListMetaData(15, new StructMetaData(12, PageEncodingStats.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ColumnMetaData.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TYPE(1, "type"),
        ENCODINGS(2, "encodings"),
        PATH_IN_SCHEMA(3, "path_in_schema"),
        CODEC(4, "codec"),
        NUM_VALUES(5, "num_values"),
        TOTAL_UNCOMPRESSED_SIZE(6, "total_uncompressed_size"),
        TOTAL_COMPRESSED_SIZE(7, "total_compressed_size"),
        KEY_VALUE_METADATA(8, "key_value_metadata"),
        DATA_PAGE_OFFSET(9, "data_page_offset"),
        INDEX_PAGE_OFFSET(10, "index_page_offset"),
        DICTIONARY_PAGE_OFFSET(11, "dictionary_page_offset"),
        STATISTICS(12, "statistics"),
        ENCODING_STATS(13, "encoding_stats");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return ENCODINGS;
                }
                case 3: {
                    return PATH_IN_SCHEMA;
                }
                case 4: {
                    return CODEC;
                }
                case 5: {
                    return NUM_VALUES;
                }
                case 6: {
                    return TOTAL_UNCOMPRESSED_SIZE;
                }
                case 7: {
                    return TOTAL_COMPRESSED_SIZE;
                }
                case 8: {
                    return KEY_VALUE_METADATA;
                }
                case 9: {
                    return DATA_PAGE_OFFSET;
                }
                case 10: {
                    return INDEX_PAGE_OFFSET;
                }
                case 11: {
                    return DICTIONARY_PAGE_OFFSET;
                }
                case 12: {
                    return STATISTICS;
                }
                case 13: {
                    return ENCODING_STATS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

