/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parquet.column.Encoding;

public class EncodingList
implements Iterable<Encoding> {
    private static Map<EncodingList, EncodingList> encodingLists = new HashMap<EncodingList, EncodingList>();
    private final List<Encoding> encodings;

    public static EncodingList getEncodingList(List<Encoding> encodings) {
        EncodingList key = new EncodingList(encodings);
        EncodingList cached = encodingLists.get(key);
        if (cached == null) {
            cached = key;
            encodingLists.put(key, cached);
        }
        return cached;
    }

    private EncodingList(List<Encoding> encodings) {
        this.encodings = Collections.unmodifiableList(encodings);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncodingList) {
            List<Encoding> other = ((EncodingList)obj).encodings;
            int size = other.size();
            if (size != this.encodings.size()) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                if (other.get(i).equals((Object)this.encodings.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (Encoding element : this.encodings) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public List<Encoding> toList() {
        return this.encodings;
    }

    @Override
    public Iterator<Encoding> iterator() {
        return this.encodings.iterator();
    }

    public int size() {
        return this.encodings.size();
    }
}

