/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import parquet.hadoop.api.WriteSupport;
import parquet.io.ParquetEncodingException;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.pig.PigMetaData;
import parquet.pig.PigSchemaConverter;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.Type;

public class TupleWriteSupport
extends WriteSupport<Tuple> {
    private static final TupleFactory TF = TupleFactory.getInstance();
    private static final PigSchemaConverter pigSchemaConverter = new PigSchemaConverter(false);
    private RecordConsumer recordConsumer;
    private MessageType rootSchema;
    private Schema rootPigSchema;

    public static TupleWriteSupport fromPigSchema(String pigSchemaString) throws ParserException {
        return new TupleWriteSupport(Utils.getSchemaFromString((String)pigSchemaString));
    }

    public TupleWriteSupport(Schema pigSchema) {
        this.rootSchema = pigSchemaConverter.convert(pigSchema);
        this.rootPigSchema = pigSchema;
    }

    public Schema getPigSchema() {
        return this.rootPigSchema;
    }

    public MessageType getParquetSchema() {
        return this.rootSchema;
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        new PigMetaData(this.rootPigSchema).addToMetaData(extraMetaData);
        return new WriteSupport.WriteContext(this.rootSchema, extraMetaData);
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    @Override
    public void write(Tuple t) {
        try {
            this.recordConsumer.startMessage();
            this.writeTuple(this.rootSchema, this.rootPigSchema, t);
            this.recordConsumer.endMessage();
        }
        catch (ExecException e) {
            throw new RuntimeException(e);
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTuple(GroupType schema, Schema pigSchema, Tuple t) throws ExecException, FrontendException {
        List<Type> fields = schema.getFields();
        List pigFields = pigSchema.getFields();
        assert (fields.size() == pigFields.size());
        for (int i = 0; i < fields.size(); ++i) {
            if (t.isNull(i)) continue;
            Type fieldType = fields.get(i);
            this.recordConsumer.startField(fieldType.getName(), i);
            Schema.FieldSchema pigType = (Schema.FieldSchema)pigFields.get(i);
            switch (pigType.type) {
                case 120: {
                    Type bagType = fieldType.asGroupType().getType(0);
                    Schema.FieldSchema pigBagInnerType = pigType.schema.getField(0);
                    DataBag bag = (DataBag)t.get(i);
                    this.recordConsumer.startGroup();
                    if (bag.size() > 0L) {
                        this.recordConsumer.startField(bagType.getName(), 0);
                        for (Tuple tuple : bag) {
                            if (bagType.isPrimitive()) {
                                this.writeValue(bagType, pigBagInnerType, tuple, 0);
                                continue;
                            }
                            this.recordConsumer.startGroup();
                            this.writeTuple(bagType.asGroupType(), pigBagInnerType.schema, tuple);
                            this.recordConsumer.endGroup();
                        }
                        this.recordConsumer.endField(bagType.getName(), 0);
                    }
                    this.recordConsumer.endGroup();
                    break;
                }
                case 100: {
                    Type mapType = fieldType.asGroupType().getType(0);
                    Schema.FieldSchema pigMapInnerType = pigType.schema.getField(0);
                    Map map = (Map)t.get(i);
                    this.recordConsumer.startGroup();
                    if (map.size() > 0) {
                        this.recordConsumer.startField(mapType.getName(), 0);
                        Set entrySet = map.entrySet();
                        for (Map.Entry entry : entrySet) {
                            this.recordConsumer.startGroup();
                            Schema keyValueSchema = new Schema(Arrays.asList(new Schema.FieldSchema("key", 55), new Schema.FieldSchema("value", pigMapInnerType.schema, pigMapInnerType.type)));
                            this.writeTuple(mapType.asGroupType(), keyValueSchema, TF.newTuple(Arrays.asList(entry.getKey(), entry.getValue())));
                            this.recordConsumer.endGroup();
                        }
                        this.recordConsumer.endField(mapType.getName(), 0);
                    }
                    this.recordConsumer.endGroup();
                    break;
                }
                default: {
                    this.writeValue(fieldType, pigType, t, i);
                }
            }
            this.recordConsumer.endField(fieldType.getName(), i);
        }
    }

    private void writeValue(Type type, Schema.FieldSchema pigType, Tuple t, int i) {
        try {
            if (type.isPrimitive()) {
                switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                    case BINARY: {
                        byte[] bytes;
                        if (pigType.type == 50) {
                            bytes = ((DataByteArray)t.get(i)).get();
                        } else if (pigType.type == 55) {
                            bytes = ((String)t.get(i)).getBytes("UTF-8");
                        } else {
                            throw new UnsupportedOperationException("can not convert from " + DataType.findTypeName((byte)pigType.type) + " to BINARY ");
                        }
                        this.recordConsumer.addBinary(Binary.fromByteArray(bytes));
                        break;
                    }
                    case BOOLEAN: {
                        this.recordConsumer.addBoolean((Boolean)t.get(i));
                        break;
                    }
                    case INT32: {
                        this.recordConsumer.addInteger(((Number)t.get(i)).intValue());
                        break;
                    }
                    case INT64: {
                        this.recordConsumer.addLong(((Number)t.get(i)).longValue());
                        break;
                    }
                    case DOUBLE: {
                        this.recordConsumer.addDouble(((Number)t.get(i)).doubleValue());
                        break;
                    }
                    case FLOAT: {
                        this.recordConsumer.addFloat(((Number)t.get(i)).floatValue());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(type.asPrimitiveType().getPrimitiveTypeName().name());
                    }
                }
            } else {
                assert (pigType.type == 110);
                this.recordConsumer.startGroup();
                this.writeTuple(type.asGroupType(), pigType.schema, (Tuple)t.get(i));
                this.recordConsumer.endGroup();
            }
        }
        catch (Exception e) {
            throw new ParquetEncodingException("can not write value at " + i + " in tuple " + t + " from type '" + pigType + "' to type '" + type + "'", e);
        }
    }
}

