/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.commons.tap;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import com.twitter.scalding.commons.datastores.VersionedStore;
import com.twitter.scalding.tap.GlobHfs;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class VersionedTap
extends GlobHfs {
    public Long version = null;
    private int versionsToKeep = 3;
    public TapMode mode;
    private String newVersionPath;

    public VersionedTap(String string, Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme, TapMode tapMode) throws IOException {
        super(scheme, string);
        this.mode = tapMode;
    }

    public VersionedTap setVersion(long l) {
        this.version = l;
        return this;
    }

    public VersionedTap setVersionsToKeep(int n) {
        this.versionsToKeep = n;
        return this;
    }

    public int getVersionsToKeep() {
        return this.versionsToKeep;
    }

    public String getOutputDirectory() {
        return this.getPath().toString();
    }

    public VersionedStore getStore(JobConf jobConf) throws IOException {
        return new VersionedStore(this.getPath().getFileSystem((Configuration)jobConf), this.getOutputDirectory());
    }

    public String getSourcePath(JobConf jobConf) {
        try {
            String string;
            VersionedStore versionedStore = this.getStore(jobConf);
            String string2 = string = this.version != null ? versionedStore.versionPath(this.version) : versionedStore.mostRecentVersionPath();
            if (string == null) {
                throw new RuntimeException("Could not find valid source path for VersionTap with root: " + versionedStore.getRoot());
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getSinkPath(JobConf jobConf) {
        try {
            String string;
            VersionedStore versionedStore = this.getStore(jobConf);
            String string2 = string = this.version == null ? versionedStore.createVersion() : versionedStore.createVersion(this.version);
            if (string == null) {
                throw new RuntimeException("Could not find valid sink path for VersionTap with root: " + versionedStore.getRoot());
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void sourceConfInit(FlowProcess<JobConf> flowProcess, JobConf jobConf) {
        super.sourceConfInit(flowProcess, jobConf);
        FileInputFormat.setInputPaths((JobConf)jobConf, (String)this.getSourcePath(jobConf));
    }

    public void sinkConfInit(FlowProcess<JobConf> flowProcess, JobConf jobConf) {
        super.sinkConfInit(flowProcess, jobConf);
        if (this.newVersionPath == null) {
            this.newVersionPath = this.getSinkPath(jobConf);
        }
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(this.newVersionPath));
    }

    public long getSize(JobConf jobConf) throws IOException {
        return VersionedTap.getSize((Path)new Path(this.getSourcePath(jobConf)), (JobConf)jobConf);
    }

    public boolean resourceExists(JobConf jobConf) throws IOException {
        return this.getStore(jobConf).mostRecentVersion() != null;
    }

    public boolean createResource(JobConf jobConf) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean deleteResource(JobConf jobConf) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIdentifier() {
        String string = this.getOutputDirectory();
        String string2 = this.version == null ? "LATEST" : this.version.toString();
        return string + "/" + (this.mode == TapMode.SINK ? "sink" : "source") + "/" + string2;
    }

    public long getModifiedTime(JobConf jobConf) throws IOException {
        VersionedStore versionedStore = this.getStore(jobConf);
        return this.mode == TapMode.SINK ? 0L : versionedStore.mostRecentVersion();
    }

    public boolean commitResource(JobConf jobConf) throws IOException {
        VersionedStore versionedStore = this.getStore(jobConf);
        if (this.newVersionPath != null) {
            versionedStore.succeedVersion(this.newVersionPath);
            VersionedTap.markSuccessfulOutputDir(new Path(this.newVersionPath), jobConf);
            this.newVersionPath = null;
            versionedStore.cleanup(this.getVersionsToKeep());
        }
        return true;
    }

    private static void markSuccessfulOutputDir(Path path, JobConf jobConf) throws IOException {
        FileSystem fileSystem = path.getFileSystem((Configuration)jobConf);
        if (fileSystem.exists(path)) {
            Path path2 = new Path(path, "_SUCCESS");
            fileSystem.create(path2).close();
        }
    }

    public boolean rollbackResource(JobConf jobConf) throws IOException {
        if (this.newVersionPath != null) {
            this.getStore(jobConf).failVersion(this.newVersionPath);
            this.newVersionPath = null;
        }
        return true;
    }

    public static enum TapMode {
        SOURCE,
        SINK;

    }
}

