/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scrooge;

import com.twitter.scrooge.Compiler;
import com.twitter.scrooge.Main$;
import com.twitter.scrooge.backend.GeneratorFactory$;
import com.twitter.scrooge.backend.WithFinagle$;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class Main$ {
    public static final Main$ MODULE$;

    static {
        new Main$();
    }

    public void main(String[] args) {
        Compiler compiler = new Compiler();
        if (!this.parseOptions(compiler, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            System.exit(1);
        }
        compiler.run();
    }

    public boolean parseOptions(Compiler compiler, Seq<String> args) {
        Properties buildProperties = new Properties();
        Option$.MODULE$.apply((Object)this.getClass().getResource("build.properties")).foreach((Function1)new Serializable(buildProperties){
            public static final long serialVersionUID = 0L;
            private final Properties buildProperties$1;

            public final void apply(URL resource) {
                this.buildProperties$1.load(resource.openStream());
            }
            {
                this.buildProperties$1 = buildProperties$1;
            }
        });
        OptionParser<Compiler> parser = new OptionParser<Compiler>(compiler, buildProperties){

            public Option<Object> showUsageOnError() {
                return new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            {
                this.help("help").text("show this help screen");
                this.opt('V', "version", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this, buildProperties$1){
                    public static final long serialVersionUID = 0L;
                    private final Properties buildProperties$1;

                    public final Compiler apply(BoxedUnit x$1, Compiler c) {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"scrooge ").append((Object)this.buildProperties$1.getProperty("version", "0.0")).toString());
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"    build ").append((Object)this.buildProperties$1.getProperty("build_name", "unknown")).toString());
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"    git revision ").append((Object)this.buildProperties$1.getProperty("build_revision", "unknown")).toString());
                        System.exit(0);
                        return c;
                    }
                    {
                        this.buildProperties$1 = buildProperties$1;
                    }
                }).text("print version and quit");
                this.opt('v', "verbose", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(BoxedUnit x$2, Compiler c) {
                        c.verbose_$eq(true);
                        return c;
                    }
                }).text("log verbose messages about progress");
                this.opt('d', "dest", Read$.MODULE$.stringRead()).valueName("<path>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(String d, Compiler c) {
                        c.destFolder_$eq(d);
                        return c;
                    }
                }).text(new StringOps(Predef$.MODULE$.augmentString("write generated code to a folder (default: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compiler$1.defaultDestFolder()})));
                this.opt("import-path", Read$.MODULE$.stringRead()).unbounded().valueName("<path>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(String path, Compiler c) {
                        c.includePaths().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])path.split(File.pathSeparator)));
                        return c;
                    }
                }).text("[DEPRECATED] path(s) to search for included thrift files (may be used multiple times)");
                this.opt('i', "include-path", Read$.MODULE$.stringRead()).unbounded().valueName("<path>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(String path, Compiler c) {
                        c.includePaths().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])path.split(File.pathSeparator)));
                        return c;
                    }
                }).text("path(s) to search for included thrift files (may be used multiple times)");
                this.opt('n', "namespace-map", Read$.MODULE$.stringRead()).unbounded().valueName("<oldname>=<newname>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(String mapping, Compiler c) {
                        String[] stringArray = mapping.split("=");
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                            String from = (String)((SeqLike)option.get()).apply(0);
                            String to = (String)((SeqLike)option.get()).apply(1);
                            c.namespaceMappings().update((Object)from, (Object)to);
                            Compiler compiler = c;
                            return compiler;
                        }
                        throw new MatchError((Object)stringArray);
                    }
                }).text("map old namespace to new (may be used multiple times)");
                this.opt("default-java-namespace", Read$.MODULE$.stringRead()).unbounded().valueName("<name>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(String name, Compiler c) {
                        c.defaultNamespace_$eq(name);
                        return c;
                    }
                }).text("Use <name> as default namespace if the thrift file doesn't define its own namespace. If this option is not specified either, then use \"thrift\" as default namespace");
                this.opt("disable-strict", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(BoxedUnit x$3, Compiler c) {
                        c.strict_$eq(false);
                        return c;
                    }
                }).text("issue warnings on non-severe parse errors instead of aborting");
                this.opt("gen-file-map", Read$.MODULE$.stringRead()).valueName("<path>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(String path, Compiler c) {
                        c.fileMapPath_$eq((Option<String>)new Some((Object)path));
                        return c;
                    }
                }).text("generate map.txt in the destination folder to specify the mapping from input thrift files to output Scala/Java files");
                this.opt("dry-run", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(BoxedUnit x$4, Compiler c) {
                        c.dryRun_$eq(true);
                        return c;
                    }
                }).text("parses and validates source thrift files, reporting any errors, but does not emit any generated source code.  can be used with --gen-file-mapping to get the file mapping");
                this.opt('s', "skip-unchanged", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(BoxedUnit x$5, Compiler c) {
                        c.skipUnchanged_$eq(true);
                        return c;
                    }
                }).text("Don't re-generate if the target is newer than the input");
                this.opt('l', "language", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this, compiler$1){
                    public static final long serialVersionUID = 0L;
                    private final Compiler compiler$1;

                    public final Compiler apply(String languageString, Compiler c) {
                        this.compiler$1.language_$eq(languageString);
                        return c;
                    }
                    {
                        this.compiler$1 = compiler$1;
                    }
                }).validate((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(String language) {
                        return GeneratorFactory$.MODULE$.languages().toList().contains((Object)language.toLowerCase()) ? this.$outer.success() : this.$outer.failure(new StringOps(Predef$.MODULE$.augmentString("language option %s not supported")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{language})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).text(new StringBuilder().append((Object)"name of language to generate code in (currently supported languages: ").append((Object)GeneratorFactory$.MODULE$.languages().toList().mkString(", ")).append((Object)")").toString());
                this.opt("java-ser-enum-type", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this, compiler$1){
                    public static final long serialVersionUID = 0L;
                    private final Compiler compiler$1;

                    public final Compiler apply(BoxedUnit x$6, Compiler c) {
                        this.compiler$1.javaSerEnumType_$eq(true);
                        return c;
                    }
                    {
                        this.compiler$1 = compiler$1;
                    }
                }).text("Encode a thrift enum as o.a.t.p.TType.ENUM instead of TType.I32");
                this.opt("experiment-flag", Read$.MODULE$.stringRead()).valueName("<flag>").unbounded().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(String flag, Compiler c) {
                        c.experimentFlags().$plus$eq((Object)flag);
                        return c;
                    }
                }).text("[EXPERIMENTAL] DO NOT USE FOR PRODUCTION. This is meant only for enabling/disabling features for benchmarking");
                this.opt("scala-warn-on-java-ns-fallback", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(BoxedUnit x$7, Compiler c) {
                        c.scalaWarnOnJavaNSFallback_$eq(true);
                        return c;
                    }
                }).text("Print a warning when the scala generator falls back to the java namespace");
                this.opt("finagle", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(BoxedUnit x$8, Compiler c) {
                        c.flags().$plus$eq((Object)WithFinagle$.MODULE$);
                        return c;
                    }
                }).text("generate finagle classes");
                this.opt("gen-adapt", Read$.MODULE$.unitRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(BoxedUnit x$9, Compiler c) {
                        c.genAdapt_$eq(true);
                        return c;
                    }
                }).text("Generate code for adaptive decoding for scala.");
                this.arg("<files...>", Read$.MODULE$.stringRead()).unbounded().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Compiler apply(String files, Compiler c) {
                        c.thriftFiles().$plus$eq((Object)files);
                        return c;
                    }
                }).text("thrift files to compile");
            }
        };
        Option parsed = parser.parse(args, (Object)compiler);
        return parsed.isDefined();
    }

    public boolean isUnchanged(File file, long sourceLastModified) {
        return file.exists() && file.lastModified() >= sourceLastModified;
    }

    private Main$() {
        MODULE$ = this;
    }
}

