/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scrooge.backend;

import com.twitter.scrooge.thrift_validation.DefaultAnnotations;
import com.twitter.scrooge.thrift_validation.DefaultAnnotations$;
import java.util.logging.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AnnotationValidator$ {
    public static final AnnotationValidator$ MODULE$;
    private final Logger logger;
    private final scala.collection.immutable.Set<String> defaultAnnotationKeys;

    static {
        new AnnotationValidator$();
    }

    private Logger logger() {
        return this.logger;
    }

    private scala.collection.immutable.Set<String> defaultAnnotationKeys() {
        return this.defaultAnnotationKeys;
    }

    public boolean isDefaultAnnotation(String annotationKey) {
        return this.defaultAnnotationKeys().contains((Object)annotationKey);
    }

    public Iterable<String> validateAnnotations(scala.collection.immutable.Set<Class<?>> fieldClazz, Map<String, String> fieldAnnotations) {
        return (Iterable)fieldAnnotations.flatMap((Function1)new Serializable(fieldClazz, fieldAnnotations){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set fieldClazz$1;
            private final Map fieldAnnotations$1;

            public final scala.collection.immutable.Set<String> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    scala.collection.immutable.Set<String> set = AnnotationValidator$.MODULE$.com$twitter$scrooge$backend$AnnotationValidator$$validateAnnotation(key, (String)this.fieldAnnotations$1.apply((Object)key), this.fieldClazz$1);
                    return set;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fieldClazz$1 = fieldClazz$1;
                this.fieldAnnotations$1 = fieldAnnotations$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public scala.collection.immutable.Set<String> com$twitter$scrooge$backend$AnnotationValidator$$validateAnnotation(String annotationKey, String annotationValue, scala.collection.immutable.Set<Class<?>> fieldClazz) {
        scala.collection.immutable.Set set;
        if (this.isDefaultAnnotation(annotationKey)) {
            set = this.validateDefaultAnnotation(annotationKey, annotationValue, fieldClazz);
        } else {
            if (annotationKey.startsWith("validation.")) {
                this.logger().warning(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Annotation validation key: ", " is not supported "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{annotationKey}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and it was not validated. Only the built-in scrooge annotations "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"are supported for validation. The annotation value was ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{annotationValue}))).toString());
            }
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private scala.collection.immutable.Set<String> validateDefaultAnnotation(String annotationKey, String annotationValue, scala.collection.immutable.Set<Class<?>> fieldClazz) {
        BoxedUnit boxedUnit;
        Set result;
        scala.collection.immutable.Set allowedClazz;
        block7: {
            Object object;
            Option option = DefaultAnnotations$.MODULE$.metadata().get((Object)annotationKey);
            if (!(option instanceof Some)) return Predef$.MODULE$.Set().empty();
            Some some = (Some)option;
            DefaultAnnotations.AnnotationMetaData annotationMetaData = (DefaultAnnotations.AnnotationMetaData)some.x();
            if (annotationMetaData == null) return Predef$.MODULE$.Set().empty();
            Option annotationClazz = annotationMetaData.annotationClazz();
            allowedClazz = annotationMetaData.fieldClazz();
            result = Set$.MODULE$.empty();
            if (annotationClazz.nonEmpty()) {
                Class clazz = (Class)annotationClazz.get();
                try {
                    Class clazz2 = clazz;
                    Class<Integer> clazz3 = Integer.class;
                    Object object2 = !(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null) ? BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(annotationValue)).toInt()) : BoxedUnit.UNIT;
                    Class clazz4 = clazz;
                    Class<Long> clazz5 = Long.class;
                    if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                        object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(annotationValue)).toLong());
                        break block7;
                    }
                    object = BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    String errorMessage = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The annotation ", " requires a value of type ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{annotationKey, clazz.getSimpleName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the annotation value ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.truncate(annotationValue)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getSimpleName()}))).toString();
                    object = result.$plus$eq((Object)errorMessage);
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        }
        if (fieldClazz.nonEmpty() && ((SetLike)allowedClazz.intersect(fieldClazz)).isEmpty()) {
            String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The annotation ", " can not be applied to the field with type ", ", the allowed Classes are: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{annotationKey, ((TraversableOnce)fieldClazz.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Class<?> x$1) {
                    return x$1.getSimpleName();
                }
            }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).mkString(", "), ((TraversableOnce)allowedClazz.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Class<?> x$2) {
                    return x$2.getSimpleName();
                }
            }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).mkString(", ")}));
            boxedUnit = result.$plus$eq((Object)errorMessage);
            return result.toSet();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return result.toSet();
    }

    private String truncate(String annotationValue) {
        return annotationValue.length() > 21 ? new StringBuilder().append((Object)annotationValue.substring(0, 21)).append((Object)"...").toString() : annotationValue;
    }

    private AnnotationValidator$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.defaultAnnotationKeys = DefaultAnnotations$.MODULE$.metadata().keySet();
    }
}

