/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scrooge;

import com.twitter.scrooge.ScroogeConfig;
import com.twitter.scrooge.ast.Document;
import com.twitter.scrooge.ast.Identifier;
import com.twitter.scrooge.backend.Generator;
import com.twitter.scrooge.backend.GeneratorFactory$;
import com.twitter.scrooge.backend.ScalaGenerator;
import com.twitter.scrooge.frontend.FileParseException;
import com.twitter.scrooge.frontend.Importer;
import com.twitter.scrooge.frontend.Importer$;
import com.twitter.scrooge.frontend.NullImporter$;
import com.twitter.scrooge.frontend.ResolvedDocument;
import com.twitter.scrooge.frontend.ThriftParser;
import com.twitter.scrooge.frontend.ThriftParser$;
import com.twitter.scrooge.frontend.TypeResolver;
import com.twitter.scrooge.frontend.TypeResolver$;
import com.twitter.scrooge.java_generator.ApacheJavaGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.logging.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005e2A\u0001C\u0005\u0001!!Aq\u0003\u0001BC\u0002\u0013\u0005\u0001\u0004\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001a\u0011\u0015q\u0002\u0001\"\u0001 \u0011\u001d\u0011\u0003\u00011A\u0005\u0002\rBqa\f\u0001A\u0002\u0013\u0005\u0001\u0007\u0003\u00047\u0001\u0001\u0006K\u0001\n\u0005\u0006o\u0001!\t\u0001\u000f\u0002\t\u0007>l\u0007/\u001b7fe*\u0011!bC\u0001\bg\u000e\u0014xn\\4f\u0015\taQ\"A\u0004uo&$H/\u001a:\u000b\u00039\t1aY8n\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019wN\u001c4jOV\t\u0011\u0004\u0005\u0002\u001b75\t\u0011\"\u0003\u0002\u001d\u0013\ti1k\u0019:p_\u001e,7i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003A\u0005\u0002\"A\u0007\u0001\t\u000b]\u0019\u0001\u0019A\r\u0002\u001b\u0019LG.Z'ba^\u0013\u0018\u000e^3s+\u0005!\u0003c\u0001\n&O%\u0011ae\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013AA5p\u0015\u0005a\u0013\u0001\u00026bm\u0006L!AL\u0015\u0003\u0015\u0019KG.Z,sSR,'/A\tgS2,W*\u00199Xe&$XM]0%KF$\"!\r\u001b\u0011\u0005I\u0011\u0014BA\u001a\u0014\u0005\u0011)f.\u001b;\t\u000fU*\u0011\u0011!a\u0001I\u0005\u0019\u0001\u0010J\u0019\u0002\u001d\u0019LG.Z'ba^\u0013\u0018\u000e^3sA\u0005\u0019!/\u001e8\u0015\u0003E\u0002")
public class Compiler {
    private final ScroogeConfig config;
    private Option<FileWriter> fileMapWriter;

    public ScroogeConfig config() {
        return this.config;
    }

    public Option<FileWriter> fileMapWriter() {
        return this.fileMapWriter;
    }

    public void fileMapWriter_$eq(Option<FileWriter> x$1) {
        this.fileMapWriter = x$1;
    }

    public void run() {
        NullImporter$ rootImporter;
        this.fileMapWriter_$eq((Option<FileWriter>)this.config().fileMapPath().map((Function1 & Serializable)path -> {
            File file = new File((String)path);
            File dir = file.getParentFile();
            Object object = dir != null && !dir.exists() ? BoxesRunTime.boxToBoolean((boolean)dir.mkdirs()) : BoxedUnit.UNIT;
            if (this.config().verbose()) {
                Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("+ Writing file mapping to %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{path})));
            }
            return new FileWriter(file);
        }));
        NullImporter$ nullImporter$ = rootImporter = this.config().addRootDirImporter() ? Importer$.MODULE$.apply(new File(".")) : NullImporter$.MODULE$;
        Importer importer = Importer$.MODULE$.apply((Seq<String>)this.config().includePaths().toSeq()).$plus$colon(nullImporter$);
        boolean isJava = this.config().language().equals("java");
        TrieMap documentCache = new TrieMap();
        this.config().thriftFiles().foreach((Function1 & Serializable)inputFile -> {
            Compiler.$anonfun$run$2(this, importer, isJava, documentCache, inputFile);
            return BoxedUnit.UNIT;
        });
        this.fileMapWriter().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$run$2(Compiler $this, Importer importer$1, boolean isJava$1, TrieMap documentCache$1, String inputFile) {
        try {
            Importer x$12 = importer$1;
            boolean x$2 = $this.config().strict();
            boolean x$3 = isJava$1;
            boolean x$4 = false;
            TrieMap x$5 = documentCache$1;
            Logger x$6 = ThriftParser$.MODULE$.$lessinit$greater$default$6(x$12, x$2, x$3, false, (Map<String, Document>)x$5);
            ThriftParser parser = new ThriftParser(x$12, x$2, x$3, false, (Map<String, Document>)x$5, x$6);
            Document doc = parser.parseFile(inputFile).mapNamespaces($this.config().namespaceMappings());
            if ($this.config().verbose()) {
                Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("+ Compiling %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{inputFile})));
            }
            TypeResolver qual$1 = new TypeResolver(TypeResolver$.MODULE$.apply$default$1(), TypeResolver$.MODULE$.apply$default$2(), TypeResolver$.MODULE$.apply$default$3(), TypeResolver$.MODULE$.apply$default$4());
            Document x$7 = doc;
            Option<Identifier> x$8 = qual$1.apply$default$2();
            ResolvedDocument resolvedDoc = qual$1.apply(x$7, x$8);
            Generator generator = GeneratorFactory$.MODULE$.apply($this.config().language(), resolvedDoc, $this.config().defaultNamespace(), $this.config().languageFlags());
            Generator generator2 = generator;
            if (generator2 instanceof ScalaGenerator) {
                ScalaGenerator scalaGenerator = (ScalaGenerator)generator2;
                scalaGenerator.warnOnJavaNamespaceFallback_$eq($this.config().scalaWarnOnJavaNSFallback());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (generator2 instanceof ApacheJavaGenerator) {
                ApacheJavaGenerator apacheJavaGenerator = (ApacheJavaGenerator)generator2;
                apacheJavaGenerator.serEnumType_$eq($this.config().javaSerEnumType());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Iterable generatedFiles = (Iterable)generator.apply($this.config().flags(), new File($this.config().destFolder()), $this.config().dryRun(), $this.config().genAdapt()).map((Function1 & Serializable)x$1 -> x$1.getPath());
            if ($this.config().verbose()) {
                Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("+ Generated %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{generatedFiles.mkString(", ")})));
            }
            $this.fileMapWriter().foreach((Function1 & Serializable)w -> {
                generatedFiles.foreach((Function1 & Serializable)path -> {
                    w.write(new StringBuilder(5).append(inputFile$1).append(" -> ").append(path).append("\n").toString());
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable e) {
            throw new FileParseException(inputFile, e);
        }
    }

    public Compiler(ScroogeConfig config) {
        this.config = config;
        this.fileMapWriter = None$.MODULE$;
    }
}

