/*
 * Decompiled with CFR 0.152.
 */
package com.twitter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.twitter.MavenScroogeCompilerUtil;
import com.twitter.ScroogeRunner;
import com.twitter.ThriftNamespaceMapping;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;

abstract class AbstractMavenScroogeMojo
extends AbstractMojo {
    private static final String THRIFT_FILE_SUFFIX = ".thrift";
    private static final String DEFAULT_INCLUDES = "**/*.thrift";
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    private Set<File> thriftIncludes = new HashSet<File>();
    private String language;
    private Set<String> thriftOpts = new HashSet<String>();
    private Set<String> dependencyIncludes = new HashSet<String>();
    private Set<ThriftNamespaceMapping> thriftNamespaceMappings = new HashSet<ThriftNamespaceMapping>();
    private Set<String> includes = ImmutableSet.of((Object)"**/*.thrift");
    private Set<String> excludes = ImmutableSet.of();
    private boolean buildExtractedThrift = true;
    private boolean includeOutputDirectoryNamespace = true;
    private boolean fixHashcode = false;
    private boolean checkStaleness = true;
    private long staleMillis = 0L;
    private static Object lock = new Object();
    @Component
    protected ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List remoteArtifactRepositories;
    @Parameter(property="maven.scrooge.classifier", defaultValue="idl")
    protected String classifier;

    AbstractMavenScroogeMojo() {
    }

    private File extractThriftFile(String artifactId, String fileName, Set<File> thriftFiles) {
        for (File thriftFile : thriftFiles) {
            boolean fileFound = false;
            if (fileName.equals(thriftFile.getName())) {
                for (String pathComponent : thriftFile.getPath().split(File.separator)) {
                    if (!pathComponent.equals(artifactId)) continue;
                    fileFound = true;
                }
            }
            if (!fileFound) continue;
            return thriftFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block9: {
            try {
                Set<File> thriftFiles = this.findThriftFiles();
                File outputDirectory = this.getOutputDirectory();
                ImmutableSet<File> outputFiles = this.findGeneratedFilesInDirectory(this.getOutputDirectory());
                HashSet<String> compileRoots = new HashSet<String>();
                compileRoots.add("scrooge");
                if (thriftFiles.isEmpty()) {
                    this.getLog().info((CharSequence)"No thrift files to compile.");
                    break block9;
                }
                if (this.checkStaleness && this.lastModified(thriftFiles) + this.staleMillis < this.lastModified((Set<File>)outputFiles)) {
                    this.getLog().info((CharSequence)"Generated thrift files up to date, skipping compile.");
                    this.attachFiles(compileRoots);
                    break block9;
                }
                outputDirectory.mkdirs();
                FileUtils.cleanDirectory((File)outputDirectory);
                this.getLog().info((CharSequence)String.format("compiling thrift files %s with Scrooge", thriftFiles));
                Object object = lock;
                synchronized (object) {
                    ScroogeRunner runner = new ScroogeRunner();
                    HashMap<String, String> thriftNamespaceMap = new HashMap<String, String>();
                    for (ThriftNamespaceMapping mapping : this.thriftNamespaceMappings) {
                        thriftNamespaceMap.put(mapping.getFrom(), mapping.getTo());
                    }
                    Set<File> includes = this.thriftIncludes;
                    includes.add(this.getResourcesOutputDirectory());
                    File thriftSourceRoot = this.getThriftSourceRoot();
                    if (thriftSourceRoot != null && thriftSourceRoot.exists()) {
                        includes.add(thriftSourceRoot);
                    }
                    runner.compile(this.includeOutputDirectoryNamespace ? new File(outputDirectory, "scrooge") : outputDirectory, thriftFiles, includes, thriftNamespaceMap, this.language, this.thriftOpts);
                }
                this.attachFiles(compileRoots);
            }
            catch (IOException e) {
                throw new MojoExecutionException("An IO error occurred", (Exception)e);
            }
        }
    }

    protected abstract File getThriftSourceRoot();

    protected abstract File getOutputDirectory();

    protected abstract File getResourcesOutputDirectory();

    protected abstract void attachFiles(Set<String> var1);

    protected abstract String getDependencyScopeFilter();

    protected abstract List<File> getReferencedThriftFiles() throws IOException;

    private long lastModified(Set<File> files) {
        long result = 0L;
        for (File file : files) {
            if (file.lastModified() <= result) continue;
            result = file.lastModified();
        }
        return result;
    }

    private Set<File> findThriftFiles() throws IOException, MojoExecutionException {
        File thriftSourceRoot = this.getThriftSourceRoot();
        HashSet<File> thriftFiles = new HashSet<File>();
        if (thriftSourceRoot != null && thriftSourceRoot.exists()) {
            thriftFiles.addAll((Collection<File>)this.findThriftFilesInDirectory(thriftSourceRoot));
        }
        this.getLog().info((CharSequence)"finding thrift files in dependencies");
        this.extractFilesFromDependencies(this.findThriftDependencies(), this.getResourcesOutputDirectory());
        if (this.buildExtractedThrift && this.getResourcesOutputDirectory().exists()) {
            thriftFiles.addAll((Collection<File>)this.findThriftFilesInDirectory(this.getResourcesOutputDirectory()));
        }
        this.getLog().info((CharSequence)"finding thrift files in referenced (reactor) projects");
        thriftFiles.addAll(this.getReferencedThriftFiles());
        return thriftFiles;
    }

    private Set<Artifact> findThriftDependencies() throws IOException, MojoExecutionException {
        HashSet<Artifact> thriftDependencies = new HashSet<Artifact>();
        HashSet deps = new HashSet();
        deps.addAll(this.project.getArtifacts());
        deps.addAll(this.project.getDependencyArtifacts());
        HashMap<String, Artifact> depsMap = new HashMap<String, Artifact>();
        for (Artifact dep : deps) {
            depsMap.put(dep.getId(), dep);
        }
        for (Artifact artifact : deps) {
            if (this.isIdlCalssifier(artifact, this.classifier)) {
                thriftDependencies.add(artifact);
                continue;
            }
            if (!this.isDepOfIdlArtifact(artifact, depsMap)) continue;
            try {
                Artifact idlArtifact = MavenScroogeCompilerUtil.getIdlArtifact(artifact, this.artifactFactory, this.artifactResolver, this.localRepository, this.remoteArtifactRepositories, this.classifier);
                thriftDependencies.add(idlArtifact);
            }
            catch (MojoExecutionException e) {
                this.getLog().debug((CharSequence)("Could not fetch idl jar for " + artifact));
            }
        }
        return thriftDependencies;
    }

    private void extractFilesFromDependencies(Collection<Artifact> dependencies, File destFolder) throws IOException, MojoExecutionException {
        for (Artifact idlArtifact : dependencies) {
            if (!idlArtifact.isResolved()) {
                throw new MojoExecutionException(String.format("Could not resolve idl thrift dependency %s", idlArtifact));
            }
            File dep = idlArtifact.getFile();
            if (dep.isFile() && dep.canRead()) {
                this.getLog().info((CharSequence)("Extracting thrift files from " + dep.getCanonicalPath()));
                JarFile jar = new JarFile(dep);
                for (JarEntry entry : Collections.list(jar.entries())) {
                    if (!entry.getName().endsWith(THRIFT_FILE_SUFFIX)) continue;
                    File destination = new File(destFolder, entry.getName());
                    if (destination.isFile() && dep.lastModified() <= destination.lastModified()) {
                        if (!this.haveSameContents(destination, jar, entry)) {
                            throw new IOException(String.format("extracting %s from %s would overwrite %s", entry.getName(), dep.getCanonicalPath(), destination.getCanonicalPath()));
                        }
                        this.getLog().info((CharSequence)String.format("skipping extraction of %s from %s", entry.getName(), dep.getCanonicalPath()));
                        continue;
                    }
                    if (destination.isFile()) {
                        this.getLog().warn((CharSequence)String.format("overwriting %s with %s", entry.getName(), destination.getCanonicalPath()));
                    } else {
                        this.getLog().info((CharSequence)String.format("extracting %s to %s", entry.getName(), destination.getCanonicalPath()));
                    }
                    FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(jar.getInputStream(entry)), (File)destination);
                    if (destination.setLastModified(dep.lastModified())) continue;
                    this.getLog().warn((CharSequence)String.format("fail to set last modified time for %s", destination.getCanonicalPath()));
                }
                continue;
            }
            this.getLog().warn((CharSequence)String.format("dep %s isn't a file or can't be read", dep.getCanonicalPath()));
        }
    }

    private boolean haveSameContents(File file, final JarFile jar, final JarEntry entry) throws IOException {
        HashFunction hashFun = Hashing.md5();
        HashCode fileHash = Files.hash((File)file, (HashFunction)hashFun);
        HashCode streamHash = ByteStreams.hash((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return jar.getInputStream(entry);
            }
        }, (HashFunction)hashFun);
        return fileHash.equals((Object)streamHash);
    }

    private ImmutableSet<File> findGeneratedFilesInDirectory(File directory) throws IOException {
        if (directory == null || !directory.isDirectory()) {
            return ImmutableSet.of();
        }
        List sourceFilesInDirectory = FileUtils.getFiles((File)directory, (String)"**/*.java", null);
        sourceFilesInDirectory.addAll(FileUtils.getFiles((File)directory, (String)"**/*.scala", null));
        return ImmutableSet.copyOf((Collection)sourceFilesInDirectory);
    }

    private ImmutableSet<File> findThriftFilesInDirectory(File directory) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"%s is not a directory", (Object[])new Object[]{directory});
        List thriftFilesInDirectory = FileUtils.getFiles((File)directory, (String)Joiner.on((String)",").join(this.includes), (String)Joiner.on((String)",").join(this.excludes));
        return ImmutableSet.copyOf((Collection)thriftFilesInDirectory);
    }

    protected List<File> getRecursiveThriftFiles(MavenProject project, String outputDirectory) throws IOException {
        return this.getRecursiveThriftFiles(project, outputDirectory, new ArrayList<File>());
    }

    List<File> getRecursiveThriftFiles(MavenProject project, String outputDirectory, List<File> files) throws IOException {
        HashFunction hashFun = Hashing.md5();
        File dir = new File(new File(project.getFile().getParent(), "target"), outputDirectory);
        if (dir.exists()) {
            URI baseDir = this.getFileURI(dir);
            for (File f : this.findThriftFilesInDirectory(dir)) {
                URI fileURI = this.getFileURI(f);
                String relPath = baseDir.relativize(fileURI).getPath();
                File destFolder = this.getResourcesOutputDirectory();
                destFolder.mkdirs();
                File destFile = new File(destFolder, relPath);
                if (!destFile.exists() || destFile.isFile() && !Files.hash((File)f, (HashFunction)hashFun).equals((Object)Files.hash((File)destFile, (HashFunction)hashFun))) {
                    this.getLog().info((CharSequence)String.format("copying %s to %s", f.getCanonicalPath(), destFile.getCanonicalPath()));
                    FileUtils.copyFile((File)f, (File)destFile);
                }
                files.add(destFile);
            }
        }
        Map refs = project.getProjectReferences();
        for (String name : refs.keySet()) {
            this.getRecursiveThriftFiles((MavenProject)refs.get(name), outputDirectory, files);
        }
        return files;
    }

    URI getFileURI(File file) throws IOException {
        try {
            return new URI("file://" + file.getCanonicalPath().replace("\\", "/"));
        }
        catch (URISyntaxException urie) {
            throw new IOException("error forming URI for file transfer: " + urie);
        }
    }

    protected String getClassifier() {
        return this.classifier;
    }

    private boolean isDepOfIdlArtifact(Artifact artifact, Map<String, Artifact> depsMap) {
        List depTrail = artifact.getDependencyTrail();
        if (depTrail != null) {
            for (String name : depTrail) {
                Artifact dep = depsMap.get(name);
                if (dep == null || !this.isIdlCalssifier(dep, this.classifier)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIdlCalssifier(Artifact artifact, String classifier) {
        return classifier.equalsIgnoreCase(artifact.getClassifier());
    }
}

