/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scrooge;

public abstract class Option<A> {
    public static Option<Void> NONE = new Option<Void>(){

        @Override
        public Void get() {
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isDefined() {
            return false;
        }
    };

    public abstract A get();

    public abstract boolean isDefined();

    public static <A> Option<A> make(boolean bl, A a) {
        if (bl) {
            return new Some<A>(a);
        }
        return Option.none();
    }

    public static <A> Option<A> none() {
        return NONE;
    }

    public static class Some<A>
    extends Option<A> {
        final A a;

        public Some(A a) {
            this.a = a;
        }

        @Override
        public A get() {
            return this.a;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Some)) {
                return false;
            }
            Some some = (Some)object;
            return this.a.equals(some.a);
        }

        public String toString() {
            return "Some(" + this.a.toString() + ")";
        }
    }
}

