/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scrooge;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Utilities {
    public static <T> List<T> makeList(T ... TArray) {
        return Arrays.asList(TArray);
    }

    public static <A, B> Map<A, B> makeMap(Tuple<A, B> ... tupleArray) {
        HashMap<A, B> hashMap = new HashMap<A, B>(tupleArray.length * 2 / 3);
        for (Tuple<A, B> tuple : tupleArray) {
            hashMap.put(tuple.getFirst(), tuple.getSecond());
        }
        return hashMap;
    }

    public static <T> Set<T> makeSet(T ... TArray) {
        HashSet<T> hashSet = new HashSet<T>(TArray.length * 2 / 3);
        for (T t : TArray) {
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T extends Enum<T>> Set<T> makeEnumSet(Class<T> clazz) {
        return EnumSet.noneOf(clazz);
    }

    public static <T extends Enum<T>> Set<T> makeEnumSet(T t, T ... TArray) {
        return EnumSet.of(t, TArray);
    }

    public static <A, B> Tuple<A, B> makeTuple(A a, B b) {
        return new Tuple<A, B>(a, b);
    }

    public static class Tuple<A, B> {
        private A a;
        private B b;

        public Tuple(A a, B b) {
            this.a = a;
            this.b = b;
        }

        A getFirst() {
            return this.a;
        }

        B getSecond() {
            return this.b;
        }
    }
}

