/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.api;

import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.auth.*;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.Configuration;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.ProgressRequestBody;
import com.twitter.clientlib.ProgressResponseBody;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.twitter.clientlib.model.AddOrDeleteRulesRequest;
import com.twitter.clientlib.model.AddOrDeleteRulesResponse;
import com.twitter.clientlib.model.CreateTweetRequest;
import com.twitter.clientlib.model.Error;
import com.twitter.clientlib.model.FilteredStreamingTweet;
import com.twitter.clientlib.model.GenericTweetsTimelineResponse;
import com.twitter.clientlib.model.GetRulesResponse;
import com.twitter.clientlib.model.Granularity;
import com.twitter.clientlib.model.HideReplyByIdRequest;
import com.twitter.clientlib.model.HideReplyByIdResponse;
import com.twitter.clientlib.model.ListsIdTweetsResponse;
import com.twitter.clientlib.model.MultiTweetLookupResponse;
import com.twitter.clientlib.model.MultiUserLookupResponse;
import java.time.OffsetDateTime;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.QuoteTweetLookupResponse;
import java.util.Set;
import com.twitter.clientlib.model.SingleTweetLookupResponse;
import com.twitter.clientlib.model.StreamingTweet;
import com.twitter.clientlib.model.TweetCountsResponse;
import com.twitter.clientlib.model.TweetCreateResponse;
import com.twitter.clientlib.model.TweetDeleteResponse;
import com.twitter.clientlib.model.TweetSearchResponse;
import com.twitter.clientlib.model.UsersIdLikedTweetsResponse;
import com.twitter.clientlib.model.UsersLikesCreateRequest;
import com.twitter.clientlib.model.UsersLikesCreateResponse;
import com.twitter.clientlib.model.UsersLikesDeleteResponse;
import com.twitter.clientlib.model.UsersRetweetsCreateRequest;
import com.twitter.clientlib.model.UsersRetweetsCreateResponse;
import com.twitter.clientlib.model.UsersRetweetsDeleteResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.io.InputStream;
import javax.ws.rs.core.GenericType;

import org.apache.commons.lang3.StringUtils;

public class TweetsApi extends ApiCommon {

    /**
     * Build call for addOrDeleteRules
     * @param addOrDeleteRulesRequest  (required)
     * @param dryRun Dry Run can be used with both the add and delete action, with the expected result given, but without actually taking any action in the system (meaning the end state will always be as it was when the request was submitted). This is particularly useful to validate rule changes. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addOrDeleteRulesCall(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = addOrDeleteRulesRequest;

        // create path and map variables
        String localVarPath = "/2/tweets/search/stream/rules";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (dryRun != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dry_run", dryRun));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addOrDeleteRulesValidateBeforeCall(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'addOrDeleteRulesRequest' is set
        if (addOrDeleteRulesRequest == null) {
            throw new ApiException("Missing the required parameter 'addOrDeleteRulesRequest' when calling addOrDeleteRules(Async)");
        }
        

        okhttp3.Call localVarCall = addOrDeleteRulesCall(addOrDeleteRulesRequest, dryRun, _callback);
        return localVarCall;

    }

    /**
     * Add/Delete rules
     * Add or delete rules from a user&#39;s active rule set. Users can provide unique, optionally tagged rules to add. Users can delete their entire rule set or a subset specified by rule ids or values.
     * @param addOrDeleteRulesRequest  (required)
     * @param dryRun Dry Run can be used with both the add and delete action, with the expected result given, but without actually taking any action in the system (meaning the end state will always be as it was when the request was submitted). This is particularly useful to validate rule changes. (optional)
     * @return AddOrDeleteRulesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public AddOrDeleteRulesResponse addOrDeleteRules(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun) throws ApiException {
      ApiResponse<AddOrDeleteRulesResponse> localVarResp = addOrDeleteRulesWithHttpInfo(addOrDeleteRulesRequest, dryRun);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public AddOrDeleteRulesResponse addOrDeleteRules(Integer retries, AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun) throws ApiException {
        AddOrDeleteRulesResponse localVarResp;
        try{
          localVarResp = addOrDeleteRules(addOrDeleteRulesRequest, dryRun);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return addOrDeleteRules(retries - 1, addOrDeleteRulesRequest, dryRun);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Add/Delete rules
     * Add or delete rules from a user&#39;s active rule set. Users can provide unique, optionally tagged rules to add. Users can delete their entire rule set or a subset specified by rule ids or values.
     * @param addOrDeleteRulesRequest  (required)
     * @param dryRun Dry Run can be used with both the add and delete action, with the expected result given, but without actually taking any action in the system (meaning the end state will always be as it was when the request was submitted). This is particularly useful to validate rule changes. (optional)
     * @return ApiResponse&lt;AddOrDeleteRulesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AddOrDeleteRulesResponse> addOrDeleteRulesWithHttpInfo(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun) throws ApiException {
        okhttp3.Call localVarCall = addOrDeleteRulesValidateBeforeCall(addOrDeleteRulesRequest, dryRun, null);
        try {
            Type localVarReturnType = new TypeToken<AddOrDeleteRulesResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Add/Delete rules (asynchronously)
     * Add or delete rules from a user&#39;s active rule set. Users can provide unique, optionally tagged rules to add. Users can delete their entire rule set or a subset specified by rule ids or values.
     * @param addOrDeleteRulesRequest  (required)
     * @param dryRun Dry Run can be used with both the add and delete action, with the expected result given, but without actually taking any action in the system (meaning the end state will always be as it was when the request was submitted). This is particularly useful to validate rule changes. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addOrDeleteRulesAsync(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, final ApiCallback<AddOrDeleteRulesResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = addOrDeleteRulesValidateBeforeCall(addOrDeleteRulesRequest, dryRun, _callback);
        Type localVarReturnType = new TypeToken<AddOrDeleteRulesResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTweet
     * @param createTweetRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTweetCall(CreateTweetRequest createTweetRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createTweetRequest;

        // create path and map variables
        String localVarPath = "/2/tweets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTweetValidateBeforeCall(CreateTweetRequest createTweetRequest, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createTweetCall(createTweetRequest, _callback);
        return localVarCall;

    }

    /**
     * Creation of a Tweet
     * Causes the user to create a tweet under the authorized account.
     * @param createTweetRequest  (optional)
     * @return TweetCreateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public TweetCreateResponse createTweet(CreateTweetRequest createTweetRequest) throws ApiException {
      ApiResponse<TweetCreateResponse> localVarResp = createTweetWithHttpInfo(createTweetRequest);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public TweetCreateResponse createTweet(Integer retries, CreateTweetRequest createTweetRequest) throws ApiException {
        TweetCreateResponse localVarResp;
        try{
          localVarResp = createTweet(createTweetRequest);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return createTweet(retries - 1, createTweetRequest);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Creation of a Tweet
     * Causes the user to create a tweet under the authorized account.
     * @param createTweetRequest  (optional)
     * @return ApiResponse&lt;TweetCreateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TweetCreateResponse> createTweetWithHttpInfo(CreateTweetRequest createTweetRequest) throws ApiException {
        okhttp3.Call localVarCall = createTweetValidateBeforeCall(createTweetRequest, null);
        try {
            Type localVarReturnType = new TypeToken<TweetCreateResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Creation of a Tweet (asynchronously)
     * Causes the user to create a tweet under the authorized account.
     * @param createTweetRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTweetAsync(CreateTweetRequest createTweetRequest, final ApiCallback<TweetCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTweetValidateBeforeCall(createTweetRequest, _callback);
        Type localVarReturnType = new TypeToken<TweetCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTweetById
     * @param id The ID of the Tweet to be deleted. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTweetByIdCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTweetByIdValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTweetById(Async)");
        }
        

        okhttp3.Call localVarCall = deleteTweetByIdCall(id, _callback);
        return localVarCall;

    }

    /**
     * Tweet delete by Tweet ID
     * Delete specified Tweet (in the path) by ID.
     * @param id The ID of the Tweet to be deleted. (required)
     * @return TweetDeleteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public TweetDeleteResponse deleteTweetById(String id) throws ApiException {
      ApiResponse<TweetDeleteResponse> localVarResp = deleteTweetByIdWithHttpInfo(id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public TweetDeleteResponse deleteTweetById(Integer retries, String id) throws ApiException {
        TweetDeleteResponse localVarResp;
        try{
          localVarResp = deleteTweetById(id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return deleteTweetById(retries - 1, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Tweet delete by Tweet ID
     * Delete specified Tweet (in the path) by ID.
     * @param id The ID of the Tweet to be deleted. (required)
     * @return ApiResponse&lt;TweetDeleteResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TweetDeleteResponse> deleteTweetByIdWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = deleteTweetByIdValidateBeforeCall(id, null);
        try {
            Type localVarReturnType = new TypeToken<TweetDeleteResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Tweet delete by Tweet ID (asynchronously)
     * Delete specified Tweet (in the path) by ID.
     * @param id The ID of the Tweet to be deleted. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTweetByIdAsync(String id, final ApiCallback<TweetDeleteResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTweetByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<TweetDeleteResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findTweetById
     * @param id A single Tweet ID. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findTweetByIdCall(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findTweetByIdValidateBeforeCall(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findTweetById(Async)");
        }
        

        okhttp3.Call localVarCall = findTweetByIdCall(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * Tweet lookup by Tweet ID
     * Returns a variety of information about the Tweet specified by the requested ID.
     * @param id A single Tweet ID. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return SingleTweetLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public SingleTweetLookupResponse findTweetById(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<SingleTweetLookupResponse> localVarResp = findTweetByIdWithHttpInfo(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public SingleTweetLookupResponse findTweetById(Integer retries, String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        SingleTweetLookupResponse localVarResp;
        try{
          localVarResp = findTweetById(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findTweetById(retries - 1, id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Tweet lookup by Tweet ID
     * Returns a variety of information about the Tweet specified by the requested ID.
     * @param id A single Tweet ID. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;SingleTweetLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SingleTweetLookupResponse> findTweetByIdWithHttpInfo(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = findTweetByIdValidateBeforeCall(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<SingleTweetLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Tweet lookup by Tweet ID (asynchronously)
     * Returns a variety of information about the Tweet specified by the requested ID.
     * @param id A single Tweet ID. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findTweetByIdAsync(String id, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<SingleTweetLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findTweetByIdValidateBeforeCall(id, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<SingleTweetLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findTweetsById
     * @param ids A comma separated list of Tweet IDs. Up to 100 are allowed in a single request. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findTweetsByIdCall(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (ids != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "ids", ids));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findTweetsByIdValidateBeforeCall(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findTweetsById(Async)");
        }
        

        okhttp3.Call localVarCall = findTweetsByIdCall(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * Tweet lookup by Tweet IDs
     * Returns a variety of information about the Tweet specified by the requested ID.
     * @param ids A comma separated list of Tweet IDs. Up to 100 are allowed in a single request. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return MultiTweetLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiTweetLookupResponse findTweetsById(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<MultiTweetLookupResponse> localVarResp = findTweetsByIdWithHttpInfo(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiTweetLookupResponse findTweetsById(Integer retries, List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        MultiTweetLookupResponse localVarResp;
        try{
          localVarResp = findTweetsById(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findTweetsById(retries - 1, ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Tweet lookup by Tweet IDs
     * Returns a variety of information about the Tweet specified by the requested ID.
     * @param ids A comma separated list of Tweet IDs. Up to 100 are allowed in a single request. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;MultiTweetLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiTweetLookupResponse> findTweetsByIdWithHttpInfo(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = findTweetsByIdValidateBeforeCall(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Tweet lookup by Tweet IDs (asynchronously)
     * Returns a variety of information about the Tweet specified by the requested ID.
     * @param ids A comma separated list of Tweet IDs. Up to 100 are allowed in a single request. (required)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findTweetsByIdAsync(List<String> ids, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<MultiTweetLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findTweetsByIdValidateBeforeCall(ids, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findTweetsThatQuoteATweet
     * @param id The ID of the Quoted Tweet. (required)
     * @param maxResults The maximum number of results to be returned. (optional, default to 10)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findTweetsThatQuoteATweetCall(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/{id}/quote_tweets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (exclude != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findTweetsThatQuoteATweetValidateBeforeCall(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findTweetsThatQuoteATweet(Async)");
        }
        

        okhttp3.Call localVarCall = findTweetsThatQuoteATweetCall(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * Retrieve tweets that quote a tweet.
     * Returns a variety of information about each tweet that quotes the Tweet specified by the requested ID.
     * @param id The ID of the Quoted Tweet. (required)
     * @param maxResults The maximum number of results to be returned. (optional, default to 10)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return QuoteTweetLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public QuoteTweetLookupResponse findTweetsThatQuoteATweet(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<QuoteTweetLookupResponse> localVarResp = findTweetsThatQuoteATweetWithHttpInfo(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public QuoteTweetLookupResponse findTweetsThatQuoteATweet(Integer retries, String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        QuoteTweetLookupResponse localVarResp;
        try{
          localVarResp = findTweetsThatQuoteATweet(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return findTweetsThatQuoteATweet(retries - 1, id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Retrieve tweets that quote a tweet.
     * Returns a variety of information about each tweet that quotes the Tweet specified by the requested ID.
     * @param id The ID of the Quoted Tweet. (required)
     * @param maxResults The maximum number of results to be returned. (optional, default to 10)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;QuoteTweetLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<QuoteTweetLookupResponse> findTweetsThatQuoteATweetWithHttpInfo(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = findTweetsThatQuoteATweetValidateBeforeCall(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<QuoteTweetLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Retrieve tweets that quote a tweet. (asynchronously)
     * Returns a variety of information about each tweet that quotes the Tweet specified by the requested ID.
     * @param id The ID of the Quoted Tweet. (required)
     * @param maxResults The maximum number of results to be returned. (optional, default to 10)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findTweetsThatQuoteATweetAsync(String id, Integer maxResults, Set<String> exclude, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<QuoteTweetLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = findTweetsThatQuoteATweetValidateBeforeCall(id, maxResults, exclude, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<QuoteTweetLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRules
     * @param ids A comma-separated list of Rule IDs. (optional)
     * @param maxResults The maximum number of results (optional, default to 1000)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; returned in a request to paginate through results. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRulesCall(List<String> ids, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/search/stream/rules";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (ids != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "ids", ids));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRulesValidateBeforeCall(List<String> ids, Integer maxResults, String paginationToken, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getRulesCall(ids, maxResults, paginationToken, _callback);
        return localVarCall;

    }

    /**
     * Rules lookup
     * Returns rules from a user&#39;s active rule set. Users can fetch all of their rules or a subset, specified by the provided rule ids.
     * @param ids A comma-separated list of Rule IDs. (optional)
     * @param maxResults The maximum number of results (optional, default to 1000)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; returned in a request to paginate through results. (optional)
     * @return GetRulesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GetRulesResponse getRules(List<String> ids, Integer maxResults, String paginationToken) throws ApiException {
      ApiResponse<GetRulesResponse> localVarResp = getRulesWithHttpInfo(ids, maxResults, paginationToken);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GetRulesResponse getRules(Integer retries, List<String> ids, Integer maxResults, String paginationToken) throws ApiException {
        GetRulesResponse localVarResp;
        try{
          localVarResp = getRules(ids, maxResults, paginationToken);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return getRules(retries - 1, ids, maxResults, paginationToken);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Rules lookup
     * Returns rules from a user&#39;s active rule set. Users can fetch all of their rules or a subset, specified by the provided rule ids.
     * @param ids A comma-separated list of Rule IDs. (optional)
     * @param maxResults The maximum number of results (optional, default to 1000)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; returned in a request to paginate through results. (optional)
     * @return ApiResponse&lt;GetRulesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetRulesResponse> getRulesWithHttpInfo(List<String> ids, Integer maxResults, String paginationToken) throws ApiException {
        okhttp3.Call localVarCall = getRulesValidateBeforeCall(ids, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<GetRulesResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Rules lookup (asynchronously)
     * Returns rules from a user&#39;s active rule set. Users can fetch all of their rules or a subset, specified by the provided rule ids.
     * @param ids A comma-separated list of Rule IDs. (optional)
     * @param maxResults The maximum number of results (optional, default to 1000)
     * @param paginationToken This value is populated by passing the &#39;next_token&#39; returned in a request to paginate through results. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRulesAsync(List<String> ids, Integer maxResults, String paginationToken, final ApiCallback<GetRulesResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRulesValidateBeforeCall(ids, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<GetRulesResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for hideReplyById
     * @param hideReplyByIdRequest  (optional)
     * @param id The ID of the reply that you want to hide or unhide. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. The reply has been hidden or unhidden. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call hideReplyByIdCall(HideReplyByIdRequest hideReplyByIdRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = hideReplyByIdRequest;

        // create path and map variables
        String localVarPath = "/2/tweets/{id}/hidden"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call hideReplyByIdValidateBeforeCall(HideReplyByIdRequest hideReplyByIdRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling hideReplyById(Async)");
        }
        

        okhttp3.Call localVarCall = hideReplyByIdCall(hideReplyByIdRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Hide replies
     * Hides or unhides a reply to an owned conversation.
     * @param hideReplyByIdRequest  (optional)
     * @param id The ID of the reply that you want to hide or unhide. (required)
     * @return HideReplyByIdResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. The reply has been hidden or unhidden. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public HideReplyByIdResponse hideReplyById(HideReplyByIdRequest hideReplyByIdRequest, String id) throws ApiException {
      ApiResponse<HideReplyByIdResponse> localVarResp = hideReplyByIdWithHttpInfo(hideReplyByIdRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public HideReplyByIdResponse hideReplyById(Integer retries, HideReplyByIdRequest hideReplyByIdRequest, String id) throws ApiException {
        HideReplyByIdResponse localVarResp;
        try{
          localVarResp = hideReplyById(hideReplyByIdRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return hideReplyById(retries - 1, hideReplyByIdRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Hide replies
     * Hides or unhides a reply to an owned conversation.
     * @param hideReplyByIdRequest  (optional)
     * @param id The ID of the reply that you want to hide or unhide. (required)
     * @return ApiResponse&lt;HideReplyByIdResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. The reply has been hidden or unhidden. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HideReplyByIdResponse> hideReplyByIdWithHttpInfo(HideReplyByIdRequest hideReplyByIdRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = hideReplyByIdValidateBeforeCall(hideReplyByIdRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<HideReplyByIdResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Hide replies (asynchronously)
     * Hides or unhides a reply to an owned conversation.
     * @param hideReplyByIdRequest  (optional)
     * @param id The ID of the reply that you want to hide or unhide. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A successful response. The reply has been hidden or unhidden. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call hideReplyByIdAsync(HideReplyByIdRequest hideReplyByIdRequest, String id, final ApiCallback<HideReplyByIdResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = hideReplyByIdValidateBeforeCall(hideReplyByIdRequest, id, _callback);
        Type localVarReturnType = new TypeToken<HideReplyByIdResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listsIdTweets
     * @param id The ID of the List to list Tweets of (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listsIdTweetsCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/lists/{id}/tweets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listsIdTweetsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listsIdTweets(Async)");
        }
        

        okhttp3.Call localVarCall = listsIdTweetsCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * List Tweets timeline by List ID
     * Returns a list of Tweets associated with the provided List ID
     * @param id The ID of the List to list Tweets of (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ListsIdTweetsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ListsIdTweetsResponse listsIdTweets(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<ListsIdTweetsResponse> localVarResp = listsIdTweetsWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public ListsIdTweetsResponse listsIdTweets(Integer retries, String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        ListsIdTweetsResponse localVarResp;
        try{
          localVarResp = listsIdTweets(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return listsIdTweets(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * List Tweets timeline by List ID
     * Returns a list of Tweets associated with the provided List ID
     * @param id The ID of the List to list Tweets of (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;ListsIdTweetsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListsIdTweetsResponse> listsIdTweetsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = listsIdTweetsValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<ListsIdTweetsResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * List Tweets timeline by List ID (asynchronously)
     * Returns a list of Tweets associated with the provided List ID
     * @param id The ID of the List to list Tweets of (required)
     * @param maxResults The maximum number of results (optional, default to 100)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listsIdTweetsAsync(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<ListsIdTweetsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listsIdTweetsValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<ListsIdTweetsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sampleStream
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param backfillMinutes The number of minutes of backfill requested (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful. Successful responses will return a stream of individual JSON Tweet payloads. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sampleStreamCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/sample/stream";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        if (backfillMinutes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("backfill_minutes", backfillMinutes));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sampleStreamValidateBeforeCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = sampleStreamCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, _callback);
        return localVarCall;

    }

    /**
     * Sample stream
     * Streams a deterministic 1% of public Tweets.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param backfillMinutes The number of minutes of backfill requested (optional)
     * @return StreamingTweet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful. Successful responses will return a stream of individual JSON Tweet payloads. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public InputStream sampleStream(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        InputStream localVarResp = sampleStreamWithHttpInfo(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
        return localVarResp;
    }

    /**
     * Calls the API using a retry mechanism to handle rate limits errors.
     *
     */
    public InputStream sampleStream(Integer retries, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        InputStream localVarResp;
        try{
          localVarResp = sampleStream(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
        }
        catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return sampleStream(retries - 1, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }


    /**
     * Sample stream
     * Streams a deterministic 1% of public Tweets.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param backfillMinutes The number of minutes of backfill requested (optional)
     * @return ApiResponse&lt;StreamingTweet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful. Successful responses will return a stream of individual JSON Tweet payloads. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public InputStream sampleStreamWithHttpInfo(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        okhttp3.Call localVarCall = sampleStreamValidateBeforeCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, null);
        try {
            Type localVarReturnType = new TypeToken<StreamingTweet>(){}.getType();
            return localVarApiClient.executeStream(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }
    
    /**
     * Sample stream (asynchronously)
     * Streams a deterministic 1% of public Tweets.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param backfillMinutes The number of minutes of backfill requested (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful. Successful responses will return a stream of individual JSON Tweet payloads. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sampleStreamAsync(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, final ApiCallback<StreamingTweet> _callback) throws ApiException {

        okhttp3.Call localVarCall = sampleStreamValidateBeforeCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, _callback);
        Type localVarReturnType = new TypeToken<StreamingTweet>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for searchStream
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param backfillMinutes The number of minutes of backfill requested (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful. Successful responses will return a stream of individual JSON Tweet payloads. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchStreamCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/search/stream";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        if (backfillMinutes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("backfill_minutes", backfillMinutes));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call searchStreamValidateBeforeCall(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = searchStreamCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, _callback);
        return localVarCall;

    }

    /**
     * Filtered stream
     * Streams Tweets matching the stream&#39;s active rule set.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param backfillMinutes The number of minutes of backfill requested (optional)
     * @return FilteredStreamingTweet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful. Successful responses will return a stream of individual JSON Tweet payloads. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public InputStream searchStream(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        InputStream localVarResp = searchStreamWithHttpInfo(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
        return localVarResp;
    }

    /**
     * Calls the API using a retry mechanism to handle rate limits errors.
     *
     */
    public InputStream searchStream(Integer retries, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        InputStream localVarResp;
        try{
          localVarResp = searchStream(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
        }
        catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return searchStream(retries - 1, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }


    /**
     * Filtered stream
     * Streams Tweets matching the stream&#39;s active rule set.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param backfillMinutes The number of minutes of backfill requested (optional)
     * @return ApiResponse&lt;FilteredStreamingTweet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful. Successful responses will return a stream of individual JSON Tweet payloads. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public InputStream searchStreamWithHttpInfo(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes) throws ApiException {
        okhttp3.Call localVarCall = searchStreamValidateBeforeCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, null);
        try {
            Type localVarReturnType = new TypeToken<FilteredStreamingTweet>(){}.getType();
            return localVarApiClient.executeStream(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }
    
    /**
     * Filtered stream (asynchronously)
     * Streams Tweets matching the stream&#39;s active rule set.
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param backfillMinutes The number of minutes of backfill requested (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful. Successful responses will return a stream of individual JSON Tweet payloads. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchStreamAsync(Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, Integer backfillMinutes, final ApiCallback<FilteredStreamingTweet> _callback) throws ApiException {

        okhttp3.Call localVarCall = searchStreamValidateBeforeCall(expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, backfillMinutes, _callback);
        Type localVarReturnType = new TypeToken<FilteredStreamingTweet>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for spaceBuyers
     * @param id The space id from which tweets will be retrieved (required)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call spaceBuyersCall(String id, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/spaces/{id}/buyers"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call spaceBuyersValidateBeforeCall(String id, Set<String> userFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceBuyers(Async)");
        }
        

        okhttp3.Call localVarCall = spaceBuyersCall(id, userFields, _callback);
        return localVarCall;

    }

    /**
     * Retrieve the list of users who purchased a ticket to the given space
     * Retrieves the list of users who purchased a ticket to the given space
     * @param id The space id from which tweets will be retrieved (required)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return MultiUserLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiUserLookupResponse spaceBuyers(String id, Set<String> userFields) throws ApiException {
      ApiResponse<MultiUserLookupResponse> localVarResp = spaceBuyersWithHttpInfo(id, userFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiUserLookupResponse spaceBuyers(Integer retries, String id, Set<String> userFields) throws ApiException {
        MultiUserLookupResponse localVarResp;
        try{
          localVarResp = spaceBuyers(id, userFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return spaceBuyers(retries - 1, id, userFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Retrieve the list of users who purchased a ticket to the given space
     * Retrieves the list of users who purchased a ticket to the given space
     * @param id The space id from which tweets will be retrieved (required)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @return ApiResponse&lt;MultiUserLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiUserLookupResponse> spaceBuyersWithHttpInfo(String id, Set<String> userFields) throws ApiException {
        okhttp3.Call localVarCall = spaceBuyersValidateBeforeCall(id, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Retrieve the list of users who purchased a ticket to the given space (asynchronously)
     * Retrieves the list of users who purchased a ticket to the given space
     * @param id The space id from which tweets will be retrieved (required)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call spaceBuyersAsync(String id, Set<String> userFields, final ApiCallback<MultiUserLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = spaceBuyersValidateBeforeCall(id, userFields, _callback);
        Type localVarReturnType = new TypeToken<MultiUserLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for spaceTweets
     * @param maxResults The number of tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100 (optional)
     * @param id The space id from which tweets will be retrieved (required)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call spaceTweetsCall(Integer maxResults, String id, Set<String> tweetFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/spaces/{id}/tweets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call spaceTweetsValidateBeforeCall(Integer maxResults, String id, Set<String> tweetFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceTweets(Async)");
        }
        

        okhttp3.Call localVarCall = spaceTweetsCall(maxResults, id, tweetFields, _callback);
        return localVarCall;

    }

    /**
     * Retrieve tweets from a Space
     * Retrieves tweets shared in the specified space
     * @param maxResults The number of tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100 (optional)
     * @param id The space id from which tweets will be retrieved (required)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @return MultiTweetLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public MultiTweetLookupResponse spaceTweets(Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
      ApiResponse<MultiTweetLookupResponse> localVarResp = spaceTweetsWithHttpInfo(maxResults, id, tweetFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public MultiTweetLookupResponse spaceTweets(Integer retries, Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        MultiTweetLookupResponse localVarResp;
        try{
          localVarResp = spaceTweets(maxResults, id, tweetFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return spaceTweets(retries - 1, maxResults, id, tweetFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Retrieve tweets from a Space
     * Retrieves tweets shared in the specified space
     * @param maxResults The number of tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100 (optional)
     * @param id The space id from which tweets will be retrieved (required)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @return ApiResponse&lt;MultiTweetLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultiTweetLookupResponse> spaceTweetsWithHttpInfo(Integer maxResults, String id, Set<String> tweetFields) throws ApiException {
        okhttp3.Call localVarCall = spaceTweetsValidateBeforeCall(maxResults, id, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Retrieve tweets from a Space (asynchronously)
     * Retrieves tweets shared in the specified space
     * @param maxResults The number of tweets to fetch from the provided space. If not provided, the value will default to the maximum of 100 (optional)
     * @param id The space id from which tweets will be retrieved (required)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call spaceTweetsAsync(Integer maxResults, String id, Set<String> tweetFields, final ApiCallback<MultiTweetLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = spaceTweetsValidateBeforeCall(maxResults, id, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<MultiTweetLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for tweetCountsFullArchiveSearch
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param granularity The granularity for the search counts results. (optional, default to hour)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweet counts response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetCountsFullArchiveSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/counts/all";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (startTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_time", startTime));
        }

        if (endTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_time", endTime));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (nextToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("next_token", nextToken));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (granularity != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("granularity", granularity));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call tweetCountsFullArchiveSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetCountsFullArchiveSearch(Async)");
        }
        

        okhttp3.Call localVarCall = tweetCountsFullArchiveSearchCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, _callback);
        return localVarCall;

    }

    /**
     * Full archive search counts
     * Returns Tweet Counts that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param granularity The granularity for the search counts results. (optional, default to hour)
     * @return TweetCountsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweet counts response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public TweetCountsResponse tweetCountsFullArchiveSearch(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
      ApiResponse<TweetCountsResponse> localVarResp = tweetCountsFullArchiveSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public TweetCountsResponse tweetCountsFullArchiveSearch(Integer retries, String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        TweetCountsResponse localVarResp;
        try{
          localVarResp = tweetCountsFullArchiveSearch(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return tweetCountsFullArchiveSearch(retries - 1, query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Full archive search counts
     * Returns Tweet Counts that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param granularity The granularity for the search counts results. (optional, default to hour)
     * @return ApiResponse&lt;TweetCountsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweet counts response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TweetCountsResponse> tweetCountsFullArchiveSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        okhttp3.Call localVarCall = tweetCountsFullArchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, null);
        try {
            Type localVarReturnType = new TypeToken<TweetCountsResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Full archive search counts (asynchronously)
     * Returns Tweet Counts that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param granularity The granularity for the search counts results. (optional, default to hour)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweet counts response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetCountsFullArchiveSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, final ApiCallback<TweetCountsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = tweetCountsFullArchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, _callback);
        Type localVarReturnType = new TypeToken<TweetCountsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for tweetCountsRecentSearch
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param granularity The granularity for the search counts results. (optional, default to hour)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Recent tweet counts response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetCountsRecentSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/counts/recent";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (startTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_time", startTime));
        }

        if (endTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_time", endTime));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (nextToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("next_token", nextToken));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (granularity != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("granularity", granularity));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call tweetCountsRecentSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetCountsRecentSearch(Async)");
        }
        

        okhttp3.Call localVarCall = tweetCountsRecentSearchCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, _callback);
        return localVarCall;

    }

    /**
     * Recent search counts
     * Returns Tweet Counts from the last 7 days that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param granularity The granularity for the search counts results. (optional, default to hour)
     * @return TweetCountsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Recent tweet counts response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public TweetCountsResponse tweetCountsRecentSearch(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
      ApiResponse<TweetCountsResponse> localVarResp = tweetCountsRecentSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public TweetCountsResponse tweetCountsRecentSearch(Integer retries, String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        TweetCountsResponse localVarResp;
        try{
          localVarResp = tweetCountsRecentSearch(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return tweetCountsRecentSearch(retries - 1, query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Recent search counts
     * Returns Tweet Counts from the last 7 days that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param granularity The granularity for the search counts results. (optional, default to hour)
     * @return ApiResponse&lt;TweetCountsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Recent tweet counts response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TweetCountsResponse> tweetCountsRecentSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity) throws ApiException {
        okhttp3.Call localVarCall = tweetCountsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, null);
        try {
            Type localVarReturnType = new TypeToken<TweetCountsResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Recent search counts (asynchronously)
     * Returns Tweet Counts from the last 7 days that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param granularity The granularity for the search counts results. (optional, default to hour)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Recent tweet counts response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetCountsRecentSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, Granularity granularity, final ApiCallback<TweetCountsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = tweetCountsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, _callback);
        Type localVarReturnType = new TypeToken<TweetCountsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for tweetsFullarchiveSearch
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param maxResults The maximum number of search results to be returned by a request. (optional, default to 10)
     * @param sortOrder This order in which to return results. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweets full archive search response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetsFullarchiveSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/search/all";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (startTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_time", startTime));
        }

        if (endTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_time", endTime));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort_order", sortOrder));
        }

        if (nextToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("next_token", nextToken));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call tweetsFullarchiveSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetsFullarchiveSearch(Async)");
        }
        

        okhttp3.Call localVarCall = tweetsFullarchiveSearchCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * Full-archive search
     * Returns Tweets that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param maxResults The maximum number of search results to be returned by a request. (optional, default to 10)
     * @param sortOrder This order in which to return results. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return TweetSearchResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweets full archive search response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public TweetSearchResponse tweetsFullarchiveSearch(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<TweetSearchResponse> localVarResp = tweetsFullarchiveSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public TweetSearchResponse tweetsFullarchiveSearch(Integer retries, String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        TweetSearchResponse localVarResp;
        try{
          localVarResp = tweetsFullarchiveSearch(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return tweetsFullarchiveSearch(retries - 1, query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Full-archive search
     * Returns Tweets that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param maxResults The maximum number of search results to be returned by a request. (optional, default to 10)
     * @param sortOrder This order in which to return results. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;TweetSearchResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweets full archive search response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TweetSearchResponse> tweetsFullarchiveSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = tweetsFullarchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<TweetSearchResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Full-archive search (asynchronously)
     * Returns Tweets that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param maxResults The maximum number of search results to be returned by a request. (optional, default to 10)
     * @param sortOrder This order in which to return results. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweets full archive search response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetsFullarchiveSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<TweetSearchResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = tweetsFullarchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<TweetSearchResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for tweetsRecentSearch
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param maxResults The maximum number of search results to be returned by a request. (optional, default to 10)
     * @param sortOrder This order in which to return results. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweets recent search response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetsRecentSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/tweets/search/recent";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        if (startTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_time", startTime));
        }

        if (endTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_time", endTime));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort_order", sortOrder));
        }

        if (nextToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("next_token", nextToken));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call tweetsRecentSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetsRecentSearch(Async)");
        }
        

        okhttp3.Call localVarCall = tweetsRecentSearchCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * Recent search
     * Returns Tweets from the last 7 days that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param maxResults The maximum number of search results to be returned by a request. (optional, default to 10)
     * @param sortOrder This order in which to return results. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return TweetSearchResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweets recent search response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public TweetSearchResponse tweetsRecentSearch(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<TweetSearchResponse> localVarResp = tweetsRecentSearchWithHttpInfo(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public TweetSearchResponse tweetsRecentSearch(Integer retries, String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        TweetSearchResponse localVarResp;
        try{
          localVarResp = tweetsRecentSearch(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return tweetsRecentSearch(retries - 1, query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Recent search
     * Returns Tweets from the last 7 days that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param maxResults The maximum number of search results to be returned by a request. (optional, default to 10)
     * @param sortOrder This order in which to return results. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;TweetSearchResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweets recent search response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TweetSearchResponse> tweetsRecentSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = tweetsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<TweetSearchResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Recent search (asynchronously)
     * Returns Tweets from the last 7 days that match a search query.
     * @param query One query/rule/filter for matching Tweets. Refer to https://t.co/rulelength to identify the max query length (required)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The oldest UTC timestamp (from most recent 7 days) from which the Tweets will be provided. Timestamp is in second granularity and is inclusive (i.e. 12:00:01 includes the first second of the minute). (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The newest, most recent UTC timestamp to which the Tweets will be provided. Timestamp is in second granularity and is exclusive (i.e. 12:00:01 excludes the first second of the minute). (optional)
     * @param sinceId Returns results with a Tweet ID greater than (that is, more recent than) the specified ID. (optional)
     * @param untilId Returns results with a Tweet ID less than (that is, older than) the specified ID. (optional)
     * @param maxResults The maximum number of search results to be returned by a request. (optional, default to 10)
     * @param sortOrder This order in which to return results. (optional)
     * @param nextToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. The value used with the parameter is pulled directly from the response provided by the API, and should not be modified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Tweets recent search response </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tweetsRecentSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String sortOrder, String nextToken, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<TweetSearchResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = tweetsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, sortOrder, nextToken, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<TweetSearchResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdLike
     * @param usersLikesCreateRequest  (optional)
     * @param id The ID of the user that is requesting to like the tweet (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdLikeCall(UsersLikesCreateRequest usersLikesCreateRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = usersLikesCreateRequest;

        // create path and map variables
        String localVarPath = "/2/users/{id}/likes"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdLikeValidateBeforeCall(UsersLikesCreateRequest usersLikesCreateRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdLike(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdLikeCall(usersLikesCreateRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Causes the user (in the path) to like the specified tweet
     * Causes the user (in the path) to like the specified tweet. The user in the path must match the user context authorizing the request.
     * @param usersLikesCreateRequest  (optional)
     * @param id The ID of the user that is requesting to like the tweet (required)
     * @return UsersLikesCreateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersLikesCreateResponse usersIdLike(UsersLikesCreateRequest usersLikesCreateRequest, String id) throws ApiException {
      ApiResponse<UsersLikesCreateResponse> localVarResp = usersIdLikeWithHttpInfo(usersLikesCreateRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersLikesCreateResponse usersIdLike(Integer retries, UsersLikesCreateRequest usersLikesCreateRequest, String id) throws ApiException {
        UsersLikesCreateResponse localVarResp;
        try{
          localVarResp = usersIdLike(usersLikesCreateRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdLike(retries - 1, usersLikesCreateRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Causes the user (in the path) to like the specified tweet
     * Causes the user (in the path) to like the specified tweet. The user in the path must match the user context authorizing the request.
     * @param usersLikesCreateRequest  (optional)
     * @param id The ID of the user that is requesting to like the tweet (required)
     * @return ApiResponse&lt;UsersLikesCreateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersLikesCreateResponse> usersIdLikeWithHttpInfo(UsersLikesCreateRequest usersLikesCreateRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = usersIdLikeValidateBeforeCall(usersLikesCreateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersLikesCreateResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Causes the user (in the path) to like the specified tweet (asynchronously)
     * Causes the user (in the path) to like the specified tweet. The user in the path must match the user context authorizing the request.
     * @param usersLikesCreateRequest  (optional)
     * @param id The ID of the user that is requesting to like the tweet (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdLikeAsync(UsersLikesCreateRequest usersLikesCreateRequest, String id, final ApiCallback<UsersLikesCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdLikeValidateBeforeCall(usersLikesCreateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersLikesCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdLikedTweets
     * @param id The ID of the User to list the liked Tweets of (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdLikedTweetsCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/liked_tweets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdLikedTweetsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdLikedTweets(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdLikedTweetsCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * Returns Tweet objects liked by the provided User ID
     * Returns a list of Tweets liked by the provided User ID
     * @param id The ID of the User to list the liked Tweets of (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return UsersIdLikedTweetsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersIdLikedTweetsResponse usersIdLikedTweets(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<UsersIdLikedTweetsResponse> localVarResp = usersIdLikedTweetsWithHttpInfo(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersIdLikedTweetsResponse usersIdLikedTweets(Integer retries, String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        UsersIdLikedTweetsResponse localVarResp;
        try{
          localVarResp = usersIdLikedTweets(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdLikedTweets(retries - 1, id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Returns Tweet objects liked by the provided User ID
     * Returns a list of Tweets liked by the provided User ID
     * @param id The ID of the User to list the liked Tweets of (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;UsersIdLikedTweetsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersIdLikedTweetsResponse> usersIdLikedTweetsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = usersIdLikedTweetsValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<UsersIdLikedTweetsResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Returns Tweet objects liked by the provided User ID (asynchronously)
     * Returns a list of Tweets liked by the provided User ID
     * @param id The ID of the User to list the liked Tweets of (required)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdLikedTweetsAsync(String id, Integer maxResults, String paginationToken, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<UsersIdLikedTweetsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdLikedTweetsValidateBeforeCall(id, maxResults, paginationToken, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<UsersIdLikedTweetsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdMentions
     * @param id The ID of the User to list mentions of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdMentionsCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/mentions"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (startTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_time", startTime));
        }

        if (endTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_time", endTime));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdMentionsValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMentions(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdMentionsCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * User mention timeline by User ID
     * Returns Tweet objects that mention username associated to the provided User ID
     * @param id The ID of the User to list mentions of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return GenericTweetsTimelineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericTweetsTimelineResponse usersIdMentions(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<GenericTweetsTimelineResponse> localVarResp = usersIdMentionsWithHttpInfo(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericTweetsTimelineResponse usersIdMentions(Integer retries, String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        GenericTweetsTimelineResponse localVarResp;
        try{
          localVarResp = usersIdMentions(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdMentions(retries - 1, id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * User mention timeline by User ID
     * Returns Tweet objects that mention username associated to the provided User ID
     * @param id The ID of the User to list mentions of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;GenericTweetsTimelineResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericTweetsTimelineResponse> usersIdMentionsWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = usersIdMentionsValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * User mention timeline by User ID (asynchronously)
     * Returns Tweet objects that mention username associated to the provided User ID
     * @param id The ID of the User to list mentions of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdMentionsAsync(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<GenericTweetsTimelineResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdMentionsValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdRetweets
     * @param usersRetweetsCreateRequest  (optional)
     * @param id The ID of the user that is requesting to retweet the tweet (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdRetweetsCall(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = usersRetweetsCreateRequest;

        // create path and map variables
        String localVarPath = "/2/users/{id}/retweets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdRetweetsValidateBeforeCall(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdRetweets(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdRetweetsCall(usersRetweetsCreateRequest, id, _callback);
        return localVarCall;

    }

    /**
     * Causes the user (in the path) to retweet the specified tweet
     * Causes the user (in the path) to retweet the specified tweet. The user in the path must match the user context authorizing the request.
     * @param usersRetweetsCreateRequest  (optional)
     * @param id The ID of the user that is requesting to retweet the tweet (required)
     * @return UsersRetweetsCreateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersRetweetsCreateResponse usersIdRetweets(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id) throws ApiException {
      ApiResponse<UsersRetweetsCreateResponse> localVarResp = usersIdRetweetsWithHttpInfo(usersRetweetsCreateRequest, id);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersRetweetsCreateResponse usersIdRetweets(Integer retries, UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id) throws ApiException {
        UsersRetweetsCreateResponse localVarResp;
        try{
          localVarResp = usersIdRetweets(usersRetweetsCreateRequest, id);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdRetweets(retries - 1, usersRetweetsCreateRequest, id);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Causes the user (in the path) to retweet the specified tweet
     * Causes the user (in the path) to retweet the specified tweet. The user in the path must match the user context authorizing the request.
     * @param usersRetweetsCreateRequest  (optional)
     * @param id The ID of the user that is requesting to retweet the tweet (required)
     * @return ApiResponse&lt;UsersRetweetsCreateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersRetweetsCreateResponse> usersIdRetweetsWithHttpInfo(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id) throws ApiException {
        okhttp3.Call localVarCall = usersIdRetweetsValidateBeforeCall(usersRetweetsCreateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersRetweetsCreateResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Causes the user (in the path) to retweet the specified tweet (asynchronously)
     * Causes the user (in the path) to retweet the specified tweet. The user in the path must match the user context authorizing the request.
     * @param usersRetweetsCreateRequest  (optional)
     * @param id The ID of the user that is requesting to retweet the tweet (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdRetweetsAsync(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, final ApiCallback<UsersRetweetsCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdRetweetsValidateBeforeCall(usersRetweetsCreateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersRetweetsCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdTimeline
     * @param id The ID of the User to list Reverse Chronological Timeline Tweets of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdTimelineCall(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/timelines/reverse_chronological"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (exclude != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (startTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_time", startTime));
        }

        if (endTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_time", endTime));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdTimelineValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdTimeline(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdTimelineCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * User home timeline by User ID
     * Returns Tweet objects that appears in the provided User ID&#39;s home timeline
     * @param id The ID of the User to list Reverse Chronological Timeline Tweets of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return GenericTweetsTimelineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericTweetsTimelineResponse usersIdTimeline(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<GenericTweetsTimelineResponse> localVarResp = usersIdTimelineWithHttpInfo(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericTweetsTimelineResponse usersIdTimeline(Integer retries, String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        GenericTweetsTimelineResponse localVarResp;
        try{
          localVarResp = usersIdTimeline(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdTimeline(retries - 1, id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * User home timeline by User ID
     * Returns Tweet objects that appears in the provided User ID&#39;s home timeline
     * @param id The ID of the User to list Reverse Chronological Timeline Tweets of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;GenericTweetsTimelineResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericTweetsTimelineResponse> usersIdTimelineWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = usersIdTimelineValidateBeforeCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * User home timeline by User ID (asynchronously)
     * Returns Tweet objects that appears in the provided User ID&#39;s home timeline
     * @param id The ID of the User to list Reverse Chronological Timeline Tweets of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdTimelineAsync(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<GenericTweetsTimelineResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdTimelineValidateBeforeCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdTweets
     * @param id The ID of the User to list Tweets of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdTweetsCall(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/tweets"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("max_results", maxResults));
        }

        if (exclude != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }

        if (paginationToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }

        if (startTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_time", startTime));
        }

        if (endTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_time", endTime));
        }

        if (expansions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }

        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }

        if (userFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }

        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }

        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }

        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BearerToken", "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdTweetsValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdTweets(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdTweetsCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        return localVarCall;

    }

    /**
     * User Tweets timeline by User ID
     * Returns a list of Tweets authored by the provided User ID
     * @param id The ID of the User to list Tweets of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return GenericTweetsTimelineResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public GenericTweetsTimelineResponse usersIdTweets(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
      ApiResponse<GenericTweetsTimelineResponse> localVarResp = usersIdTweetsWithHttpInfo(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public GenericTweetsTimelineResponse usersIdTweets(Integer retries, String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        GenericTweetsTimelineResponse localVarResp;
        try{
          localVarResp = usersIdTweets(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdTweets(retries - 1, id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * User Tweets timeline by User ID
     * Returns a list of Tweets authored by the provided User ID
     * @param id The ID of the User to list Tweets of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @return ApiResponse&lt;GenericTweetsTimelineResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GenericTweetsTimelineResponse> usersIdTweetsWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields) throws ApiException {
        okhttp3.Call localVarCall = usersIdTweetsValidateBeforeCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, null);
        try {
            Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * User Tweets timeline by User ID (asynchronously)
     * Returns a list of Tweets authored by the provided User ID
     * @param id The ID of the User to list Tweets of (required)
     * @param sinceId The minimum Tweet ID to be included in the result set. This parameter takes precedence over start_time if both are specified. (optional)
     * @param untilId The maximum Tweet ID to be included in the result set. This parameter takes precedence over end_time if both are specified. (optional)
     * @param maxResults The maximum number of results (optional)
     * @param exclude The set of entities to exclude (e.g. &#39;replies&#39; or &#39;retweets&#39;) (optional)
     * @param paginationToken This parameter is used to get the next &#39;page&#39; of results. (optional)
     * @param startTime YYYY-MM-DDTHH:mm:ssZ. The earliest UTC timestamp from which the Tweets will be provided. The since_id parameter takes precedence if it is also specified. (optional)
     * @param endTime YYYY-MM-DDTHH:mm:ssZ. The latest UTC timestamp to which the Tweets will be provided. The until_id parameter takes precedence if it is also specified. (optional)
     * @param expansions A comma separated list of fields to expand. (optional)
     * @param tweetFields A comma separated list of Tweet fields to display. (optional)
     * @param userFields A comma separated list of User fields to display. (optional)
     * @param mediaFields A comma separated list of Media fields to display. (optional)
     * @param placeFields A comma separated list of Place fields to display. (optional)
     * @param pollFields A comma separated list of Poll fields to display. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdTweetsAsync(String id, String sinceId, String untilId, Integer maxResults, Set<String> exclude, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> expansions, Set<String> tweetFields, Set<String> userFields, Set<String> mediaFields, Set<String> placeFields, Set<String> pollFields, final ApiCallback<GenericTweetsTimelineResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdTweetsValidateBeforeCall(id, sinceId, untilId, maxResults, exclude, paginationToken, startTime, endTime, expansions, tweetFields, userFields, mediaFields, placeFields, pollFields, _callback);
        Type localVarReturnType = new TypeToken<GenericTweetsTimelineResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdUnlike
     * @param id The ID of the user that is requesting to unlike the tweet (required)
     * @param tweetId The ID of the tweet that the user is requesting to unlike (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnlikeCall(String id, String tweetId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/likes/{tweet_id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "tweet_id" + "\\}", localVarApiClient.escapeString(tweetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdUnlikeValidateBeforeCall(String id, String tweetId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdUnlike(Async)");
        }
        
        // verify the required parameter 'tweetId' is set
        if (tweetId == null) {
            throw new ApiException("Missing the required parameter 'tweetId' when calling usersIdUnlike(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdUnlikeCall(id, tweetId, _callback);
        return localVarCall;

    }

    /**
     * Causes the user (in the path) to unlike the specified tweet
     * Causes the user (in the path) to unlike the specified tweet. The user must match the user context authorizing the request
     * @param id The ID of the user that is requesting to unlike the tweet (required)
     * @param tweetId The ID of the tweet that the user is requesting to unlike (required)
     * @return UsersLikesDeleteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersLikesDeleteResponse usersIdUnlike(String id, String tweetId) throws ApiException {
      ApiResponse<UsersLikesDeleteResponse> localVarResp = usersIdUnlikeWithHttpInfo(id, tweetId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersLikesDeleteResponse usersIdUnlike(Integer retries, String id, String tweetId) throws ApiException {
        UsersLikesDeleteResponse localVarResp;
        try{
          localVarResp = usersIdUnlike(id, tweetId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdUnlike(retries - 1, id, tweetId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Causes the user (in the path) to unlike the specified tweet
     * Causes the user (in the path) to unlike the specified tweet. The user must match the user context authorizing the request
     * @param id The ID of the user that is requesting to unlike the tweet (required)
     * @param tweetId The ID of the tweet that the user is requesting to unlike (required)
     * @return ApiResponse&lt;UsersLikesDeleteResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersLikesDeleteResponse> usersIdUnlikeWithHttpInfo(String id, String tweetId) throws ApiException {
        okhttp3.Call localVarCall = usersIdUnlikeValidateBeforeCall(id, tweetId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersLikesDeleteResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Causes the user (in the path) to unlike the specified tweet (asynchronously)
     * Causes the user (in the path) to unlike the specified tweet. The user must match the user context authorizing the request
     * @param id The ID of the user that is requesting to unlike the tweet (required)
     * @param tweetId The ID of the tweet that the user is requesting to unlike (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnlikeAsync(String id, String tweetId, final ApiCallback<UsersLikesDeleteResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdUnlikeValidateBeforeCall(id, tweetId, _callback);
        Type localVarReturnType = new TypeToken<UsersLikesDeleteResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for usersIdUnretweets
     * @param id The ID of the user that is requesting to unretweet the tweet (required)
     * @param sourceTweetId The ID of the tweet that the user is requesting to unretweet (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnretweetsCall(String id, String sourceTweetId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2/users/{id}/retweets/{source_tweet_id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "source_tweet_id" + "\\}", localVarApiClient.escapeString(sourceTweetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/problem+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2UserToken", "UserToken" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, reduceAuthNames(localVarAuthNames), _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call usersIdUnretweetsValidateBeforeCall(String id, String sourceTweetId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdUnretweets(Async)");
        }
        
        // verify the required parameter 'sourceTweetId' is set
        if (sourceTweetId == null) {
            throw new ApiException("Missing the required parameter 'sourceTweetId' when calling usersIdUnretweets(Async)");
        }
        

        okhttp3.Call localVarCall = usersIdUnretweetsCall(id, sourceTweetId, _callback);
        return localVarCall;

    }

    /**
     * Causes the user (in the path) to unretweet the specified tweet
     * Causes the user (in the path) to unretweet the specified tweet. The user must match the user context authorizing the request
     * @param id The ID of the user that is requesting to unretweet the tweet (required)
     * @param sourceTweetId The ID of the tweet that the user is requesting to unretweet (required)
     * @return UsersRetweetsDeleteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public UsersRetweetsDeleteResponse usersIdUnretweets(String id, String sourceTweetId) throws ApiException {
      ApiResponse<UsersRetweetsDeleteResponse> localVarResp = usersIdUnretweetsWithHttpInfo(id, sourceTweetId);
      return localVarResp != null ? localVarResp.getData() : null;
    }

   /**
    * Calls the API using a retry mechanism to handle rate limits errors.
    *
    */
    public UsersRetweetsDeleteResponse usersIdUnretweets(Integer retries, String id, String sourceTweetId) throws ApiException {
        UsersRetweetsDeleteResponse localVarResp;
        try{
          localVarResp = usersIdUnretweets(id, sourceTweetId);
        } catch (ApiException e) {
          if(handleRateLimit(e, retries)) {
            return usersIdUnretweets(retries - 1, id, sourceTweetId);
          } else {
            throw e;
          }
        }
        return localVarResp;
    }

    /**
     * Causes the user (in the path) to unretweet the specified tweet
     * Causes the user (in the path) to unretweet the specified tweet. The user must match the user context authorizing the request
     * @param id The ID of the user that is requesting to unretweet the tweet (required)
     * @param sourceTweetId The ID of the tweet that the user is requesting to unretweet (required)
     * @return ApiResponse&lt;UsersRetweetsDeleteResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersRetweetsDeleteResponse> usersIdUnretweetsWithHttpInfo(String id, String sourceTweetId) throws ApiException {
        okhttp3.Call localVarCall = usersIdUnretweetsValidateBeforeCall(id, sourceTweetId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersRetweetsDeleteResponse>(){}.getType();
            return localVarApiClient.execute(localVarCall, localVarReturnType);
        } catch (ApiException e) {
            e.setErrorObject(localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<com.twitter.clientlib.model.ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    /**
     * Causes the user (in the path) to unretweet the specified tweet (asynchronously)
     * Causes the user (in the path) to unretweet the specified tweet. The user must match the user context authorizing the request
     * @param id The ID of the user that is requesting to unretweet the tweet (required)
     * @param sourceTweetId The ID of the tweet that the user is requesting to unretweet (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request was successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> The request has failed. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call usersIdUnretweetsAsync(String id, String sourceTweetId, final ApiCallback<UsersRetweetsDeleteResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = usersIdUnretweetsValidateBeforeCall(id, sourceTweetId, _callback);
        Type localVarReturnType = new TypeToken<UsersRetweetsDeleteResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
