/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.model.Error;
import com.twitter.clientlib.model.Problem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import javax.ws.rs.core.GenericType;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

import com.twitter.clientlib.JSON;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ProblemOrError extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ProblemOrError.class.getName());

    public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
        @SuppressWarnings("unchecked")
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ProblemOrError.class.isAssignableFrom(type.getRawType())) {
                return null; // this class only serializes 'ProblemOrError' and its subtypes
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Error> adapterError = gson.getDelegateAdapter(this, TypeToken.get(Error.class));
            final TypeAdapter<Problem> adapterProblem = gson.getDelegateAdapter(this, TypeToken.get(Problem.class));

            return (TypeAdapter<T>) new TypeAdapter<ProblemOrError>() {
                @Override
                public void write(JsonWriter out, ProblemOrError value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }

                    // check if the actual instance is of the type `Error`
                    if (value.getActualInstance() instanceof Error) {
                        JsonObject obj = adapterError.toJsonTree((Error)value.getActualInstance()).getAsJsonObject();
                        elementAdapter.write(out, obj);
                        return;
                    }

                    // check if the actual instance is of the type `Problem`
                    if (value.getActualInstance() instanceof Problem) {
                        JsonObject obj = adapterProblem.toJsonTree((Problem)value.getActualInstance()).getAsJsonObject();
                        elementAdapter.write(out, obj);
                        return;
                    }

                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: Error, Problem");
                }

                @Override
                public ProblemOrError read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonObject jsonObject = elementAdapter.read(in).getAsJsonObject();

                    int match = 0;
                    TypeAdapter actualAdapter = elementAdapter;

                    // deserialize Error
                    try {
                        // validate the JSON object to see if any excpetion is thrown
                        Error.validateJsonObject(jsonObject);
                        actualAdapter = adapterError;
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'Error'");
                    } catch (Exception e) {
                        // deserialization failed, continue
                        log.log(Level.FINER, "Input data does not match schema 'Error'", e);
                    }

                    // deserialize Problem
                    try {
                        // validate the JSON object to see if any excpetion is thrown
                        Problem.validateJsonObject(jsonObject);
                        actualAdapter = adapterProblem;
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'Problem'");
                    } catch (Exception e) {
                        // deserialization failed, continue
                        log.log(Level.FINER, "Input data does not match schema 'Problem'", e);
                    }

                    if (match == 1) {
                        ProblemOrError ret = new ProblemOrError();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonObject));
                        return ret;
                    }

                    throw new IOException(String.format("Failed deserialization for ProblemOrError: %d classes match result, expected 1. JSON: %s", match, jsonObject.toString()));
                }
            }.nullSafe();
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public ProblemOrError() {
        super("oneOf", Boolean.FALSE);
    }

    public ProblemOrError(Error o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public ProblemOrError(Problem o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("Error", new GenericType<Error>() {
        });
        schemas.put("Problem", new GenericType<Problem>() {
        });
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return ProblemOrError.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * Error, Problem
     *
     * It could be an instance of the 'oneOf' schemas.
     * The oneOf child schemas may themselves be a composed schema (allOf, anyOf, oneOf).
     */
    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof Error) {
            super.setActualInstance(instance);
            return;
        }

        if (instance instanceof Problem) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be Error, Problem");
    }

    /**
     * Get the actual instance, which can be the following:
     * Error, Problem
     *
     * @return The actual instance (Error, Problem)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `Error`. If the actual instance is not `Error`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `Error`
     * @throws ClassCastException if the instance is not `Error`
     */
    public Error getError() throws ClassCastException {
        return (Error)super.getActualInstance();
    }

    /**
     * Get the actual instance of `Problem`. If the actual instance is not `Problem`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `Problem`
     * @throws ClassCastException if the instance is not `Problem`
     */
    public Problem getProblem() throws ClassCastException {
        return (Problem)super.getActualInstance();
    }


 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ProblemOrError
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
    // validate oneOf schemas one by one
    int validCount = 0;
    // validate the json string with Error
    try {
      Error.validateJsonObject(jsonObj);
      validCount++;
    } catch (Exception e) {
      // continue to the next one
    }
    // validate the json string with Problem
    try {
      Problem.validateJsonObject(jsonObj);
      validCount++;
    } catch (Exception e) {
      // continue to the next one
    }
    if (validCount != 1) {
      throw new IOException(String.format("The JSON string is invalid for ProblemOrError with oneOf schemas: Error, Problem. %d class(es) match the result, expected 1. JSON: %s", validCount, jsonObj.toString()));
    }
  }

 /**
  * Create an instance of ProblemOrError given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ProblemOrError
  * @throws IOException if the JSON string is invalid with respect to ProblemOrError
  */
  public static ProblemOrError fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ProblemOrError.class);
  }

 /**
  * Convert an instance of ProblemOrError to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

