/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Poll options for a Tweet with a poll. This is mutually exclusive from Media and Quote Tweet Id.")
public class CreateTweetRequestPoll {
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private List<String> options = null;
    public static final String SERIALIZED_NAME_DURATION_MINUTES = "duration_minutes";
    @SerializedName(value="duration_minutes")
    private Integer durationMinutes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateTweetRequestPoll options(List<String> options) {
        this.options = options;
        return this;
    }

    public CreateTweetRequestPoll addOptionsItem(String optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public CreateTweetRequestPoll durationMinutes(Integer durationMinutes) {
        this.durationMinutes = durationMinutes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Duration of the poll in minutes.")
    public Integer getDurationMinutes() {
        return this.durationMinutes;
    }

    public void setDurationMinutes(Integer durationMinutes) {
        this.durationMinutes = durationMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTweetRequestPoll createTweetRequestPoll = (CreateTweetRequestPoll)o;
        return Objects.equals(this.options, createTweetRequestPoll.options) && Objects.equals(this.durationMinutes, createTweetRequestPoll.durationMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.options, this.durationMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTweetRequestPoll {\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    durationMinutes: ").append(this.toIndentedString(this.durationMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `options` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPTIONS).toString()));
        }
    }

    public static CreateTweetRequestPoll fromJson(String jsonString) throws IOException {
        return (CreateTweetRequestPoll)JSON.getGson().fromJson(jsonString, CreateTweetRequestPoll.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_DURATION_MINUTES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateTweetRequestPoll.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateTweetRequestPoll.class));
            return new TypeAdapter<CreateTweetRequestPoll>(){

                public void write(JsonWriter out, CreateTweetRequestPoll value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateTweetRequestPoll read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateTweetRequestPoll.validateJsonObject(jsonObj);
                    return (CreateTweetRequestPoll)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

