/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.ModelList;
import com.twitter.clientlib.model.MultiListResponseMeta;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.SingleListLookupResponseIncludes;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class MultiListResponse {
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private List<ModelList> data = null;
    public static final String SERIALIZED_NAME_INCLUDES = "includes";
    @SerializedName(value="includes")
    private SingleListLookupResponseIncludes includes;
    public static final String SERIALIZED_NAME_META = "meta";
    @SerializedName(value="meta")
    private MultiListResponseMeta meta;
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<Problem> errors = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MultiListResponse data(List<ModelList> data) {
        this.data = data;
        return this;
    }

    public MultiListResponse addDataItem(ModelList dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<ModelList>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<ModelList> getData() {
        return this.data;
    }

    public void setData(List<ModelList> data) {
        this.data = data;
    }

    public MultiListResponse includes(SingleListLookupResponseIncludes includes) {
        this.includes = includes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SingleListLookupResponseIncludes getIncludes() {
        return this.includes;
    }

    public void setIncludes(SingleListLookupResponseIncludes includes) {
        this.includes = includes;
    }

    public MultiListResponse meta(MultiListResponseMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MultiListResponseMeta getMeta() {
        return this.meta;
    }

    public void setMeta(MultiListResponseMeta meta) {
        this.meta = meta;
    }

    public MultiListResponse errors(List<Problem> errors) {
        this.errors = errors;
        return this;
    }

    public MultiListResponse addErrorsItem(Problem errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<Problem>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<Problem> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Problem> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiListResponse multiListResponse = (MultiListResponse)o;
        return Objects.equals(this.data, multiListResponse.data) && Objects.equals(this.includes, multiListResponse.includes) && Objects.equals(this.meta, multiListResponse.meta) && Objects.equals(this.errors, multiListResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.includes, this.meta, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultiListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    includes: ").append(this.toIndentedString(this.includes)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayerrors;
        JsonArray jsonArraydata = jsonObj.getAsJsonArray(SERIALIZED_NAME_DATA);
        if (jsonArraydata != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DATA).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `data` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA).toString()));
            }
            for (int i = 0; i < jsonArraydata.size(); ++i) {
                ModelList.validateJsonObject(jsonArraydata.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INCLUDES) != null) {
            SingleListLookupResponseIncludes.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INCLUDES));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_META) != null) {
            MultiListResponseMeta.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_META));
        }
        if ((jsonArrayerrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_ERRORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `errors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERRORS).toString()));
            }
            for (int i = 0; i < jsonArrayerrors.size(); ++i) {
                Problem.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
            }
        }
    }

    public static MultiListResponse fromJson(String jsonString) throws IOException {
        return (MultiListResponse)JSON.getGson().fromJson(jsonString, MultiListResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_INCLUDES);
        openapiFields.add(SERIALIZED_NAME_META);
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MultiListResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MultiListResponse.class));
            return new TypeAdapter<MultiListResponse>(){

                public void write(JsonWriter out, MultiListResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MultiListResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MultiListResponse.validateJsonObject(jsonObj);
                    return (MultiListResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

