/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Geo;
import com.twitter.clientlib.model.PlaceType;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Place {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
    @SerializedName(value="country_code")
    private String countryCode;
    public static final String SERIALIZED_NAME_PLACE_TYPE = "place_type";
    @SerializedName(value="place_type")
    private PlaceType placeType;
    public static final String SERIALIZED_NAME_FULL_NAME = "full_name";
    @SerializedName(value="full_name")
    private String fullName;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_CONTAINED_WITHIN = "contained_within";
    @SerializedName(value="contained_within")
    private List<String> containedWithin = null;
    public static final String SERIALIZED_NAME_GEO = "geo";
    @SerializedName(value="geo")
    private Geo geo;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Place id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="f7eb2fa2fea288b1", required=true, value="The identifier for this place")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Place name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Lakewood", value="The human readable name of this place.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Place countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", value="A two-letter ISO 3166-1 alpha-2 country code")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Place placeType(PlaceType placeType) {
        this.placeType = placeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlaceType getPlaceType() {
        return this.placeType;
    }

    public void setPlaceType(PlaceType placeType) {
        this.placeType = placeType;
    }

    public Place fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Lakewood, CO", required=true, value="The full name of this place.")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Place country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="United States", value="The full name of the county in which this place exists.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Place containedWithin(List<String> containedWithin) {
        this.containedWithin = containedWithin;
        return this;
    }

    public Place addContainedWithinItem(String containedWithinItem) {
        if (this.containedWithin == null) {
            this.containedWithin = new ArrayList<String>();
        }
        this.containedWithin.add(containedWithinItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getContainedWithin() {
        return this.containedWithin;
    }

    public void setContainedWithin(List<String> containedWithin) {
        this.containedWithin = containedWithin;
    }

    public Place geo(Geo geo) {
        this.geo = geo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Geo getGeo() {
        return this.geo;
    }

    public void setGeo(Geo geo) {
        this.geo = geo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Place place = (Place)o;
        return Objects.equals(this.id, place.id) && Objects.equals(this.name, place.name) && Objects.equals(this.countryCode, place.countryCode) && Objects.equals((Object)this.placeType, (Object)place.placeType) && Objects.equals(this.fullName, place.fullName) && Objects.equals(this.country, place.country) && Objects.equals(this.containedWithin, place.containedWithin) && Objects.equals(this.geo, place.geo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.countryCode, this.placeType, this.fullName, this.country, this.containedWithin, this.geo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Place {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    placeType: ").append(this.toIndentedString((Object)this.placeType)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    containedWithin: ").append(this.toIndentedString(this.containedWithin)).append("\n");
        sb.append("    geo: ").append(this.toIndentedString(this.geo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FULL_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FULL_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `full_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FULL_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINED_WITHIN) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINED_WITHIN).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `contained_within` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINED_WITHIN).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GEO) != null) {
            Geo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GEO));
        }
    }

    public static Place fromJson(String jsonString) throws IOException {
        return (Place)JSON.getGson().fromJson(jsonString, Place.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_PLACE_TYPE);
        openapiFields.add(SERIALIZED_NAME_FULL_NAME);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_CONTAINED_WITHIN);
        openapiFields.add(SERIALIZED_NAME_GEO);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_FULL_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Place.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Place.class));
            return new TypeAdapter<Place>(){

                public void write(JsonWriter out, Place value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Place read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Place.validateJsonObject(jsonObj);
                    return (Place)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

