/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.URLImage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represent the portion of text recognized as a URL, and its start and end position within the text.")
public class UrlEntity {
    public static final String SERIALIZED_NAME_START = "start";
    @SerializedName(value="start")
    private Integer start;
    public static final String SERIALIZED_NAME_END = "end";
    @SerializedName(value="end")
    private Integer end;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private URL url;
    public static final String SERIALIZED_NAME_EXPANDED_URL = "expanded_url";
    @SerializedName(value="expanded_url")
    private URL expandedUrl;
    public static final String SERIALIZED_NAME_DISPLAY_URL = "display_url";
    @SerializedName(value="display_url")
    private String displayUrl;
    public static final String SERIALIZED_NAME_UNWOUND_URL = "unwound_url";
    @SerializedName(value="unwound_url")
    private URL unwoundUrl;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private Integer status;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_IMAGES = "images";
    @SerializedName(value="images")
    private List<URLImage> images = null;
    public static final String SERIALIZED_NAME_MEDIA_KEY = "media_key";
    @SerializedName(value="media_key")
    private String mediaKey;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UrlEntity start(Integer start) {
        this.start = start;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="50", required=true, value="Index (zero-based) at which position this entity starts.  The index is inclusive.")
    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public UrlEntity end(Integer end) {
        this.end = end;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="61", required=true, value="Index (zero-based) at which position this entity ends.  The index is exclusive.")
    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public UrlEntity url(URL url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public UrlEntity expandedUrl(URL expandedUrl) {
        this.expandedUrl = expandedUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public URL getExpandedUrl() {
        return this.expandedUrl;
    }

    public void setExpandedUrl(URL expandedUrl) {
        this.expandedUrl = expandedUrl;
    }

    public UrlEntity displayUrl(String displayUrl) {
        this.displayUrl = displayUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="twittercommunity.com/t/introducing-\u2026", value="The URL as displayed in the Twitter client.")
    public String getDisplayUrl() {
        return this.displayUrl;
    }

    public void setDisplayUrl(String displayUrl) {
        this.displayUrl = displayUrl;
    }

    public UrlEntity unwoundUrl(URL unwoundUrl) {
        this.unwoundUrl = unwoundUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://twittercommunity.com/t/introducing-the-v2-follow-lookup-endpoints/147118", value="Fully resolved url")
    public URL getUnwoundUrl() {
        return this.unwoundUrl;
    }

    public void setUnwoundUrl(URL unwoundUrl) {
        this.unwoundUrl = unwoundUrl;
    }

    public UrlEntity status(Integer status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HTTP Status Code.")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public UrlEntity title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Introducing the v2 follow lookup endpoints", value="Title of the page the URL points to.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UrlEntity description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is a description of the website.", value="Description of the URL landing page.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UrlEntity images(List<URLImage> images) {
        this.images = images;
        return this;
    }

    public UrlEntity addImagesItem(URLImage imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<URLImage>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<URLImage> getImages() {
        return this.images;
    }

    public void setImages(List<URLImage> images) {
        this.images = images;
    }

    public UrlEntity mediaKey(String mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Media Key identifier for this attachment.")
    public String getMediaKey() {
        return this.mediaKey;
    }

    public void setMediaKey(String mediaKey) {
        this.mediaKey = mediaKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlEntity urlEntity = (UrlEntity)o;
        return Objects.equals(this.start, urlEntity.start) && Objects.equals(this.end, urlEntity.end) && Objects.equals(this.url, urlEntity.url) && Objects.equals(this.expandedUrl, urlEntity.expandedUrl) && Objects.equals(this.displayUrl, urlEntity.displayUrl) && Objects.equals(this.unwoundUrl, urlEntity.unwoundUrl) && Objects.equals(this.status, urlEntity.status) && Objects.equals(this.title, urlEntity.title) && Objects.equals(this.description, urlEntity.description) && Objects.equals(this.images, urlEntity.images) && Objects.equals(this.mediaKey, urlEntity.mediaKey);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.url, this.expandedUrl, this.displayUrl, this.unwoundUrl, this.status, this.title, this.description, this.images, this.mediaKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UrlEntity {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    expandedUrl: ").append(this.toIndentedString(this.expandedUrl)).append("\n");
        sb.append("    displayUrl: ").append(this.toIndentedString(this.displayUrl)).append("\n");
        sb.append("    unwoundUrl: ").append(this.toIndentedString(this.unwoundUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    mediaKey: ").append(this.toIndentedString(this.mediaKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISPLAY_URL) != null && !jsonObj.get(SERIALIZED_NAME_DISPLAY_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `display_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISPLAY_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNWOUND_URL) != null && !jsonObj.get(SERIALIZED_NAME_UNWOUND_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unwound_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNWOUND_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        JsonArray jsonArrayimages = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGES);
        if (jsonArrayimages != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `images` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGES).toString()));
            }
            for (int i = 0; i < jsonArrayimages.size(); ++i) {
                URLImage.validateJsonObject(jsonArrayimages.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MEDIA_KEY) != null && !jsonObj.get(SERIALIZED_NAME_MEDIA_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `media_key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEDIA_KEY).toString()));
        }
    }

    public static UrlEntity fromJson(String jsonString) throws IOException {
        return (UrlEntity)JSON.getGson().fromJson(jsonString, UrlEntity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_START);
        openapiFields.add(SERIALIZED_NAME_END);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_EXPANDED_URL);
        openapiFields.add(SERIALIZED_NAME_DISPLAY_URL);
        openapiFields.add(SERIALIZED_NAME_UNWOUND_URL);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_IMAGES);
        openapiFields.add(SERIALIZED_NAME_MEDIA_KEY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_START);
        openapiRequiredFields.add(SERIALIZED_NAME_END);
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UrlEntity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UrlEntity.class));
            return new TypeAdapter<UrlEntity>(){

                public void write(JsonWriter out, UrlEntity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UrlEntity read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UrlEntity.validateJsonObject(jsonObj);
                    return (UrlEntity)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

