/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.model.SpaceTopics;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.twitter.clientlib.JSON;

/**
 * 
 */
@ApiModel(description = "")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Space {
  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_CREATOR_ID = "creator_id";
  @SerializedName(SERIALIZED_NAME_CREATOR_ID)
  private String creatorId;

  public static final String SERIALIZED_NAME_ENDED_AT = "ended_at";
  @SerializedName(SERIALIZED_NAME_ENDED_AT)
  private OffsetDateTime endedAt;

  public static final String SERIALIZED_NAME_HOST_IDS = "host_ids";
  @SerializedName(SERIALIZED_NAME_HOST_IDS)
  private List<String> hostIds = null;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_INVITED_USER_IDS = "invited_user_ids";
  @SerializedName(SERIALIZED_NAME_INVITED_USER_IDS)
  private List<String> invitedUserIds = null;

  public static final String SERIALIZED_NAME_IS_TICKETED = "is_ticketed";
  @SerializedName(SERIALIZED_NAME_IS_TICKETED)
  private Boolean isTicketed;

  public static final String SERIALIZED_NAME_LANG = "lang";
  @SerializedName(SERIALIZED_NAME_LANG)
  private String lang;

  public static final String SERIALIZED_NAME_PARTICIPANT_COUNT = "participant_count";
  @SerializedName(SERIALIZED_NAME_PARTICIPANT_COUNT)
  private Integer participantCount;

  public static final String SERIALIZED_NAME_SCHEDULED_START = "scheduled_start";
  @SerializedName(SERIALIZED_NAME_SCHEDULED_START)
  private OffsetDateTime scheduledStart;

  public static final String SERIALIZED_NAME_SPEAKER_IDS = "speaker_ids";
  @SerializedName(SERIALIZED_NAME_SPEAKER_IDS)
  private List<String> speakerIds = null;

  public static final String SERIALIZED_NAME_STARTED_AT = "started_at";
  @SerializedName(SERIALIZED_NAME_STARTED_AT)
  private OffsetDateTime startedAt;

  /**
   * The current state of the Space.
   */
  @JsonAdapter(StateEnum.Adapter.class)
  public enum StateEnum {
    LIVE("live"),
    
    SCHEDULED("scheduled"),
    
    ENDED("ended");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StateEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StateEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StateEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StateEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATE = "state";
  @SerializedName(SERIALIZED_NAME_STATE)
  private StateEnum state;

  public static final String SERIALIZED_NAME_SUBSCRIBER_COUNT = "subscriber_count";
  @SerializedName(SERIALIZED_NAME_SUBSCRIBER_COUNT)
  private Integer subscriberCount;

  public static final String SERIALIZED_NAME_TITLE = "title";
  @SerializedName(SERIALIZED_NAME_TITLE)
  private String title;

  public static final String SERIALIZED_NAME_TOPICS = "topics";
  @SerializedName(SERIALIZED_NAME_TOPICS)
  private List<SpaceTopics> topics = null;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public Space() { 
  }

  public Space createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Creation time of the Space.
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2021-07-06T18:40:40Z", value = "Creation time of the Space.")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Space creatorId(String creatorId) {
    
    this.creatorId = creatorId;
    return this;
  }

   /**
   * Unique identifier of this User. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.
   * @return creatorId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2244994945", value = "Unique identifier of this User. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")

  public String getCreatorId() {
    return creatorId;
  }


  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }


  public Space endedAt(OffsetDateTime endedAt) {
    
    this.endedAt = endedAt;
    return this;
  }

   /**
   * End time of the Space.
   * @return endedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2021-07-06T18:40:40Z", value = "End time of the Space.")

  public OffsetDateTime getEndedAt() {
    return endedAt;
  }


  public void setEndedAt(OffsetDateTime endedAt) {
    this.endedAt = endedAt;
  }


  public Space hostIds(List<String> hostIds) {
    
    this.hostIds = hostIds;
    return this;
  }

  public Space addHostIdsItem(String hostIdsItem) {
    if (this.hostIds == null) {
      this.hostIds = new ArrayList<>();
    }
    this.hostIds.add(hostIdsItem);
    return this;
  }

   /**
   * The user ids for the hosts of the Space.
   * @return hostIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The user ids for the hosts of the Space.")

  public List<String> getHostIds() {
    return hostIds;
  }


  public void setHostIds(List<String> hostIds) {
    this.hostIds = hostIds;
  }


  public Space id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of this Space.
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "1SLjjRYNejbKM", required = true, value = "The unique identifier of this Space.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public Space invitedUserIds(List<String> invitedUserIds) {
    
    this.invitedUserIds = invitedUserIds;
    return this;
  }

  public Space addInvitedUserIdsItem(String invitedUserIdsItem) {
    if (this.invitedUserIds == null) {
      this.invitedUserIds = new ArrayList<>();
    }
    this.invitedUserIds.add(invitedUserIdsItem);
    return this;
  }

   /**
   * An array of user ids for people who were invited to a Space.
   * @return invitedUserIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of user ids for people who were invited to a Space.")

  public List<String> getInvitedUserIds() {
    return invitedUserIds;
  }


  public void setInvitedUserIds(List<String> invitedUserIds) {
    this.invitedUserIds = invitedUserIds;
  }


  public Space isTicketed(Boolean isTicketed) {
    
    this.isTicketed = isTicketed;
    return this;
  }

   /**
   * Denotes if the Space is a ticketed Space.
   * @return isTicketed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Denotes if the Space is a ticketed Space.")

  public Boolean getIsTicketed() {
    return isTicketed;
  }


  public void setIsTicketed(Boolean isTicketed) {
    this.isTicketed = isTicketed;
  }


  public Space lang(String lang) {
    
    this.lang = lang;
    return this;
  }

   /**
   * The language of the Space.
   * @return lang
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "en", value = "The language of the Space.")

  public String getLang() {
    return lang;
  }


  public void setLang(String lang) {
    this.lang = lang;
  }


  public Space participantCount(Integer participantCount) {
    
    this.participantCount = participantCount;
    return this;
  }

   /**
   * The number of participants in a Space.
   * @return participantCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "The number of participants in a Space.")

  public Integer getParticipantCount() {
    return participantCount;
  }


  public void setParticipantCount(Integer participantCount) {
    this.participantCount = participantCount;
  }


  public Space scheduledStart(OffsetDateTime scheduledStart) {
    
    this.scheduledStart = scheduledStart;
    return this;
  }

   /**
   * A date time stamp for when a Space is scheduled to begin.
   * @return scheduledStart
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2021-07-06T18:40:40Z", value = "A date time stamp for when a Space is scheduled to begin.")

  public OffsetDateTime getScheduledStart() {
    return scheduledStart;
  }


  public void setScheduledStart(OffsetDateTime scheduledStart) {
    this.scheduledStart = scheduledStart;
  }


  public Space speakerIds(List<String> speakerIds) {
    
    this.speakerIds = speakerIds;
    return this;
  }

  public Space addSpeakerIdsItem(String speakerIdsItem) {
    if (this.speakerIds == null) {
      this.speakerIds = new ArrayList<>();
    }
    this.speakerIds.add(speakerIdsItem);
    return this;
  }

   /**
   * An array of user ids for people who were speakers in a Space.
   * @return speakerIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of user ids for people who were speakers in a Space.")

  public List<String> getSpeakerIds() {
    return speakerIds;
  }


  public void setSpeakerIds(List<String> speakerIds) {
    this.speakerIds = speakerIds;
  }


  public Space startedAt(OffsetDateTime startedAt) {
    
    this.startedAt = startedAt;
    return this;
  }

   /**
   * When the Space was started as a date string.
   * @return startedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "When the Space was started as a date string.")

  public OffsetDateTime getStartedAt() {
    return startedAt;
  }


  public void setStartedAt(OffsetDateTime startedAt) {
    this.startedAt = startedAt;
  }


  public Space state(StateEnum state) {
    
    this.state = state;
    return this;
  }

   /**
   * The current state of the Space.
   * @return state
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "live", required = true, value = "The current state of the Space.")

  public StateEnum getState() {
    return state;
  }


  public void setState(StateEnum state) {
    this.state = state;
  }


  public Space subscriberCount(Integer subscriberCount) {
    
    this.subscriberCount = subscriberCount;
    return this;
  }

   /**
   * The number of people who have either purchased a ticket or set a reminder for this Space.
   * @return subscriberCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "The number of people who have either purchased a ticket or set a reminder for this Space.")

  public Integer getSubscriberCount() {
    return subscriberCount;
  }


  public void setSubscriberCount(Integer subscriberCount) {
    this.subscriberCount = subscriberCount;
  }


  public Space title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * The title of the Space.
   * @return title
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Spaces are Awesome", value = "The title of the Space.")

  public String getTitle() {
    return title;
  }


  public void setTitle(String title) {
    this.title = title;
  }


  public Space topics(List<SpaceTopics> topics) {
    
    this.topics = topics;
    return this;
  }

  public Space addTopicsItem(SpaceTopics topicsItem) {
    if (this.topics == null) {
      this.topics = new ArrayList<>();
    }
    this.topics.add(topicsItem);
    return this;
  }

   /**
   * The topics of a Space, as selected by its creator.
   * @return topics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The topics of a Space, as selected by its creator.")

  public List<SpaceTopics> getTopics() {
    return topics;
  }


  public void setTopics(List<SpaceTopics> topics) {
    this.topics = topics;
  }


  public Space updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * When the Space was last updated.
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "When the Space was last updated.")

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Space space = (Space) o;
    return Objects.equals(this.createdAt, space.createdAt) &&
        Objects.equals(this.creatorId, space.creatorId) &&
        Objects.equals(this.endedAt, space.endedAt) &&
        Objects.equals(this.hostIds, space.hostIds) &&
        Objects.equals(this.id, space.id) &&
        Objects.equals(this.invitedUserIds, space.invitedUserIds) &&
        Objects.equals(this.isTicketed, space.isTicketed) &&
        Objects.equals(this.lang, space.lang) &&
        Objects.equals(this.participantCount, space.participantCount) &&
        Objects.equals(this.scheduledStart, space.scheduledStart) &&
        Objects.equals(this.speakerIds, space.speakerIds) &&
        Objects.equals(this.startedAt, space.startedAt) &&
        Objects.equals(this.state, space.state) &&
        Objects.equals(this.subscriberCount, space.subscriberCount) &&
        Objects.equals(this.title, space.title) &&
        Objects.equals(this.topics, space.topics) &&
        Objects.equals(this.updatedAt, space.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, creatorId, endedAt, hostIds, id, invitedUserIds, isTicketed, lang, participantCount, scheduledStart, speakerIds, startedAt, state, subscriberCount, title, topics, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Space {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    creatorId: ").append(toIndentedString(creatorId)).append("\n");
    sb.append("    endedAt: ").append(toIndentedString(endedAt)).append("\n");
    sb.append("    hostIds: ").append(toIndentedString(hostIds)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invitedUserIds: ").append(toIndentedString(invitedUserIds)).append("\n");
    sb.append("    isTicketed: ").append(toIndentedString(isTicketed)).append("\n");
    sb.append("    lang: ").append(toIndentedString(lang)).append("\n");
    sb.append("    participantCount: ").append(toIndentedString(participantCount)).append("\n");
    sb.append("    scheduledStart: ").append(toIndentedString(scheduledStart)).append("\n");
    sb.append("    speakerIds: ").append(toIndentedString(speakerIds)).append("\n");
    sb.append("    startedAt: ").append(toIndentedString(startedAt)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    subscriberCount: ").append(toIndentedString(subscriberCount)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    topics: ").append(toIndentedString(topics)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("created_at");
    openapiFields.add("creator_id");
    openapiFields.add("ended_at");
    openapiFields.add("host_ids");
    openapiFields.add("id");
    openapiFields.add("invited_user_ids");
    openapiFields.add("is_ticketed");
    openapiFields.add("lang");
    openapiFields.add("participant_count");
    openapiFields.add("scheduled_start");
    openapiFields.add("speaker_ids");
    openapiFields.add("started_at");
    openapiFields.add("state");
    openapiFields.add("subscriber_count");
    openapiFields.add("title");
    openapiFields.add("topics");
    openapiFields.add("updated_at");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("state");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Space
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
     // if (jsonObj == null) {
     //   if (Space.openapiRequiredFields.isEmpty()) {
     //     return;
     //   } else { // has required fields
     //     throw new IllegalArgumentException(String.format("The required field(s) %s in Space is not found in the empty JSON string", Space.openapiRequiredFields.toString()));
     //   }
     // }


      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Space.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("creator_id") != null && !jsonObj.get("creator_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `creator_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("creator_id").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("host_ids") != null && !jsonObj.get("host_ids").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `host_ids` to be an array in the JSON string but got `%s`", jsonObj.get("host_ids").toString()));
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("invited_user_ids") != null && !jsonObj.get("invited_user_ids").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `invited_user_ids` to be an array in the JSON string but got `%s`", jsonObj.get("invited_user_ids").toString()));
      }
      if (jsonObj.get("lang") != null && !jsonObj.get("lang").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lang` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lang").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("speaker_ids") != null && !jsonObj.get("speaker_ids").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `speaker_ids` to be an array in the JSON string but got `%s`", jsonObj.get("speaker_ids").toString()));
      }
      if (jsonObj.get("state") != null && !jsonObj.get("state").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `state` to be a primitive type in the JSON string but got `%s`", jsonObj.get("state").toString()));
      }
      if (jsonObj.get("title") != null && !jsonObj.get("title").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get("title").toString()));
      }
      JsonArray jsonArraytopics = jsonObj.getAsJsonArray("topics");
      if (jsonArraytopics != null) {
        // ensure the json data is an array
        if (!jsonObj.get("topics").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `topics` to be an array in the JSON string but got `%s`", jsonObj.get("topics").toString()));
        }

        // validate the optional field `topics` (array)
        for (int i = 0; i < jsonArraytopics.size(); i++) {
          SpaceTopics.validateJsonObject(jsonArraytopics.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Space.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Space' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Space> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Space.class));

       return (TypeAdapter<T>) new TypeAdapter<Space>() {
           @Override
           public void write(JsonWriter out, Space value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Space read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Space given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Space
  * @throws IOException if the JSON string is invalid with respect to Space
  */
  public static Space fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Space.class);
  }

 /**
  * Convert an instance of Space to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

