/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.Get2SpacesByCreatorIdsResponse;
import com.twitter.clientlib.model.Get2SpacesIdBuyersResponse;
import com.twitter.clientlib.model.Get2SpacesIdResponse;
import com.twitter.clientlib.model.Get2SpacesIdTweetsResponse;
import com.twitter.clientlib.model.Get2SpacesResponse;
import com.twitter.clientlib.model.Get2SpacesSearchResponse;
import com.twitter.clientlib.model.ProblemOrError;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import okhttp3.Call;

public class SpacesApi
extends ApiCommon {
    private Call findSpaceByIdCall(String id, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (topicFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "topic.fields", topicFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findSpaceByIdValidateBeforeCall(String id, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findSpaceById(Async)");
        }
        Call localVarCall = this.findSpaceByIdCall(id, spaceFields, expansions, userFields, topicFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2SpacesIdResponse> findSpaceByIdWithHttpInfo(String id, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields) throws ApiException {
        Call localVarCall = this.findSpaceByIdValidateBeforeCall(id, spaceFields, expansions, userFields, topicFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2SpacesIdResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findSpaceByIdAsync(String id, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback<Get2SpacesIdResponse> _callback) throws ApiException {
        Call localVarCall = this.findSpaceByIdValidateBeforeCall(id, spaceFields, expansions, userFields, topicFields, _callback);
        Type localVarReturnType = new TypeToken<Get2SpacesIdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindSpaceByIdRequest findSpaceById(String id) {
        return new APIfindSpaceByIdRequest(id);
    }

    private Call findSpacesByCreatorIdsCall(List<String> userIds, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/by/creator_ids";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "user_ids", userIds));
        }
        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (topicFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "topic.fields", topicFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findSpacesByCreatorIdsValidateBeforeCall(List<String> userIds, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback _callback) throws ApiException {
        if (userIds == null) {
            throw new ApiException("Missing the required parameter 'userIds' when calling findSpacesByCreatorIds(Async)");
        }
        Call localVarCall = this.findSpacesByCreatorIdsCall(userIds, spaceFields, expansions, userFields, topicFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2SpacesByCreatorIdsResponse> findSpacesByCreatorIdsWithHttpInfo(List<String> userIds, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields) throws ApiException {
        Call localVarCall = this.findSpacesByCreatorIdsValidateBeforeCall(userIds, spaceFields, expansions, userFields, topicFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2SpacesByCreatorIdsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findSpacesByCreatorIdsAsync(List<String> userIds, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback<Get2SpacesByCreatorIdsResponse> _callback) throws ApiException {
        Call localVarCall = this.findSpacesByCreatorIdsValidateBeforeCall(userIds, spaceFields, expansions, userFields, topicFields, _callback);
        Type localVarReturnType = new TypeToken<Get2SpacesByCreatorIdsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindSpacesByCreatorIdsRequest findSpacesByCreatorIds(List<String> userIds) {
        return new APIfindSpacesByCreatorIdsRequest(userIds);
    }

    private Call findSpacesByIdsCall(List<String> ids, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "ids", ids));
        }
        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (topicFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "topic.fields", topicFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findSpacesByIdsValidateBeforeCall(List<String> ids, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback _callback) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findSpacesByIds(Async)");
        }
        Call localVarCall = this.findSpacesByIdsCall(ids, spaceFields, expansions, userFields, topicFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2SpacesResponse> findSpacesByIdsWithHttpInfo(List<String> ids, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields) throws ApiException {
        Call localVarCall = this.findSpacesByIdsValidateBeforeCall(ids, spaceFields, expansions, userFields, topicFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2SpacesResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findSpacesByIdsAsync(List<String> ids, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback<Get2SpacesResponse> _callback) throws ApiException {
        Call localVarCall = this.findSpacesByIdsValidateBeforeCall(ids, spaceFields, expansions, userFields, topicFields, _callback);
        Type localVarReturnType = new TypeToken<Get2SpacesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindSpacesByIdsRequest findSpacesByIds(List<String> ids) {
        return new APIfindSpacesByIdsRequest(ids);
    }

    private Call searchSpacesCall(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (state != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("state", state));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (spaceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "space.fields", spaceFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (topicFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "topic.fields", topicFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call searchSpacesValidateBeforeCall(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling searchSpaces(Async)");
        }
        Call localVarCall = this.searchSpacesCall(query, state, maxResults, spaceFields, expansions, userFields, topicFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2SpacesSearchResponse> searchSpacesWithHttpInfo(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields) throws ApiException {
        Call localVarCall = this.searchSpacesValidateBeforeCall(query, state, maxResults, spaceFields, expansions, userFields, topicFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2SpacesSearchResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call searchSpacesAsync(String query, String state, Integer maxResults, Set<String> spaceFields, Set<String> expansions, Set<String> userFields, Set<String> topicFields, ApiCallback<Get2SpacesSearchResponse> _callback) throws ApiException {
        Call localVarCall = this.searchSpacesValidateBeforeCall(query, state, maxResults, spaceFields, expansions, userFields, topicFields, _callback);
        Type localVarReturnType = new TypeToken<Get2SpacesSearchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsearchSpacesRequest searchSpaces(String query) {
        return new APIsearchSpacesRequest(query);
    }

    private Call spaceBuyersCall(String id, String paginationToken, Integer maxResults, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}/buyers".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call spaceBuyersValidateBeforeCall(String id, String paginationToken, Integer maxResults, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceBuyers(Async)");
        }
        Call localVarCall = this.spaceBuyersCall(id, paginationToken, maxResults, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2SpacesIdBuyersResponse> spaceBuyersWithHttpInfo(String id, String paginationToken, Integer maxResults, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.spaceBuyersValidateBeforeCall(id, paginationToken, maxResults, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2SpacesIdBuyersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call spaceBuyersAsync(String id, String paginationToken, Integer maxResults, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2SpacesIdBuyersResponse> _callback) throws ApiException {
        Call localVarCall = this.spaceBuyersValidateBeforeCall(id, paginationToken, maxResults, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2SpacesIdBuyersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIspaceBuyersRequest spaceBuyers(String id) {
        return new APIspaceBuyersRequest(id);
    }

    private Call spaceTweetsCall(String id, Integer maxResults, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}/tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call spaceTweetsValidateBeforeCall(String id, Integer maxResults, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceTweets(Async)");
        }
        Call localVarCall = this.spaceTweetsCall(id, maxResults, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2SpacesIdTweetsResponse> spaceTweetsWithHttpInfo(String id, Integer maxResults, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.spaceTweetsValidateBeforeCall(id, maxResults, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2SpacesIdTweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call spaceTweetsAsync(String id, Integer maxResults, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2SpacesIdTweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.spaceTweetsValidateBeforeCall(id, maxResults, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2SpacesIdTweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIspaceTweetsRequest spaceTweets(String id) {
        return new APIspaceTweetsRequest(id);
    }

    public class APIspaceTweetsRequest {
        private final String id;
        private Integer maxResults;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;
        private final Set<String> tweetFieldsAll = new HashSet<String>(Arrays.asList("attachments", "author_id", "context_annotations", "conversation_id", "created_at", "edit_controls", "edit_history_tweet_ids", "entities", "geo", "id", "in_reply_to_user_id", "lang", "non_public_metrics", "organic_metrics", "possibly_sensitive", "promoted_metrics", "public_metrics", "referenced_tweets", "reply_settings", "source", "text", "withheld"));
        private final Set<String> expansionsAll = new HashSet<String>(Arrays.asList("attachments.media_keys", "attachments.poll_ids", "author_id", "edit_history_tweet_ids", "entities.mentions.username", "geo.place_id", "in_reply_to_user_id", "referenced_tweets.id", "referenced_tweets.id.author_id"));
        private final Set<String> mediaFieldsAll = new HashSet<String>(Arrays.asList("alt_text", "duration_ms", "height", "media_key", "non_public_metrics", "organic_metrics", "preview_image_url", "promoted_metrics", "public_metrics", "type", "url", "variants", "width"));
        private final Set<String> pollFieldsAll = new HashSet<String>(Arrays.asList("duration_minutes", "end_datetime", "id", "options", "voting_status"));
        private final Set<String> userFieldsAll = new HashSet<String>(Arrays.asList("created_at", "description", "entities", "id", "location", "name", "pinned_tweet_id", "profile_image_url", "protected", "public_metrics", "url", "username", "verified", "withheld"));
        private final Set<String> placeFieldsAll = new HashSet<String>(Arrays.asList("contained_within", "country", "country_code", "full_name", "geo", "id", "name", "place_type"));
        private boolean isExclude = false;

        public APIspaceTweetsRequest excludeInputFields() {
            this.isExclude = true;
            return this;
        }

        private APIspaceTweetsRequest(String id) {
            this.id = id;
        }

        public APIspaceTweetsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIspaceTweetsRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIspaceTweetsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIspaceTweetsRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIspaceTweetsRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIspaceTweetsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIspaceTweetsRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpacesApi.this.spaceTweetsCall(this.id, this.maxResults, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2SpacesIdTweetsResponse execute() throws ApiException {
            this.tweetFields = SpacesApi.this.getFields("tweetFields", this.isExclude, this.tweetFields, this.tweetFieldsAll);
            this.expansions = SpacesApi.this.getFields("expansions", this.isExclude, this.expansions, this.expansionsAll);
            this.mediaFields = SpacesApi.this.getFields("mediaFields", this.isExclude, this.mediaFields, this.mediaFieldsAll);
            this.pollFields = SpacesApi.this.getFields("pollFields", this.isExclude, this.pollFields, this.pollFieldsAll);
            this.userFields = SpacesApi.this.getFields("userFields", this.isExclude, this.userFields, this.userFieldsAll);
            this.placeFields = SpacesApi.this.getFields("placeFields", this.isExclude, this.placeFields, this.placeFieldsAll);
            ApiResponse localVarResp = SpacesApi.this.spaceTweetsWithHttpInfo(this.id, this.maxResults, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2SpacesIdTweetsResponse)localVarResp.getData();
        }

        public Get2SpacesIdTweetsResponse execute(Integer retries) throws ApiException {
            Get2SpacesIdTweetsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (SpacesApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2SpacesIdTweetsResponse> executeWithHttpInfo() throws ApiException {
            return SpacesApi.this.spaceTweetsWithHttpInfo(this.id, this.maxResults, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2SpacesIdTweetsResponse> _callback) throws ApiException {
            return SpacesApi.this.spaceTweetsAsync(this.id, this.maxResults, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIspaceBuyersRequest {
        private final String id;
        private String paginationToken;
        private Integer maxResults;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;
        private final Set<String> userFieldsAll = new HashSet<String>(Arrays.asList("created_at", "description", "entities", "id", "location", "name", "pinned_tweet_id", "profile_image_url", "protected", "public_metrics", "url", "username", "verified", "withheld"));
        private final Set<String> expansionsAll = new HashSet<String>(Arrays.asList("pinned_tweet_id"));
        private final Set<String> tweetFieldsAll = new HashSet<String>(Arrays.asList("attachments", "author_id", "context_annotations", "conversation_id", "created_at", "edit_controls", "edit_history_tweet_ids", "entities", "geo", "id", "in_reply_to_user_id", "lang", "non_public_metrics", "organic_metrics", "possibly_sensitive", "promoted_metrics", "public_metrics", "referenced_tweets", "reply_settings", "source", "text", "withheld"));
        private boolean isExclude = false;

        public APIspaceBuyersRequest excludeInputFields() {
            this.isExclude = true;
            return this;
        }

        private APIspaceBuyersRequest(String id) {
            this.id = id;
        }

        public APIspaceBuyersRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIspaceBuyersRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIspaceBuyersRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIspaceBuyersRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIspaceBuyersRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpacesApi.this.spaceBuyersCall(this.id, this.paginationToken, this.maxResults, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2SpacesIdBuyersResponse execute() throws ApiException {
            this.userFields = SpacesApi.this.getFields("userFields", this.isExclude, this.userFields, this.userFieldsAll);
            this.expansions = SpacesApi.this.getFields("expansions", this.isExclude, this.expansions, this.expansionsAll);
            this.tweetFields = SpacesApi.this.getFields("tweetFields", this.isExclude, this.tweetFields, this.tweetFieldsAll);
            ApiResponse localVarResp = SpacesApi.this.spaceBuyersWithHttpInfo(this.id, this.paginationToken, this.maxResults, this.userFields, this.expansions, this.tweetFields);
            return (Get2SpacesIdBuyersResponse)localVarResp.getData();
        }

        public Get2SpacesIdBuyersResponse execute(Integer retries) throws ApiException {
            Get2SpacesIdBuyersResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (SpacesApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2SpacesIdBuyersResponse> executeWithHttpInfo() throws ApiException {
            return SpacesApi.this.spaceBuyersWithHttpInfo(this.id, this.paginationToken, this.maxResults, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2SpacesIdBuyersResponse> _callback) throws ApiException {
            return SpacesApi.this.spaceBuyersAsync(this.id, this.paginationToken, this.maxResults, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIsearchSpacesRequest {
        private final String query;
        private String state;
        private Integer maxResults;
        private Set<String> spaceFields;
        private Set<String> expansions;
        private Set<String> userFields;
        private Set<String> topicFields;
        private final Set<String> spaceFieldsAll = new HashSet<String>(Arrays.asList("created_at", "creator_id", "ended_at", "host_ids", "id", "invited_user_ids", "is_ticketed", "lang", "participant_count", "scheduled_start", "speaker_ids", "started_at", "state", "subscriber_count", "title", "topic_ids", "updated_at"));
        private final Set<String> expansionsAll = new HashSet<String>(Arrays.asList("creator_id", "host_ids", "invited_user_ids", "speaker_ids", "topic_ids"));
        private final Set<String> userFieldsAll = new HashSet<String>(Arrays.asList("created_at", "description", "entities", "id", "location", "name", "pinned_tweet_id", "profile_image_url", "protected", "public_metrics", "url", "username", "verified", "withheld"));
        private final Set<String> topicFieldsAll = new HashSet<String>(Arrays.asList("description", "id", "name"));
        private boolean isExclude = false;

        public APIsearchSpacesRequest excludeInputFields() {
            this.isExclude = true;
            return this;
        }

        private APIsearchSpacesRequest(String query) {
            this.query = query;
        }

        public APIsearchSpacesRequest state(String state) {
            this.state = state;
            return this;
        }

        public APIsearchSpacesRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIsearchSpacesRequest spaceFields(Set<String> spaceFields) {
            this.spaceFields = spaceFields;
            return this;
        }

        public APIsearchSpacesRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIsearchSpacesRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIsearchSpacesRequest topicFields(Set<String> topicFields) {
            this.topicFields = topicFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpacesApi.this.searchSpacesCall(this.query, this.state, this.maxResults, this.spaceFields, this.expansions, this.userFields, this.topicFields, _callback);
        }

        public Get2SpacesSearchResponse execute() throws ApiException {
            this.spaceFields = SpacesApi.this.getFields("spaceFields", this.isExclude, this.spaceFields, this.spaceFieldsAll);
            this.expansions = SpacesApi.this.getFields("expansions", this.isExclude, this.expansions, this.expansionsAll);
            this.userFields = SpacesApi.this.getFields("userFields", this.isExclude, this.userFields, this.userFieldsAll);
            this.topicFields = SpacesApi.this.getFields("topicFields", this.isExclude, this.topicFields, this.topicFieldsAll);
            ApiResponse localVarResp = SpacesApi.this.searchSpacesWithHttpInfo(this.query, this.state, this.maxResults, this.spaceFields, this.expansions, this.userFields, this.topicFields);
            return (Get2SpacesSearchResponse)localVarResp.getData();
        }

        public Get2SpacesSearchResponse execute(Integer retries) throws ApiException {
            Get2SpacesSearchResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (SpacesApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2SpacesSearchResponse> executeWithHttpInfo() throws ApiException {
            return SpacesApi.this.searchSpacesWithHttpInfo(this.query, this.state, this.maxResults, this.spaceFields, this.expansions, this.userFields, this.topicFields);
        }

        public Call executeAsync(ApiCallback<Get2SpacesSearchResponse> _callback) throws ApiException {
            return SpacesApi.this.searchSpacesAsync(this.query, this.state, this.maxResults, this.spaceFields, this.expansions, this.userFields, this.topicFields, _callback);
        }
    }

    public class APIfindSpacesByIdsRequest {
        private final List<String> ids;
        private Set<String> spaceFields;
        private Set<String> expansions;
        private Set<String> userFields;
        private Set<String> topicFields;
        private final Set<String> spaceFieldsAll = new HashSet<String>(Arrays.asList("created_at", "creator_id", "ended_at", "host_ids", "id", "invited_user_ids", "is_ticketed", "lang", "participant_count", "scheduled_start", "speaker_ids", "started_at", "state", "subscriber_count", "title", "topic_ids", "updated_at"));
        private final Set<String> expansionsAll = new HashSet<String>(Arrays.asList("creator_id", "host_ids", "invited_user_ids", "speaker_ids", "topic_ids"));
        private final Set<String> userFieldsAll = new HashSet<String>(Arrays.asList("created_at", "description", "entities", "id", "location", "name", "pinned_tweet_id", "profile_image_url", "protected", "public_metrics", "url", "username", "verified", "withheld"));
        private final Set<String> topicFieldsAll = new HashSet<String>(Arrays.asList("description", "id", "name"));
        private boolean isExclude = false;

        public APIfindSpacesByIdsRequest excludeInputFields() {
            this.isExclude = true;
            return this;
        }

        private APIfindSpacesByIdsRequest(List<String> ids) {
            this.ids = ids;
        }

        public APIfindSpacesByIdsRequest spaceFields(Set<String> spaceFields) {
            this.spaceFields = spaceFields;
            return this;
        }

        public APIfindSpacesByIdsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindSpacesByIdsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindSpacesByIdsRequest topicFields(Set<String> topicFields) {
            this.topicFields = topicFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpacesApi.this.findSpacesByIdsCall(this.ids, this.spaceFields, this.expansions, this.userFields, this.topicFields, _callback);
        }

        public Get2SpacesResponse execute() throws ApiException {
            this.spaceFields = SpacesApi.this.getFields("spaceFields", this.isExclude, this.spaceFields, this.spaceFieldsAll);
            this.expansions = SpacesApi.this.getFields("expansions", this.isExclude, this.expansions, this.expansionsAll);
            this.userFields = SpacesApi.this.getFields("userFields", this.isExclude, this.userFields, this.userFieldsAll);
            this.topicFields = SpacesApi.this.getFields("topicFields", this.isExclude, this.topicFields, this.topicFieldsAll);
            ApiResponse localVarResp = SpacesApi.this.findSpacesByIdsWithHttpInfo(this.ids, this.spaceFields, this.expansions, this.userFields, this.topicFields);
            return (Get2SpacesResponse)localVarResp.getData();
        }

        public Get2SpacesResponse execute(Integer retries) throws ApiException {
            Get2SpacesResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (SpacesApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2SpacesResponse> executeWithHttpInfo() throws ApiException {
            return SpacesApi.this.findSpacesByIdsWithHttpInfo(this.ids, this.spaceFields, this.expansions, this.userFields, this.topicFields);
        }

        public Call executeAsync(ApiCallback<Get2SpacesResponse> _callback) throws ApiException {
            return SpacesApi.this.findSpacesByIdsAsync(this.ids, this.spaceFields, this.expansions, this.userFields, this.topicFields, _callback);
        }
    }

    public class APIfindSpacesByCreatorIdsRequest {
        private final List<String> userIds;
        private Set<String> spaceFields;
        private Set<String> expansions;
        private Set<String> userFields;
        private Set<String> topicFields;
        private final Set<String> spaceFieldsAll = new HashSet<String>(Arrays.asList("created_at", "creator_id", "ended_at", "host_ids", "id", "invited_user_ids", "is_ticketed", "lang", "participant_count", "scheduled_start", "speaker_ids", "started_at", "state", "subscriber_count", "title", "topic_ids", "updated_at"));
        private final Set<String> expansionsAll = new HashSet<String>(Arrays.asList("creator_id", "host_ids", "invited_user_ids", "speaker_ids", "topic_ids"));
        private final Set<String> userFieldsAll = new HashSet<String>(Arrays.asList("created_at", "description", "entities", "id", "location", "name", "pinned_tweet_id", "profile_image_url", "protected", "public_metrics", "url", "username", "verified", "withheld"));
        private final Set<String> topicFieldsAll = new HashSet<String>(Arrays.asList("description", "id", "name"));
        private boolean isExclude = false;

        public APIfindSpacesByCreatorIdsRequest excludeInputFields() {
            this.isExclude = true;
            return this;
        }

        private APIfindSpacesByCreatorIdsRequest(List<String> userIds) {
            this.userIds = userIds;
        }

        public APIfindSpacesByCreatorIdsRequest spaceFields(Set<String> spaceFields) {
            this.spaceFields = spaceFields;
            return this;
        }

        public APIfindSpacesByCreatorIdsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindSpacesByCreatorIdsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindSpacesByCreatorIdsRequest topicFields(Set<String> topicFields) {
            this.topicFields = topicFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpacesApi.this.findSpacesByCreatorIdsCall(this.userIds, this.spaceFields, this.expansions, this.userFields, this.topicFields, _callback);
        }

        public Get2SpacesByCreatorIdsResponse execute() throws ApiException {
            this.spaceFields = SpacesApi.this.getFields("spaceFields", this.isExclude, this.spaceFields, this.spaceFieldsAll);
            this.expansions = SpacesApi.this.getFields("expansions", this.isExclude, this.expansions, this.expansionsAll);
            this.userFields = SpacesApi.this.getFields("userFields", this.isExclude, this.userFields, this.userFieldsAll);
            this.topicFields = SpacesApi.this.getFields("topicFields", this.isExclude, this.topicFields, this.topicFieldsAll);
            ApiResponse localVarResp = SpacesApi.this.findSpacesByCreatorIdsWithHttpInfo(this.userIds, this.spaceFields, this.expansions, this.userFields, this.topicFields);
            return (Get2SpacesByCreatorIdsResponse)localVarResp.getData();
        }

        public Get2SpacesByCreatorIdsResponse execute(Integer retries) throws ApiException {
            Get2SpacesByCreatorIdsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (SpacesApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2SpacesByCreatorIdsResponse> executeWithHttpInfo() throws ApiException {
            return SpacesApi.this.findSpacesByCreatorIdsWithHttpInfo(this.userIds, this.spaceFields, this.expansions, this.userFields, this.topicFields);
        }

        public Call executeAsync(ApiCallback<Get2SpacesByCreatorIdsResponse> _callback) throws ApiException {
            return SpacesApi.this.findSpacesByCreatorIdsAsync(this.userIds, this.spaceFields, this.expansions, this.userFields, this.topicFields, _callback);
        }
    }

    public class APIfindSpaceByIdRequest {
        private final String id;
        private Set<String> spaceFields;
        private Set<String> expansions;
        private Set<String> userFields;
        private Set<String> topicFields;
        private final Set<String> spaceFieldsAll = new HashSet<String>(Arrays.asList("created_at", "creator_id", "ended_at", "host_ids", "id", "invited_user_ids", "is_ticketed", "lang", "participant_count", "scheduled_start", "speaker_ids", "started_at", "state", "subscriber_count", "title", "topic_ids", "updated_at"));
        private final Set<String> expansionsAll = new HashSet<String>(Arrays.asList("creator_id", "host_ids", "invited_user_ids", "speaker_ids", "topic_ids"));
        private final Set<String> userFieldsAll = new HashSet<String>(Arrays.asList("created_at", "description", "entities", "id", "location", "name", "pinned_tweet_id", "profile_image_url", "protected", "public_metrics", "url", "username", "verified", "withheld"));
        private final Set<String> topicFieldsAll = new HashSet<String>(Arrays.asList("description", "id", "name"));
        private boolean isExclude = false;

        public APIfindSpaceByIdRequest excludeInputFields() {
            this.isExclude = true;
            return this;
        }

        private APIfindSpaceByIdRequest(String id) {
            this.id = id;
        }

        public APIfindSpaceByIdRequest spaceFields(Set<String> spaceFields) {
            this.spaceFields = spaceFields;
            return this;
        }

        public APIfindSpaceByIdRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindSpaceByIdRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindSpaceByIdRequest topicFields(Set<String> topicFields) {
            this.topicFields = topicFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpacesApi.this.findSpaceByIdCall(this.id, this.spaceFields, this.expansions, this.userFields, this.topicFields, _callback);
        }

        public Get2SpacesIdResponse execute() throws ApiException {
            this.spaceFields = SpacesApi.this.getFields("spaceFields", this.isExclude, this.spaceFields, this.spaceFieldsAll);
            this.expansions = SpacesApi.this.getFields("expansions", this.isExclude, this.expansions, this.expansionsAll);
            this.userFields = SpacesApi.this.getFields("userFields", this.isExclude, this.userFields, this.userFieldsAll);
            this.topicFields = SpacesApi.this.getFields("topicFields", this.isExclude, this.topicFields, this.topicFieldsAll);
            ApiResponse localVarResp = SpacesApi.this.findSpaceByIdWithHttpInfo(this.id, this.spaceFields, this.expansions, this.userFields, this.topicFields);
            return (Get2SpacesIdResponse)localVarResp.getData();
        }

        public Get2SpacesIdResponse execute(Integer retries) throws ApiException {
            Get2SpacesIdResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (SpacesApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2SpacesIdResponse> executeWithHttpInfo() throws ApiException {
            return SpacesApi.this.findSpaceByIdWithHttpInfo(this.id, this.spaceFields, this.expansions, this.userFields, this.topicFields);
        }

        public Call executeAsync(ApiCallback<Get2SpacesIdResponse> _callback) throws ApiException {
            return SpacesApi.this.findSpaceByIdAsync(this.id, this.spaceFields, this.expansions, this.userFields, this.topicFields, _callback);
        }
    }
}

