/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.TweetComplianceSchemaTweet;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TweetTakedownComplianceSchema {
    public static final String SERIALIZED_NAME_EVENT_AT = "event_at";
    @SerializedName(value="event_at")
    private OffsetDateTime eventAt;
    public static final String SERIALIZED_NAME_QUOTE_TWEET_ID = "quote_tweet_id";
    @SerializedName(value="quote_tweet_id")
    private String quoteTweetId;
    public static final String SERIALIZED_NAME_TWEET = "tweet";
    @SerializedName(value="tweet")
    private TweetComplianceSchemaTweet tweet;
    public static final String SERIALIZED_NAME_WITHHELD_IN_COUNTRIES = "withheld_in_countries";
    @SerializedName(value="withheld_in_countries")
    private List<String> withheldInCountries = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetTakedownComplianceSchema eventAt(OffsetDateTime eventAt) {
        this.eventAt = eventAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2021-07-06T18:40:40Z", required=true, value="Event time.")
    public OffsetDateTime getEventAt() {
        return this.eventAt;
    }

    public void setEventAt(OffsetDateTime eventAt) {
        this.eventAt = eventAt;
    }

    public TweetTakedownComplianceSchema quoteTweetId(String quoteTweetId) {
        this.quoteTweetId = quoteTweetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1346889436626259968", value="Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getQuoteTweetId() {
        return this.quoteTweetId;
    }

    public void setQuoteTweetId(String quoteTweetId) {
        this.quoteTweetId = quoteTweetId;
    }

    public TweetTakedownComplianceSchema tweet(TweetComplianceSchemaTweet tweet) {
        this.tweet = tweet;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public TweetComplianceSchemaTweet getTweet() {
        return this.tweet;
    }

    public void setTweet(TweetComplianceSchemaTweet tweet) {
        this.tweet = tweet;
    }

    public TweetTakedownComplianceSchema withheldInCountries(List<String> withheldInCountries) {
        this.withheldInCountries = withheldInCountries;
        return this;
    }

    public TweetTakedownComplianceSchema addWithheldInCountriesItem(String withheldInCountriesItem) {
        this.withheldInCountries.add(withheldInCountriesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<String> getWithheldInCountries() {
        return this.withheldInCountries;
    }

    public void setWithheldInCountries(List<String> withheldInCountries) {
        this.withheldInCountries = withheldInCountries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetTakedownComplianceSchema tweetTakedownComplianceSchema = (TweetTakedownComplianceSchema)o;
        return Objects.equals(this.eventAt, tweetTakedownComplianceSchema.eventAt) && Objects.equals(this.quoteTweetId, tweetTakedownComplianceSchema.quoteTweetId) && Objects.equals(this.tweet, tweetTakedownComplianceSchema.tweet) && Objects.equals(this.withheldInCountries, tweetTakedownComplianceSchema.withheldInCountries);
    }

    public int hashCode() {
        return Objects.hash(this.eventAt, this.quoteTweetId, this.tweet, this.withheldInCountries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetTakedownComplianceSchema {\n");
        sb.append("    eventAt: ").append(this.toIndentedString(this.eventAt)).append("\n");
        sb.append("    quoteTweetId: ").append(this.toIndentedString(this.quoteTweetId)).append("\n");
        sb.append("    tweet: ").append(this.toIndentedString(this.tweet)).append("\n");
        sb.append("    withheldInCountries: ").append(this.toIndentedString(this.withheldInCountries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QUOTE_TWEET_ID) != null && !jsonObj.get(SERIALIZED_NAME_QUOTE_TWEET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `quote_tweet_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUOTE_TWEET_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TWEET) != null) {
            TweetComplianceSchemaTweet.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TWEET));
        }
        if (jsonObj.get(SERIALIZED_NAME_WITHHELD_IN_COUNTRIES) != null && !jsonObj.get(SERIALIZED_NAME_WITHHELD_IN_COUNTRIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `withheld_in_countries` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WITHHELD_IN_COUNTRIES).toString()));
        }
    }

    public static TweetTakedownComplianceSchema fromJson(String jsonString) throws IOException {
        return (TweetTakedownComplianceSchema)JSON.getGson().fromJson(jsonString, TweetTakedownComplianceSchema.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EVENT_AT);
        openapiFields.add(SERIALIZED_NAME_QUOTE_TWEET_ID);
        openapiFields.add(SERIALIZED_NAME_TWEET);
        openapiFields.add(SERIALIZED_NAME_WITHHELD_IN_COUNTRIES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_TWEET);
        openapiRequiredFields.add(SERIALIZED_NAME_WITHHELD_IN_COUNTRIES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetTakedownComplianceSchema.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetTakedownComplianceSchema.class));
            return new TypeAdapter<TweetTakedownComplianceSchema>(){

                public void write(JsonWriter out, TweetTakedownComplianceSchema value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetTakedownComplianceSchema read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetTakedownComplianceSchema.validateJsonObject(jsonObj);
                    return (TweetTakedownComplianceSchema)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

