/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.concurrent.AsyncStream;
import com.twitter.concurrent.AsyncStream$;
import com.twitter.finagle.tracing.SpanId$;
import com.twitter.io.Buf;
import com.twitter.io.Reader;
import com.twitter.io.Reader$;
import com.twitter.server.handler.EventRecordingHandler$;
import com.twitter.server.handler.Percentile$;
import com.twitter.util.events.Event;
import com.twitter.util.events.Event$;
import com.twitter.util.events.Sink;
import com.twitter.util.events.Sink$;
import java.util.logging.LogRecord;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class EventsHandler$ {
    public static final EventsHandler$ MODULE$;
    private final String Html;
    private final String LineDelimitedJson;
    private final String TraceEvent;
    private final Seq<String> columns;
    private final String header;

    static {
        new EventsHandler$();
    }

    public String Html() {
        return this.Html;
    }

    public String LineDelimitedJson() {
        return this.LineDelimitedJson;
    }

    public String TraceEvent() {
        return this.TraceEvent;
    }

    public Seq<String> columns() {
        return this.columns;
    }

    public String header() {
        return this.header;
    }

    public String showObject(Object o) {
        String string2;
        Object object = o;
        if (object instanceof LogRecord) {
            LogRecord logRecord = (LogRecord)object;
            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logRecord.getLevel().toString(), logRecord.getMessage()}));
        } else {
            string2 = o.toString();
        }
        return string2;
    }

    public Buf rowOf(Event e) {
        return Buf.Utf8$.MODULE$.apply(((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{e.etype().id(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<nobr>", "</nobr>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.when().toString()})), e.longVal() == Event$.MODULE$.NoLong() ? "" : ((Object)BoxesRunTime.boxToLong((long)e.longVal())).toString(), BoxesRunTime.equals((Object)e.objectVal(), (Object)Event$.MODULE$.NoObject()) ? "" : this.showObject(e.objectVal()), e.doubleVal() == Event$.MODULE$.NoDouble() ? "" : ((Object)BoxesRunTime.boxToDouble((double)e.doubleVal())).toString(), e.traceIdVal() == Event$.MODULE$.NoTraceId() ? "" : SpanId$.MODULE$.toString(e.traceIdVal()), e.spanIdVal() == Event$.MODULE$.NoSpanId() ? "" : SpanId$.MODULE$.toString(e.spanIdVal())}))).mkString("<tr><td>", "</td><td>", "</td><td></td></tr>"));
    }

    public Buf newline(Buf buf) {
        return buf.concat(Buf.Utf8$.MODULE$.apply("\n"));
    }

    public AsyncStream<Buf> tableOf(Seq<Event> events) {
        return Percentile$.MODULE$.annotate((AsyncStream<Event>)AsyncStream$.MODULE$.fromSeq(events)).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buf apply(Event e) {
                return EventsHandler$.MODULE$.rowOf(e);
            }
        }.andThen((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buf apply(Buf buf) {
                return EventsHandler$.MODULE$.newline(buf);
            }
        }));
    }

    public String pageHtml(Sink sink) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append((Object)"\n  <h2>Events</h2>\n  <p>The server publishes interesting events during its operation and this section\n  displays a log of the most recent.</p>\n  ");
        if (Sink$.MODULE$.enabled()) {
            boolean isRecording = sink.recording();
            String onCheck = isRecording ? "checked" : "";
            String offCheck = isRecording ? "" : "checked";
            String onLoad = "\n      <script>\n         $(document).ready(function() {\n          var displayEvents = function(data) {\n            $(\"#eventTable > tbody\").html(data);\n            $(\"#filter-loading\").hide();\n            $(\"#filter-submit\").show();\n          }\n          var loadEvents = function() {\n            $(\"#filter-submit\").removeClass(\"active\");\n            $(\"#filter-submit\").hide();\n            $(\"#filter-loading\").show();\n            $(\".filter-input\").blur();\n            $(\"#eventTable > tbody\").empty();\n\n            $.post(\n              \"/admin/events\",\n              {\n                eventType: $('#eventTypeFilter').val(),\n                objectVal: $('#objectValFilter').val(),\n                spanId: $('#spanIdFilter').val(),\n                traceId: $('#traceIdFilter').val()\n              },\n              displayEvents)\n\n          }\n          $('#filter').submit(function () {\n            loadEvents();\n            return false;\n          });\n          $(':input').keypress(function (e) {\n            if (e.which == 13) {\n              $('#filter').submit();\n              return false;\n            }\n          });\n          $(\".filter-input-clear\").each(function() {\n            $(this).click(function() {\n              $(this).prev(':input').val('');\n              loadEvents();\n            });\n          });\n          $('input:radio[name=recording]').change(function() {\n            $.post(\"/admin/events/record/\" + this.value, loadEvents)\n            if (this.value == \"recordOn\") {\n              $(\"#eventTable\").show();\n            } else {\n              $(\"#eventTable\").hide();\n            }\n          });\n          if ($(\"#rec1\").prop(\"checked\") == true) {\n            loadEvents();\n          } else {\n             $(\"#eventTable\").hide()\n          }\n\n         });\n       </script>";
            String toggle = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      <div>Events are only captured when recording is enabled. Current state:</div>\n      <div class=\"radio\">\n        <label>\n          <input type=\"radio\" name=\"recording\" id=\"rec1\" value=\"", "\" ", ">\n          On\n        </label>\n      </div>\n      <div class=\"radio\">\n        <label>\n          <input type=\"radio\" name=\"recording\" id=\"rec2\" value=\"", "\" ", ">\n          Off\n        </label>\n      </div>\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EventRecordingHandler$.MODULE$.RecordOn(), onCheck, EventRecordingHandler$.MODULE$.RecordOff(), offCheck}));
            String table = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<table id=\"eventTable\" class=\"table table-condensed table-striped\">\n      <caption>A log of events originating from this server process.</caption>\n      <thead>", "</thead>\n      <tbody>\n      </tbody>\n    </table>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.header()}));
            string2 = new StringBuilder().append((Object)onLoad).append((Object)toggle).append((Object)"\n    <div class=\"fr-more\"><a\n    href=\"javascript:$('.fr-more-info').show(); $('.fr-more').hide()\"\n    >Read more...</a></div>\n    <div class=\"fr-more-info\" style=\"display:none\"><p>Event capture is currently\n    <strong>enabled</strong>. This is the default. To disable event capture,\n    use the following flag.\n    <dl class=\"dl-horizontal\">\n      <dt>sinkEnabled</dt>\n      <dd>Turn on event capture (default: true).</dd>\n    </dl></p>\n    <div>Example usage:<pre><code>\n    $ java -Dcom.twitter.util.events.sinkEnabled=false MyApp\n    </code></pre></div></div>").append((Object)table).toString();
        } else {
            string2 = "\n    <p>Event capture is currently <strong>disabled</strong>.\n    To enable event capture, use the following flags.\n    <dl class=\"dl-horizontal\">\n      <dt>sinkEnabled</dt>\n      <dd>Turn on event capture (default: true).</dd>\n      <dt>approxNumEvents</dt>\n      <dd>The number of events to keep in memory (default: 10000).</dd>\n    </dl></p>\n    <div>Example usage:<pre><code>\n    $ java -Dcom.twitter.util.events.sinkEnabled=true \\\n           -Dcom.twitter.util.events.approxNumEvents=10000 \\\n           MyApp\n    </code></pre></div>\n    ";
        }
        return stringBuilder.append((Object)string2).toString();
    }

    public Reader tableBodyHtml(Seq<Event> events) {
        return Reader$.MODULE$.concat(this.tableOf(events).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Reader apply(Buf buf) {
                return Reader$.MODULE$.fromBuf(buf);
            }
        }));
    }

    private EventsHandler$() {
        MODULE$ = this;
        this.Html = "text/html;charset=UTF-8";
        this.LineDelimitedJson = "application/x-ldjson;charset=UTF-8";
        this.TraceEvent = "trace/json;charset=UTF-8";
        this.columns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event", "When", "LongVal", "ObjectVal", "DoubleVal", "TraceID", "SpanID"}));
        this.header = new StringBuilder().append((Object)this.columns().mkString("<tr><th>", "</th><th>", "</th><th></th></tr>")).append((Object)"<tr>\n        <td>\n          <div class=\"filter-input-group\">\n            <input class=\"filter-input form-control\" id=\"eventTypeFilter\" type=\"text\">\n            <span class=\"filter-input-clear glyphicon glyphicon-remove-circle\"></span>\n          </div>\n        </td>\n        <td></td>\n        <td></td>\n        <td>\n          <div class=\"filter-input-group\">\n            <input class=\"filter-input form-control\" id=\"objectValFilter\" type=\"text\">\n            <span class=\"filter-input-clear glyphicon glyphicon-remove-circle\"></span>\n          </div>\n        </td>\n        <td></td>\n        <td>\n          <div class=\"filter-input-group\">\n            <input class=\"filter-input form-control\" id=\"traceIdFilter\" type=\"text\">\n            <span class=\"filter-input-clear glyphicon glyphicon-remove-circle\"></span>\n          </div>\n        </td>\n        <td>\n          <div class=\"filter-input-group\">\n            <input class=\"filter-input form-control\" id=\"spanIdFilter\" type=\"text\">\n            <span class=\"filter-input-clear glyphicon glyphicon-remove-circle\"></span>\n          </div>\n        </td>\n        <td>\n          <form id=\"filter\">\n            <button id=\"filter-submit\" class=\"btn btn-mini btn-primary\" type=\"submit\">Filter</button>\n            <button id=\"filter-loading\" class=\"btn btn-mini btn-primary\"><span class=\"glyphicon glyphicon-refresh glyphicon-refresh-animate\"></span> Loading</button>\n          </form>\n        </td>\n      </tr>").toString();
    }
}

